# -*- coding: utf-8 -*-
#
#*******************************************************************************
#
#  Copyright 2022 RIEGL Laser Measurement Systems
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#
#  SPDX-License-Identifier: Apache-2.0
#
#*******************************************************************************
#
"""
Database error signaling/handling
"""


class Error(Exception):
    """
    Database error class
    """

    def __init__(self, code, text, details):
        self.error_code = code
        self.error_text = text
        self.error_details = details

    def __str__(self):
        text = "{0} ({1})".format(self.error_text, self.error_code)
        if self.error_details:
            text = "{0}, {1}".format(text, self.error_details)
        return text
