#
#*******************************************************************************
#
#  Copyright 2022 RIEGL Laser Measurement Systems
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#
#  SPDX-License-Identifier: Apache-2.0
#
#*******************************************************************************
#
"""
*******************************************************************************
*
* \author  RIEGL LMS GmbH, Austria
* \brief   Description of RIEGL point attributes in RDB 2 database files
* \version 2015-11-05/AW: Initial version
* \version 2015-11-20/AW: Minimum value of "riegl.pulse_width" fixed
* \version 2016-09-30/AW: New attributes for voxel and plane patch datasets
* \version 2016-10-25/AW: Point coordinates correction vector attribute added
* \version 2016-11-17/AW: Attributes for voxel datasets updated
* \version 2016-11-23/AW: Added constants for named point attribute values
* \version 2016-12-05/AW: Compression options added
* \version 2016-12-20/AW: JSON: switched names from camel case to underscores
* \version 2017-01-20/AW: Maximum value of "riegl.pulse_width" fixed
* \version 2017-01-23/AW: New attributes for laser shots added: riegl.shot_...
* \version 2017-01-31/AW: New attributes for FWA and MTA tools added
* \version 2017-02-24/AW: Definition of riegl.covariances fixed
* \version 2017-03-02/AW: New point attribute riegl.plane_count added
* \version 2017-03-22/AW: Optional attribute scale factor added
* \version 2017-05-10/AW: Definition of riegl.plane_count fixed
* \version 2017-06-27/AW: Description of target_index and target_count fixed
* \version 2017-08-22/AW: New attributes for waveform sample blocks and values
* \version 2017-10-03/AW: Description of wfm_sbl_first and wfm_sda_first fixed
* \version 2017-10-09/AW: Definition of riegl.amplitude modified
* \version 2017-10-24/AW: New attribute riegl.line_angle_coarse added
* \version 2017-11-10/AW: Definition of riegl.timestamp modified (#2588)
* \version 2017-11-20/AW: Resolution of riegl.pca_extents increased
* \version 2017-11-21/AW: Attributes for trajectory (position+orientation) files
* \version 2017-11-22/AW: New attribute riegl.voxel_collapsed added
* \version 2017-11-22/AW: Resolution of riegl.std_dev increased
* \version 2018-01-10/AW: New attribute riegl.direction_coarse added
* \version 2018-01-15/AW: Comments of riegl.fwa updated
* \version 2018-02-14/AW: Definition of riegl.timestamp fixed (#2588)
* \version 2018-02-22/AW: Description of target_index and target_count fixed
* \version 2018-03-09/AW: New attribute property "invalid value" added (#3047)
* \version 2018-03-26/AW: Definition of riegl.temperature modified
* \version 2018-04-20/AW: Definition of riegl.[pof_]timestamp fixed (#2588)
* \version 2018-05-24/AW: Attributes for voxel and pixel datasets added
* \version 2018-06-08/AW: Attributes for waveform and echo datasets added
* \version 2018-06-25/AW: Definition of riegl.wfm_sbl_std_dev fixed
* \version 2018-06-28/AW: New attributes riegl.pps_timestamp_[ex|in]tern added
* \version 2018-07-04/AW: Invalid value for "riegl.pulse_width" added
* \version 2018-11-19/AW: New attribute riegl.direction_medium added
* \version 2018-11-28/AW: Definition of riegl.scan_angle modified
* \version 2018-12-04/AW: Definition of riegl.plane_spread removed
* \version 2019-02-25/AW: New attribute riegl.xyz_socs added
* \version 2019-03-14/AW: New attribute riegl.voxel_index added
* \version 2019-03-14/AW: New attribute riegl.voxel_linear_sums added
* \version 2019-03-14/AW: New attribute riegl.voxel_square_sums added
* \version 2019-03-14/AW: New attribute riegl.pixel_linear_sums added
* \version 2019-03-14/AW: New attribute riegl.pixel_square_sums added
* \version 2019-03-14/AW: New attribute riegl.hydro_refraction_corrected added
* \version 2019-03-14/AW: New attribute riegl.hydro_intersection_point added
* \version 2019-03-14/AW: New attribute riegl.hydro_intersection_normal added
* \version 2019-04-10/AW: Definition of riegl.xy_map and riegl.xyz_map fixed
* \version 2019-04-15/AW: Attributes were separated into groups
* \version 2019-05-16/AW: New attribute riegl.hydro_wsm_uncertainty added
* \version 2019-05-22/AW: New attribute riegl.plane_patch_distance added
* \version 2019-05-22/AW: New attribute riegl.plane_patch_angular_distance added
* \version 2019-05-22/AW: Titles of riegl.pof_satellites_* attributes fixed
* \version 2019-06-25/AW: New attribute riegl.pof_satellites_qzss added
* \version 2019-11-07/AW: Attributes riegl.pof_xyz and riegl.pof_*_ned added
* \version 2019-11-11/AW: Attribute riegl.plane_patch_lateral_distance added
* \version 2019-11-15/AW: Attribute riegl.plane_patch_link_vector added
* \version 2019-11-22/AW: Attribute riegl.plane_occupancy added
* \version 2019-11-22/AW: Attributes riegl.raw_(line|frame)_angle added
* \version 2019-11-25/AW: Attribute riegl.plane_cog_link added
* \version 2019-11-25/AW: Attribute riegl.plane_confidence_normal added
* \version 2019-12-02/AW: Attribute riegl.match_count added
* \version 2019-12-13/AW: Attributes for tie-/control objects added
* \version 2019-12-19/AW: Attributes for tie-/control objects added
* \version 2019-12-19/AW: Title and description of riegl.mta_unresolved updated
* \version 2020-01-08/AW: Move riegl.height_center/mean/min/max before riegl.point_count
* \version 2020-04-15/AW: Attribute riegl.reference_object_id updated
* \version 2020-06-12/AW: Attribute riegl.scanner_position added
* \version 2020-09-10/AW: Attribute riegl.line_angle_reduced added
* \version 2020-09-17/AW: Attribute riegl.background_radiation updated
* \version 2020-09-24/AW: Attribute riegl.background_radiation_si added
* \version 2020-09-24/AW: Attribute riegl.background_radiation_ingaas added
* \version 2020-09-24/AW: Attribute riegl.temperature_estimated_si added
* \version 2020-09-24/AW: Attribute riegl.temperature_estimated_ingaas added
* \version 2020-09-25/AW: Attribute riegl.temperature_estimated_ingaas_si added
* \version 2020-10-08/AW: Attribute riegl.window_echo_impact_corrected added
* \version 2020-11-16/AW: Attribute riegl.point_count_grid_cell added (#3720)
* \version 2020-11-26/AW: Resolution of riegl.pof_accuracy_* attributes updated (#3761)
* \version 2020-12-02/AW: Move riegl.pof_xyz after riegl.pof_yaw (#3760)
* \version 2020-12-03/AW: Add riegl.scan_line_index and riegl.shot_index_line (#3759)
* \version 2021-02-02/AW: Attribute riegl.mirror_facet updated (storage "variable")
* \version 2021-02-02/AW: Attribute riegl.plane_slope_class added (rdbplanes/#7)
* \version 2021-02-16/AW: Attribute riegl.source_cloud_count added (#3810)
* \version 2021-03-03/AW: Attribute riegl.shot_direction_levelled added (#3820)
* \version 2021-04-14/AW: Attribute riegl.obs_confidence_xy added (#3861)
* \version 2021-04-14/AW: Attribute riegl.obs_confidence_z added (#3861)
* \version 2021-04-14/AW: Attribute riegl.obs_signal_confidence_rot added (#3861)
* \version 2021-06-30/AW: Attributes riegl.pca_axis_min and _max updated (#3930)
* \version 2021-07-09/AW: Attribute riegl.extinction added (#3935)
* \version 2021-07-14/AW: Attributes riegl.svb_* added (#3945)
* \version 2021-09-08/AW: Attribute riegl.dynamic_object_point added (#3979)
* \version 2021-09-08/AW: Attribute riegl.single_source_point added (#3975)
* \version 2021-09-08/AW: Attribute riegl.mirror_object_point added (#3978)
* \version 2021-09-20/AW: Attribute riegl.plane_cluster_id added (#3997)
* \version 2021-11-04/AW: Attribute riegl.nir added (#4042)
* \version 2021-12-07/AW: Add riegl.obs_confidence_range/_theta/_phi (#4075)
* \version 2022-01-26/AW: Add optional point attribute tags (#4128)
* \version 2022-03-11/AW: Add "boolean" and "enumeration" tags (#4128)
* \version 2022-03-18/AW: Add named values for enumeration attributes (#4128)
* \version 2022-03-31/AW: Attribute riegl.source_indicator updated (#4128/17)
* \version 2022-04-13/AW: Attribute riegl.target_type added (#4188)
* \version 2022-04-20/AW: Attribute riegl.shot_biaxial_shift added (#4195)
* \version 2022-05-20/AW: Attribute riegl.cp_search_radius added (#4236)
* \version 2022-05-20/AW: Attribute riegl.cp_maximum_distance added (#4236)
* \version 2022-05-30/AW: Attribute riegl.dyntrig_uncertain_point added (#4217)
* \version 2022-08-16/AW: Attribute riegl.segment_id added (#4307)
* \version 2022-09-06/AW: Attribute renamed to riegl.mta_uncertain_point (#4335)
* \version 2022-10-06/AW: Attribute riegl.rgba updated (description)
* \version 2022-10-10/AW: Add "NED" suffix to the titles of "riegl.pof_*_ned"
* \version 2022-11-09/AW: Attribute riegl.pof_age_of_corrections added (#4412)
* \version 2022-11-09/AW: Attribute riegl.pof_baseline_length added (#4412)
* \version 2022-11-09/AW: Attribute riegl.pof_solution_gnss added (#4412)
*
*******************************************************************************
"""

# Point attribute definition version
RDB_POINT_ATTRIBUTES_VERSION = "1.4.1"
RDB_POINT_ATTRIBUTES_DATE = "2022-11-09"

# Invalid value
RDB_NO_INVALID_VALUE = float("nan") # attribute has no invalid value

# Storage classes
RDB_STORAGE_CONSTANT = 1  # value cannot be changed
RDB_STORAGE_VARIABLE = 2  # value can change from time to time
RDB_STORAGE_DYNAMIC = 3  # value is likely to be changed often

# Compression options
RDB_COMPRESSION_DEFAULT = 0  # nothing special, just use default compression algorithm
RDB_COMPRESSION_DELTA = 1  # calculate differences between two consecutive values
RDB_COMPRESSION_SHUFFLE = 2  # shuffle bytes of point attribute values
RDB_COMPRESSION_DELTA_SHUFFLE = 3  # calculate differences and shuffle bytes

# Point attribute tags
RDB_TAG_BOOLEAN = "boolean"  # state/flag
RDB_TAG_COLOR = "color"  # color values
RDB_TAG_DIRECTION = "direction"  # direction vector
RDB_TAG_ENUMERATION = "enumeration"  # finite set of unique values, optionally with a name
RDB_TAG_POSITION = "position"  # position vector
RDB_TAG_TRANSFORM = "transform"  # transform position or direction vector during import/export

# ______________________________________________________________________________
#
# POINT ATTRIBUTE GROUP "Coordinates/Vectors"
# ______________________________________________________________________________
#

# Cartesian point coordinates wrt. application coordinate system (0: X, 1: Y, 2: Z)
RDB_RIEGL_XYZ                     = "riegl.xyz"
RDB_RIEGL_XYZ_NAME                = "riegl.xyz"
RDB_RIEGL_XYZ_TITLE               = "XYZ"
RDB_RIEGL_XYZ_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_XYZ_TAGS                = "position, transform"
RDB_RIEGL_XYZ_DESCRIPTION         = "Cartesian point coordinates wrt. application coordinate system (0: X, 1: Y, 2: Z)"
RDB_RIEGL_XYZ_UNIT                = "m"
RDB_RIEGL_XYZ_LENGTH              = 3
RDB_RIEGL_XYZ_RESOLUTION          = 0.00025
RDB_RIEGL_XYZ_MINIMUM             = -535000.0
RDB_RIEGL_XYZ_MAXIMUM             = 535000.0
RDB_RIEGL_XYZ_DEFAULT             = 0.0
RDB_RIEGL_XYZ_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_XYZ_NAMED_VALUES        = ""
RDB_RIEGL_XYZ_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_XYZ_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_XYZ_LOD_SETTINGS        = "default"
RDB_RIEGL_XYZ_SCALE               = 1.0
#
RDB_RIEGL_XYZ_X = 0
RDB_RIEGL_XYZ_Y = 1
RDB_RIEGL_XYZ_Z = 2

# Cartesian point coordinates wrt. scanner's coordinate system (0: X, 1: Y, 2: Z)
RDB_RIEGL_XYZ_SOCS                     = "riegl.xyz_socs"
RDB_RIEGL_XYZ_SOCS_NAME                = "riegl.xyz_socs"
RDB_RIEGL_XYZ_SOCS_TITLE               = "XYZ SOCS"
RDB_RIEGL_XYZ_SOCS_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_XYZ_SOCS_TAGS                = "position"
RDB_RIEGL_XYZ_SOCS_DESCRIPTION         = "Cartesian point coordinates wrt. scanner's coordinate system (0: X, 1: Y, 2: Z)"
RDB_RIEGL_XYZ_SOCS_UNIT                = "m"
RDB_RIEGL_XYZ_SOCS_LENGTH              = 3
RDB_RIEGL_XYZ_SOCS_RESOLUTION          = 0.00025
RDB_RIEGL_XYZ_SOCS_MINIMUM             = -535000.0
RDB_RIEGL_XYZ_SOCS_MAXIMUM             = 535000.0
RDB_RIEGL_XYZ_SOCS_DEFAULT             = 0.0
RDB_RIEGL_XYZ_SOCS_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_XYZ_SOCS_NAMED_VALUES        = ""
RDB_RIEGL_XYZ_SOCS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_XYZ_SOCS_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_XYZ_SOCS_LOD_SETTINGS        = "default"
RDB_RIEGL_XYZ_SOCS_SCALE               = 1.0
#
RDB_RIEGL_XYZ_SOCS_X = 0
RDB_RIEGL_XYZ_SOCS_Y = 1
RDB_RIEGL_XYZ_SOCS_Z = 2

# Point coordinates wrt. a projected CRS (e.g. Web Mercator EPSG:3857, 0: Easting, 1: Northing, 2: Height)
RDB_RIEGL_XYZ_MAP                     = "riegl.xyz_map"
RDB_RIEGL_XYZ_MAP_NAME                = "riegl.xyz_map"
RDB_RIEGL_XYZ_MAP_TITLE               = "XYZ Map"
RDB_RIEGL_XYZ_MAP_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_XYZ_MAP_TAGS                = "position, transform"
RDB_RIEGL_XYZ_MAP_DESCRIPTION         = "Point coordinates wrt. a projected CRS (e.g. Web Mercator EPSG:3857, 0: Easting, 1: Northing, 2: Height)"
RDB_RIEGL_XYZ_MAP_UNIT                = "m"
RDB_RIEGL_XYZ_MAP_LENGTH              = 3
RDB_RIEGL_XYZ_MAP_RESOLUTION          = 0.00025
RDB_RIEGL_XYZ_MAP_MINIMUM             = -20037508.343
RDB_RIEGL_XYZ_MAP_MAXIMUM             = 20037508.343
RDB_RIEGL_XYZ_MAP_DEFAULT             = 0.0
RDB_RIEGL_XYZ_MAP_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_XYZ_MAP_NAMED_VALUES        = ""
RDB_RIEGL_XYZ_MAP_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_XYZ_MAP_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_XYZ_MAP_LOD_SETTINGS        = "default"
RDB_RIEGL_XYZ_MAP_SCALE               = 1.0
#
RDB_RIEGL_XYZ_MAP_EASTING = 0
RDB_RIEGL_XYZ_MAP_NORTHING = 1
RDB_RIEGL_XYZ_MAP_HEIGHT = 2

# Point coordinates wrt. a projected CRS (e.g. Web Mercator EPSG:3857, 0: Easting, 1: Northing)
RDB_RIEGL_XY_MAP                     = "riegl.xy_map"
RDB_RIEGL_XY_MAP_NAME                = "riegl.xy_map"
RDB_RIEGL_XY_MAP_TITLE               = "XY Map"
RDB_RIEGL_XY_MAP_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_XY_MAP_TAGS                = "position, transform"
RDB_RIEGL_XY_MAP_DESCRIPTION         = "Point coordinates wrt. a projected CRS (e.g. Web Mercator EPSG:3857, 0: Easting, 1: Northing)"
RDB_RIEGL_XY_MAP_UNIT                = "m"
RDB_RIEGL_XY_MAP_LENGTH              = 2
RDB_RIEGL_XY_MAP_RESOLUTION          = 0.00933069192934280443318950659659094526432454586029052734375
RDB_RIEGL_XY_MAP_MINIMUM             = -20037508.3427892439067363739013671875
RDB_RIEGL_XY_MAP_MAXIMUM             = 20037508.333458550274372100830078125
RDB_RIEGL_XY_MAP_DEFAULT             = 0.0
RDB_RIEGL_XY_MAP_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_XY_MAP_NAMED_VALUES        = ""
RDB_RIEGL_XY_MAP_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_XY_MAP_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_XY_MAP_LOD_SETTINGS        = "default"
RDB_RIEGL_XY_MAP_SCALE               = 1.0
#
RDB_RIEGL_XY_MAP_EASTING = 0
RDB_RIEGL_XY_MAP_NORTHING = 1

# Corrections that were applied (added) to the Cartesian point coordinates (0: X, 1: Y, 2: Z)
RDB_RIEGL_XYZ_CORRECTIONS                     = "riegl.xyz_corrections"
RDB_RIEGL_XYZ_CORRECTIONS_NAME                = "riegl.xyz_corrections"
RDB_RIEGL_XYZ_CORRECTIONS_TITLE               = "XYZ Corrections"
RDB_RIEGL_XYZ_CORRECTIONS_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_XYZ_CORRECTIONS_TAGS                = "direction, transform"
RDB_RIEGL_XYZ_CORRECTIONS_DESCRIPTION         = "Corrections that were applied (added) to the Cartesian point coordinates (0: X, 1: Y, 2: Z)"
RDB_RIEGL_XYZ_CORRECTIONS_UNIT                = "m"
RDB_RIEGL_XYZ_CORRECTIONS_LENGTH              = 3
RDB_RIEGL_XYZ_CORRECTIONS_RESOLUTION          = 0.00025
RDB_RIEGL_XYZ_CORRECTIONS_MINIMUM             = -5000.0
RDB_RIEGL_XYZ_CORRECTIONS_MAXIMUM             = 5000.0
RDB_RIEGL_XYZ_CORRECTIONS_DEFAULT             = 0.0
RDB_RIEGL_XYZ_CORRECTIONS_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_XYZ_CORRECTIONS_NAMED_VALUES        = ""
RDB_RIEGL_XYZ_CORRECTIONS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_XYZ_CORRECTIONS_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_XYZ_CORRECTIONS_LOD_SETTINGS        = "default"
RDB_RIEGL_XYZ_CORRECTIONS_SCALE               = 1.0
#
RDB_RIEGL_XYZ_CORRECTIONS_X = 0
RDB_RIEGL_XYZ_CORRECTIONS_Y = 1
RDB_RIEGL_XYZ_CORRECTIONS_Z = 2

# Target distance wrt. SOCS origin
RDB_RIEGL_RANGE                     = "riegl.range"
RDB_RIEGL_RANGE_NAME                = "riegl.range"
RDB_RIEGL_RANGE_TITLE               = "Range"
RDB_RIEGL_RANGE_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_RANGE_TAGS                = ""
RDB_RIEGL_RANGE_DESCRIPTION         = "Target distance wrt. SOCS origin"
RDB_RIEGL_RANGE_UNIT                = "m"
RDB_RIEGL_RANGE_LENGTH              = 1
RDB_RIEGL_RANGE_RESOLUTION          = 0.00025
RDB_RIEGL_RANGE_MINIMUM             = 0.0
RDB_RIEGL_RANGE_MAXIMUM             = 50000.0
RDB_RIEGL_RANGE_DEFAULT             = 0.0
RDB_RIEGL_RANGE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_RANGE_NAMED_VALUES        = ""
RDB_RIEGL_RANGE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_RANGE_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_RANGE_LOD_SETTINGS        = "default"
RDB_RIEGL_RANGE_SCALE               = 1.0

# Polar angle (inclination) wrt. SOCS (0..180°)
RDB_RIEGL_THETA                     = "riegl.theta"
RDB_RIEGL_THETA_NAME                = "riegl.theta"
RDB_RIEGL_THETA_TITLE               = "Theta"
RDB_RIEGL_THETA_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_THETA_TAGS                = ""
RDB_RIEGL_THETA_DESCRIPTION         = "Polar angle (inclination) wrt. SOCS (0..180°)"
RDB_RIEGL_THETA_UNIT                = "deg"
RDB_RIEGL_THETA_LENGTH              = 1
RDB_RIEGL_THETA_RESOLUTION          = 1.0e-6
RDB_RIEGL_THETA_MINIMUM             = 0.0
RDB_RIEGL_THETA_MAXIMUM             = 180.0
RDB_RIEGL_THETA_DEFAULT             = 0.0
RDB_RIEGL_THETA_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_THETA_NAMED_VALUES        = ""
RDB_RIEGL_THETA_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_THETA_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_THETA_LOD_SETTINGS        = "default"
RDB_RIEGL_THETA_SCALE               = 1.0

# Azimuthal angle wrt. SOCS (0..360°)
RDB_RIEGL_PHI                     = "riegl.phi"
RDB_RIEGL_PHI_NAME                = "riegl.phi"
RDB_RIEGL_PHI_TITLE               = "Phi"
RDB_RIEGL_PHI_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_PHI_TAGS                = ""
RDB_RIEGL_PHI_DESCRIPTION         = "Azimuthal angle wrt. SOCS (0..360°)"
RDB_RIEGL_PHI_UNIT                = "deg"
RDB_RIEGL_PHI_LENGTH              = 1
RDB_RIEGL_PHI_RESOLUTION          = 1.0e-6
RDB_RIEGL_PHI_MINIMUM             = 0.0
RDB_RIEGL_PHI_MAXIMUM             = 360.0
RDB_RIEGL_PHI_DEFAULT             = 0.0
RDB_RIEGL_PHI_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_PHI_NAMED_VALUES        = ""
RDB_RIEGL_PHI_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PHI_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_PHI_LOD_SETTINGS        = "default"
RDB_RIEGL_PHI_SCALE               = 1.0

# Cartesian coordinates of the scanner position wrt. application coordinate system (0: X, 1: Y, 2: Z)
RDB_RIEGL_SCANNER_POSITION                     = "riegl.scanner_position"
RDB_RIEGL_SCANNER_POSITION_NAME                = "riegl.scanner_position"
RDB_RIEGL_SCANNER_POSITION_TITLE               = "Scanner Position"
RDB_RIEGL_SCANNER_POSITION_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_SCANNER_POSITION_TAGS                = "position, transform"
RDB_RIEGL_SCANNER_POSITION_DESCRIPTION         = "Cartesian coordinates of the scanner position wrt. application coordinate system (0: X, 1: Y, 2: Z)"
RDB_RIEGL_SCANNER_POSITION_UNIT                = "m"
RDB_RIEGL_SCANNER_POSITION_LENGTH              = 3
RDB_RIEGL_SCANNER_POSITION_RESOLUTION          = 0.00025
RDB_RIEGL_SCANNER_POSITION_MINIMUM             = -535000.0
RDB_RIEGL_SCANNER_POSITION_MAXIMUM             = 535000.0
RDB_RIEGL_SCANNER_POSITION_DEFAULT             = 0.0
RDB_RIEGL_SCANNER_POSITION_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SCANNER_POSITION_NAMED_VALUES        = ""
RDB_RIEGL_SCANNER_POSITION_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SCANNER_POSITION_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_SCANNER_POSITION_LOD_SETTINGS        = "default"
RDB_RIEGL_SCANNER_POSITION_SCALE               = 1.0

# Laser beam direction vector wrt. application coordinate system (0: X, 1: Y, 2: Z)
RDB_RIEGL_DIRECTION                     = "riegl.direction"
RDB_RIEGL_DIRECTION_NAME                = "riegl.direction"
RDB_RIEGL_DIRECTION_TITLE               = "Direction"
RDB_RIEGL_DIRECTION_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_DIRECTION_TAGS                = "direction, transform"
RDB_RIEGL_DIRECTION_DESCRIPTION         = "Laser beam direction vector wrt. application coordinate system (0: X, 1: Y, 2: Z)"
RDB_RIEGL_DIRECTION_UNIT                = ""
RDB_RIEGL_DIRECTION_LENGTH              = 3
RDB_RIEGL_DIRECTION_RESOLUTION          = 0.000031
RDB_RIEGL_DIRECTION_MINIMUM             = -1.0
RDB_RIEGL_DIRECTION_MAXIMUM             = 1.0
RDB_RIEGL_DIRECTION_DEFAULT             = 0.0
RDB_RIEGL_DIRECTION_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_DIRECTION_NAMED_VALUES        = ""
RDB_RIEGL_DIRECTION_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_DIRECTION_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_DIRECTION_LOD_SETTINGS        = "default"
RDB_RIEGL_DIRECTION_SCALE               = 1.0
#
RDB_RIEGL_DIRECTION_X = 0
RDB_RIEGL_DIRECTION_Y = 1
RDB_RIEGL_DIRECTION_Z = 2

# Laser beam direction vector wrt. application coordinate system (0: X, 1: Y, 2: Z)
RDB_RIEGL_DIRECTION_MEDIUM                     = "riegl.direction_medium"
RDB_RIEGL_DIRECTION_MEDIUM_NAME                = "riegl.direction_medium"
RDB_RIEGL_DIRECTION_MEDIUM_TITLE               = "Direction"
RDB_RIEGL_DIRECTION_MEDIUM_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_DIRECTION_MEDIUM_TAGS                = "direction, transform"
RDB_RIEGL_DIRECTION_MEDIUM_DESCRIPTION         = "Laser beam direction vector wrt. application coordinate system (0: X, 1: Y, 2: Z)"
RDB_RIEGL_DIRECTION_MEDIUM_UNIT                = ""
RDB_RIEGL_DIRECTION_MEDIUM_LENGTH              = 3
RDB_RIEGL_DIRECTION_MEDIUM_RESOLUTION          = 0.0007
RDB_RIEGL_DIRECTION_MEDIUM_MINIMUM             = -1.0
RDB_RIEGL_DIRECTION_MEDIUM_MAXIMUM             = 1.0
RDB_RIEGL_DIRECTION_MEDIUM_DEFAULT             = 0.0
RDB_RIEGL_DIRECTION_MEDIUM_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_DIRECTION_MEDIUM_NAMED_VALUES        = ""
RDB_RIEGL_DIRECTION_MEDIUM_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_DIRECTION_MEDIUM_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_DIRECTION_MEDIUM_LOD_SETTINGS        = "default"
RDB_RIEGL_DIRECTION_MEDIUM_SCALE               = 1.0
#
RDB_RIEGL_DIRECTION_MEDIUM_X = 0
RDB_RIEGL_DIRECTION_MEDIUM_Y = 1
RDB_RIEGL_DIRECTION_MEDIUM_Z = 2

# Coarse laser beam direction vector wrt. application coordinate system (0: X, 1: Y, 2: Z)
RDB_RIEGL_DIRECTION_COARSE                     = "riegl.direction_coarse"
RDB_RIEGL_DIRECTION_COARSE_NAME                = "riegl.direction_coarse"
RDB_RIEGL_DIRECTION_COARSE_TITLE               = "Direction"
RDB_RIEGL_DIRECTION_COARSE_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_DIRECTION_COARSE_TAGS                = "direction, transform"
RDB_RIEGL_DIRECTION_COARSE_DESCRIPTION         = "Coarse laser beam direction vector wrt. application coordinate system (0: X, 1: Y, 2: Z)"
RDB_RIEGL_DIRECTION_COARSE_UNIT                = ""
RDB_RIEGL_DIRECTION_COARSE_LENGTH              = 3
RDB_RIEGL_DIRECTION_COARSE_RESOLUTION          = 0.015
RDB_RIEGL_DIRECTION_COARSE_MINIMUM             = -1.0
RDB_RIEGL_DIRECTION_COARSE_MAXIMUM             = 1.0
RDB_RIEGL_DIRECTION_COARSE_DEFAULT             = 0.0
RDB_RIEGL_DIRECTION_COARSE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_DIRECTION_COARSE_NAMED_VALUES        = ""
RDB_RIEGL_DIRECTION_COARSE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_DIRECTION_COARSE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_DIRECTION_COARSE_LOD_SETTINGS        = "default"
RDB_RIEGL_DIRECTION_COARSE_SCALE               = 1.0
#
RDB_RIEGL_DIRECTION_COARSE_X = 0
RDB_RIEGL_DIRECTION_COARSE_Y = 1
RDB_RIEGL_DIRECTION_COARSE_Z = 2

# Laser beam origin wrt. SOCS (0: X, 1: Y, 2: Z)
RDB_RIEGL_SHOT_ORIGIN                     = "riegl.shot_origin"
RDB_RIEGL_SHOT_ORIGIN_NAME                = "riegl.shot_origin"
RDB_RIEGL_SHOT_ORIGIN_TITLE               = "Laser Shot Origin"
RDB_RIEGL_SHOT_ORIGIN_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_SHOT_ORIGIN_TAGS                = "position"
RDB_RIEGL_SHOT_ORIGIN_DESCRIPTION         = "Laser beam origin wrt. SOCS (0: X, 1: Y, 2: Z)"
RDB_RIEGL_SHOT_ORIGIN_UNIT                = "m"
RDB_RIEGL_SHOT_ORIGIN_LENGTH              = 3
RDB_RIEGL_SHOT_ORIGIN_RESOLUTION          = 250.0e-6
RDB_RIEGL_SHOT_ORIGIN_MINIMUM             = -8.0
RDB_RIEGL_SHOT_ORIGIN_MAXIMUM             = 8.0
RDB_RIEGL_SHOT_ORIGIN_DEFAULT             = 0.0
RDB_RIEGL_SHOT_ORIGIN_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SHOT_ORIGIN_NAMED_VALUES        = ""
RDB_RIEGL_SHOT_ORIGIN_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_SHOT_ORIGIN_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_SHOT_ORIGIN_LOD_SETTINGS        = "default"
RDB_RIEGL_SHOT_ORIGIN_SCALE               = 1.0
#
RDB_RIEGL_SHOT_ORIGIN_X = 0
RDB_RIEGL_SHOT_ORIGIN_Y = 1
RDB_RIEGL_SHOT_ORIGIN_Z = 2

# Laser beam biaxial shift vector wrt. SOCS (0: X, 1: Y, 2: Z)
RDB_RIEGL_SHOT_BIAXIAL_SHIFT                     = "riegl.shot_biaxial_shift"
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_NAME                = "riegl.shot_biaxial_shift"
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_TITLE               = "Laser Shot Biaxial Shift"
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_TAGS                = "direction"
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_DESCRIPTION         = "Laser beam biaxial shift vector wrt. SOCS (0: X, 1: Y, 2: Z)"
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_UNIT                = "m"
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_LENGTH              = 3
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_RESOLUTION          = 250.0e-6
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_MINIMUM             = -1.0
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_MAXIMUM             = 1.0
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_DEFAULT             = 0.0
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_NAMED_VALUES        = ""
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_LOD_SETTINGS        = "default"
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_SCALE               = 1.0
#
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_X = 0
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_Y = 1
RDB_RIEGL_SHOT_BIAXIAL_SHIFT_Z = 2

# Laser beam direction vector wrt. SOCS (0: X, 1: Y, 2: Z)
RDB_RIEGL_SHOT_DIRECTION                     = "riegl.shot_direction"
RDB_RIEGL_SHOT_DIRECTION_NAME                = "riegl.shot_direction"
RDB_RIEGL_SHOT_DIRECTION_TITLE               = "Laser Shot Direction"
RDB_RIEGL_SHOT_DIRECTION_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_SHOT_DIRECTION_TAGS                = "direction"
RDB_RIEGL_SHOT_DIRECTION_DESCRIPTION         = "Laser beam direction vector wrt. SOCS (0: X, 1: Y, 2: Z)"
RDB_RIEGL_SHOT_DIRECTION_UNIT                = ""
RDB_RIEGL_SHOT_DIRECTION_LENGTH              = 3
RDB_RIEGL_SHOT_DIRECTION_RESOLUTION          = 250.0e-9
RDB_RIEGL_SHOT_DIRECTION_MINIMUM             = -1.0
RDB_RIEGL_SHOT_DIRECTION_MAXIMUM             = 1.0
RDB_RIEGL_SHOT_DIRECTION_DEFAULT             = 0.0
RDB_RIEGL_SHOT_DIRECTION_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SHOT_DIRECTION_NAMED_VALUES        = ""
RDB_RIEGL_SHOT_DIRECTION_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_SHOT_DIRECTION_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_SHOT_DIRECTION_LOD_SETTINGS        = "default"
RDB_RIEGL_SHOT_DIRECTION_SCALE               = 1.0
#
RDB_RIEGL_SHOT_DIRECTION_X = 0
RDB_RIEGL_SHOT_DIRECTION_Y = 1
RDB_RIEGL_SHOT_DIRECTION_Z = 2

# Laser beam direction vector wrt. ROCS (0: X, 1: Y, 2: Z)
RDB_RIEGL_SHOT_DIRECTION_LEVELLED                     = "riegl.shot_direction_levelled"
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_NAME                = "riegl.shot_direction_levelled"
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_TITLE               = "Laser Shot Direction Levelled"
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_TAGS                = "direction, transform"
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_DESCRIPTION         = "Laser beam direction vector wrt. ROCS (0: X, 1: Y, 2: Z)"
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_UNIT                = ""
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_LENGTH              = 3
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_RESOLUTION          = 250.0e-9
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_MINIMUM             = -1.0
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_MAXIMUM             = 1.0
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_DEFAULT             = 0.0
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_NAMED_VALUES        = ""
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_LOD_SETTINGS        = "default"
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_SCALE               = 1.0
#
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_X = 0
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_Y = 1
RDB_RIEGL_SHOT_DIRECTION_LEVELLED_Z = 2

# Target surface normal vector wrt. application coordinate system (0: X, 1: Y, 2: Z)
RDB_RIEGL_SURFACE_NORMAL                     = "riegl.surface_normal"
RDB_RIEGL_SURFACE_NORMAL_NAME                = "riegl.surface_normal"
RDB_RIEGL_SURFACE_NORMAL_TITLE               = "Surface Normal"
RDB_RIEGL_SURFACE_NORMAL_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_SURFACE_NORMAL_TAGS                = "direction, transform"
RDB_RIEGL_SURFACE_NORMAL_DESCRIPTION         = "Target surface normal vector wrt. application coordinate system (0: X, 1: Y, 2: Z)"
RDB_RIEGL_SURFACE_NORMAL_UNIT                = ""
RDB_RIEGL_SURFACE_NORMAL_LENGTH              = 3
RDB_RIEGL_SURFACE_NORMAL_RESOLUTION          = 0.000031
RDB_RIEGL_SURFACE_NORMAL_MINIMUM             = -1.0
RDB_RIEGL_SURFACE_NORMAL_MAXIMUM             = 1.0
RDB_RIEGL_SURFACE_NORMAL_DEFAULT             = 0.0
RDB_RIEGL_SURFACE_NORMAL_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SURFACE_NORMAL_NAMED_VALUES        = ""
RDB_RIEGL_SURFACE_NORMAL_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SURFACE_NORMAL_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_SURFACE_NORMAL_LOD_SETTINGS        = "default"
RDB_RIEGL_SURFACE_NORMAL_SCALE               = 1.0
#
RDB_RIEGL_SURFACE_NORMAL_X = 0
RDB_RIEGL_SURFACE_NORMAL_Y = 1
RDB_RIEGL_SURFACE_NORMAL_Z = 2

# Direction vector of shorter edge of plane patch wrt. application coordinate system (0: X, 1: Y, 2: Z)
RDB_RIEGL_PLANE_UP                     = "riegl.plane_up"
RDB_RIEGL_PLANE_UP_NAME                = "riegl.plane_up"
RDB_RIEGL_PLANE_UP_TITLE               = "Plane Patch Up Vector"
RDB_RIEGL_PLANE_UP_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_PLANE_UP_TAGS                = "direction, transform"
RDB_RIEGL_PLANE_UP_DESCRIPTION         = "Direction vector of shorter edge of plane patch wrt. application coordinate system (0: X, 1: Y, 2: Z)"
RDB_RIEGL_PLANE_UP_UNIT                = ""
RDB_RIEGL_PLANE_UP_LENGTH              = 3
RDB_RIEGL_PLANE_UP_RESOLUTION          = 0.000031
RDB_RIEGL_PLANE_UP_MINIMUM             = -1.0
RDB_RIEGL_PLANE_UP_MAXIMUM             = 1.0
RDB_RIEGL_PLANE_UP_DEFAULT             = 0.0
RDB_RIEGL_PLANE_UP_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_PLANE_UP_NAMED_VALUES        = ""
RDB_RIEGL_PLANE_UP_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PLANE_UP_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_PLANE_UP_LOD_SETTINGS        = "default"
RDB_RIEGL_PLANE_UP_SCALE               = 1.0
#
RDB_RIEGL_PLANE_UP_X = 0
RDB_RIEGL_PLANE_UP_Y = 1
RDB_RIEGL_PLANE_UP_Z = 2

# Vector connecting the center point of a plane patch with its center of gravity (0: X, 1: Y, 2: Z)
RDB_RIEGL_PLANE_COG_LINK                     = "riegl.plane_cog_link"
RDB_RIEGL_PLANE_COG_LINK_NAME                = "riegl.plane_cog_link"
RDB_RIEGL_PLANE_COG_LINK_TITLE               = "Plane COG Link Vector"
RDB_RIEGL_PLANE_COG_LINK_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_PLANE_COG_LINK_TAGS                = "direction, transform"
RDB_RIEGL_PLANE_COG_LINK_DESCRIPTION         = "Vector connecting the center point of a plane patch with its center of gravity (0: X, 1: Y, 2: Z)"
RDB_RIEGL_PLANE_COG_LINK_UNIT                = "m"
RDB_RIEGL_PLANE_COG_LINK_LENGTH              = 3
RDB_RIEGL_PLANE_COG_LINK_RESOLUTION          = 0.00025
RDB_RIEGL_PLANE_COG_LINK_MINIMUM             = -5000.0
RDB_RIEGL_PLANE_COG_LINK_MAXIMUM             = 5000.0
RDB_RIEGL_PLANE_COG_LINK_DEFAULT             = 0.0
RDB_RIEGL_PLANE_COG_LINK_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_PLANE_COG_LINK_NAMED_VALUES        = ""
RDB_RIEGL_PLANE_COG_LINK_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PLANE_COG_LINK_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PLANE_COG_LINK_LOD_SETTINGS        = "default"
RDB_RIEGL_PLANE_COG_LINK_SCALE               = 1.0
#
RDB_RIEGL_PLANE_COG_LINK_X = 0
RDB_RIEGL_PLANE_COG_LINK_Y = 1
RDB_RIEGL_PLANE_COG_LINK_Z = 2

# Vector interconnecting the centers (riegl.xyz) of two matched plane patches (0: X, 1: Y, 2: Z)
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR                     = "riegl.plane_patch_link_vector"
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_NAME                = "riegl.plane_patch_link_vector"
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_TITLE               = "Plane Patch Link Vector"
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_TAGS                = "direction, transform"
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_DESCRIPTION         = "Vector interconnecting the centers (riegl.xyz) of two matched plane patches (0: X, 1: Y, 2: Z)"
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_UNIT                = "m"
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_LENGTH              = 3
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_RESOLUTION          = 0.00025
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_MINIMUM             = -5000.0
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_MAXIMUM             = 5000.0
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_DEFAULT             = 0.0
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_NAMED_VALUES        = ""
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_LOD_SETTINGS        = "default"
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_SCALE               = 1.0
#
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_X = 0
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_Y = 1
RDB_RIEGL_PLANE_PATCH_LINK_VECTOR_Z = 2

# The eigenvector that belongs to the smallest eigenvalue (result of PCA, 0: X, 1: Y, 2: Z)
RDB_RIEGL_PCA_AXIS_MIN                     = "riegl.pca_axis_min"
RDB_RIEGL_PCA_AXIS_MIN_NAME                = "riegl.pca_axis_min"
RDB_RIEGL_PCA_AXIS_MIN_TITLE               = "PCA Axis Minimum"
RDB_RIEGL_PCA_AXIS_MIN_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_PCA_AXIS_MIN_TAGS                = "direction, transform"
RDB_RIEGL_PCA_AXIS_MIN_DESCRIPTION         = "The eigenvector that belongs to the smallest eigenvalue (result of PCA, 0: X, 1: Y, 2: Z)"
RDB_RIEGL_PCA_AXIS_MIN_UNIT                = ""
RDB_RIEGL_PCA_AXIS_MIN_LENGTH              = 3
RDB_RIEGL_PCA_AXIS_MIN_RESOLUTION          = 0.000031
RDB_RIEGL_PCA_AXIS_MIN_MINIMUM             = -1.0
RDB_RIEGL_PCA_AXIS_MIN_MAXIMUM             = 1.0
RDB_RIEGL_PCA_AXIS_MIN_DEFAULT             = 0.0
RDB_RIEGL_PCA_AXIS_MIN_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_PCA_AXIS_MIN_NAMED_VALUES        = ""
RDB_RIEGL_PCA_AXIS_MIN_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PCA_AXIS_MIN_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_PCA_AXIS_MIN_LOD_SETTINGS        = "default"
RDB_RIEGL_PCA_AXIS_MIN_SCALE               = 1.0
#
RDB_RIEGL_PCA_AXIS_MIN_X = 0
RDB_RIEGL_PCA_AXIS_MIN_Y = 1
RDB_RIEGL_PCA_AXIS_MIN_Z = 2

# The eigenvector that belongs to the greatest eigenvalue (result of PCA, 0: X, 1: Y, 2: Z)
RDB_RIEGL_PCA_AXIS_MAX                     = "riegl.pca_axis_max"
RDB_RIEGL_PCA_AXIS_MAX_NAME                = "riegl.pca_axis_max"
RDB_RIEGL_PCA_AXIS_MAX_TITLE               = "PCA Axis Maximum"
RDB_RIEGL_PCA_AXIS_MAX_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_PCA_AXIS_MAX_TAGS                = "direction, transform"
RDB_RIEGL_PCA_AXIS_MAX_DESCRIPTION         = "The eigenvector that belongs to the greatest eigenvalue (result of PCA, 0: X, 1: Y, 2: Z)"
RDB_RIEGL_PCA_AXIS_MAX_UNIT                = ""
RDB_RIEGL_PCA_AXIS_MAX_LENGTH              = 3
RDB_RIEGL_PCA_AXIS_MAX_RESOLUTION          = 0.000031
RDB_RIEGL_PCA_AXIS_MAX_MINIMUM             = -1.0
RDB_RIEGL_PCA_AXIS_MAX_MAXIMUM             = 1.0
RDB_RIEGL_PCA_AXIS_MAX_DEFAULT             = 0.0
RDB_RIEGL_PCA_AXIS_MAX_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_PCA_AXIS_MAX_NAMED_VALUES        = ""
RDB_RIEGL_PCA_AXIS_MAX_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PCA_AXIS_MAX_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_PCA_AXIS_MAX_LOD_SETTINGS        = "default"
RDB_RIEGL_PCA_AXIS_MAX_SCALE               = 1.0
#
RDB_RIEGL_PCA_AXIS_MAX_X = 0
RDB_RIEGL_PCA_AXIS_MAX_Y = 1
RDB_RIEGL_PCA_AXIS_MAX_Z = 2

# Direction of x-axis of model coordinate system wrt. application coordinate system (0: X, 1: Y, 2: Z)
RDB_RIEGL_MODEL_CS_AXIS_X                     = "riegl.model_cs_axis_x"
RDB_RIEGL_MODEL_CS_AXIS_X_NAME                = "riegl.model_cs_axis_x"
RDB_RIEGL_MODEL_CS_AXIS_X_TITLE               = "Model CS X axis"
RDB_RIEGL_MODEL_CS_AXIS_X_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_MODEL_CS_AXIS_X_TAGS                = "direction, transform"
RDB_RIEGL_MODEL_CS_AXIS_X_DESCRIPTION         = "Direction of x-axis of model coordinate system wrt. application coordinate system (0: X, 1: Y, 2: Z)"
RDB_RIEGL_MODEL_CS_AXIS_X_UNIT                = ""
RDB_RIEGL_MODEL_CS_AXIS_X_LENGTH              = 3
RDB_RIEGL_MODEL_CS_AXIS_X_RESOLUTION          = 3.125e-05
RDB_RIEGL_MODEL_CS_AXIS_X_MINIMUM             = -1.0
RDB_RIEGL_MODEL_CS_AXIS_X_MAXIMUM             = 1.0
RDB_RIEGL_MODEL_CS_AXIS_X_DEFAULT             = 0.0
RDB_RIEGL_MODEL_CS_AXIS_X_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_MODEL_CS_AXIS_X_NAMED_VALUES        = ""
RDB_RIEGL_MODEL_CS_AXIS_X_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_MODEL_CS_AXIS_X_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_MODEL_CS_AXIS_X_LOD_SETTINGS        = "default"
RDB_RIEGL_MODEL_CS_AXIS_X_SCALE               = 1.0
#
RDB_RIEGL_MODEL_CS_AXIS_X_X = 0
RDB_RIEGL_MODEL_CS_AXIS_X_Y = 1
RDB_RIEGL_MODEL_CS_AXIS_X_Z = 2

# Direction of y-axis of model coordinate system wrt. application coordinate system (0: X, 1: Y, 2: Z)
RDB_RIEGL_MODEL_CS_AXIS_Y                     = "riegl.model_cs_axis_y"
RDB_RIEGL_MODEL_CS_AXIS_Y_NAME                = "riegl.model_cs_axis_y"
RDB_RIEGL_MODEL_CS_AXIS_Y_TITLE               = "Model CS Y axis"
RDB_RIEGL_MODEL_CS_AXIS_Y_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_MODEL_CS_AXIS_Y_TAGS                = "direction, transform"
RDB_RIEGL_MODEL_CS_AXIS_Y_DESCRIPTION         = "Direction of y-axis of model coordinate system wrt. application coordinate system (0: X, 1: Y, 2: Z)"
RDB_RIEGL_MODEL_CS_AXIS_Y_UNIT                = ""
RDB_RIEGL_MODEL_CS_AXIS_Y_LENGTH              = 3
RDB_RIEGL_MODEL_CS_AXIS_Y_RESOLUTION          = 3.125e-05
RDB_RIEGL_MODEL_CS_AXIS_Y_MINIMUM             = -1.0
RDB_RIEGL_MODEL_CS_AXIS_Y_MAXIMUM             = 1.0
RDB_RIEGL_MODEL_CS_AXIS_Y_DEFAULT             = 0.0
RDB_RIEGL_MODEL_CS_AXIS_Y_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_MODEL_CS_AXIS_Y_NAMED_VALUES        = ""
RDB_RIEGL_MODEL_CS_AXIS_Y_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_MODEL_CS_AXIS_Y_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_MODEL_CS_AXIS_Y_LOD_SETTINGS        = "default"
RDB_RIEGL_MODEL_CS_AXIS_Y_SCALE               = 1.0
#
RDB_RIEGL_MODEL_CS_AXIS_Y_X = 0
RDB_RIEGL_MODEL_CS_AXIS_Y_Y = 1
RDB_RIEGL_MODEL_CS_AXIS_Y_Z = 2

# Direction of z-axis of model coordinate system wrt. application coordinate system (0: X, 1: Y, 2: Z)
RDB_RIEGL_MODEL_CS_AXIS_Z                     = "riegl.model_cs_axis_z"
RDB_RIEGL_MODEL_CS_AXIS_Z_NAME                = "riegl.model_cs_axis_z"
RDB_RIEGL_MODEL_CS_AXIS_Z_TITLE               = "Model CS Z axis"
RDB_RIEGL_MODEL_CS_AXIS_Z_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_MODEL_CS_AXIS_Z_TAGS                = "direction, transform"
RDB_RIEGL_MODEL_CS_AXIS_Z_DESCRIPTION         = "Direction of z-axis of model coordinate system wrt. application coordinate system (0: X, 1: Y, 2: Z)"
RDB_RIEGL_MODEL_CS_AXIS_Z_UNIT                = ""
RDB_RIEGL_MODEL_CS_AXIS_Z_LENGTH              = 3
RDB_RIEGL_MODEL_CS_AXIS_Z_RESOLUTION          = 3.125e-05
RDB_RIEGL_MODEL_CS_AXIS_Z_MINIMUM             = -1.0
RDB_RIEGL_MODEL_CS_AXIS_Z_MAXIMUM             = 1.0
RDB_RIEGL_MODEL_CS_AXIS_Z_DEFAULT             = 0.0
RDB_RIEGL_MODEL_CS_AXIS_Z_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_MODEL_CS_AXIS_Z_NAMED_VALUES        = ""
RDB_RIEGL_MODEL_CS_AXIS_Z_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_MODEL_CS_AXIS_Z_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_MODEL_CS_AXIS_Z_LOD_SETTINGS        = "default"
RDB_RIEGL_MODEL_CS_AXIS_Z_SCALE               = 1.0
#
RDB_RIEGL_MODEL_CS_AXIS_Z_X = 0
RDB_RIEGL_MODEL_CS_AXIS_Z_Y = 1
RDB_RIEGL_MODEL_CS_AXIS_Z_Z = 2

# Processed values of an accelerometer
RDB_RIEGL_ACCELEROMETER                     = "riegl.accelerometer"
RDB_RIEGL_ACCELEROMETER_NAME                = "riegl.accelerometer"
RDB_RIEGL_ACCELEROMETER_TITLE               = "Accelerometer Values"
RDB_RIEGL_ACCELEROMETER_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_ACCELEROMETER_TAGS                = "direction"
RDB_RIEGL_ACCELEROMETER_DESCRIPTION         = "Processed values of an accelerometer"
RDB_RIEGL_ACCELEROMETER_UNIT                = "m/s²"
RDB_RIEGL_ACCELEROMETER_LENGTH              = 3
RDB_RIEGL_ACCELEROMETER_RESOLUTION          = 0.0005
RDB_RIEGL_ACCELEROMETER_MINIMUM             = -100.0
RDB_RIEGL_ACCELEROMETER_MAXIMUM             = 100.0
RDB_RIEGL_ACCELEROMETER_DEFAULT             = -100.0
RDB_RIEGL_ACCELEROMETER_INVALID             = -100.0
RDB_RIEGL_ACCELEROMETER_NAMED_VALUES        = ""
RDB_RIEGL_ACCELEROMETER_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_ACCELEROMETER_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_ACCELEROMETER_LOD_SETTINGS        = "default"
RDB_RIEGL_ACCELEROMETER_SCALE               = 1.0

# Processed values of a gyroscope
RDB_RIEGL_GYROSCOPE                     = "riegl.gyroscope"
RDB_RIEGL_GYROSCOPE_NAME                = "riegl.gyroscope"
RDB_RIEGL_GYROSCOPE_TITLE               = "Gyroscope Values"
RDB_RIEGL_GYROSCOPE_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_GYROSCOPE_TAGS                = "direction"
RDB_RIEGL_GYROSCOPE_DESCRIPTION         = "Processed values of a gyroscope"
RDB_RIEGL_GYROSCOPE_UNIT                = "deg/s"
RDB_RIEGL_GYROSCOPE_LENGTH              = 3
RDB_RIEGL_GYROSCOPE_RESOLUTION          = 0.001
RDB_RIEGL_GYROSCOPE_MINIMUM             = -5000.0
RDB_RIEGL_GYROSCOPE_MAXIMUM             = 5000.0
RDB_RIEGL_GYROSCOPE_DEFAULT             = -5000.0
RDB_RIEGL_GYROSCOPE_INVALID             = -5000.0
RDB_RIEGL_GYROSCOPE_NAMED_VALUES        = ""
RDB_RIEGL_GYROSCOPE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_GYROSCOPE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_GYROSCOPE_LOD_SETTINGS        = "default"
RDB_RIEGL_GYROSCOPE_SCALE               = 1.0

# Processed values of a magnetic field sensor
RDB_RIEGL_MAGNETIC_FIELD_SENSOR                     = "riegl.magnetic_field_sensor"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_NAME                = "riegl.magnetic_field_sensor"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_TITLE               = "Magnetic Field Sensor Values"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_TAGS                = "direction"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_DESCRIPTION         = "Processed values of a magnetic field sensor"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_UNIT                = "µT"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_LENGTH              = 3
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RESOLUTION          = 0.01
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_MINIMUM             = -100.0
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_MAXIMUM             = 100.0
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_DEFAULT             = -100.0
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_INVALID             = -100.0
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_NAMED_VALUES        = ""
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_LOD_SETTINGS        = "default"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_SCALE               = 1.0

# Raw measurement values of an accelerometer (unit see metadata riegl.pose_sensors)
RDB_RIEGL_ACCELEROMETER_RAW                     = "riegl.accelerometer_raw"
RDB_RIEGL_ACCELEROMETER_RAW_NAME                = "riegl.accelerometer_raw"
RDB_RIEGL_ACCELEROMETER_RAW_TITLE               = "Accelerometer Raw Values"
RDB_RIEGL_ACCELEROMETER_RAW_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_ACCELEROMETER_RAW_TAGS                = "direction"
RDB_RIEGL_ACCELEROMETER_RAW_DESCRIPTION         = "Raw measurement values of an accelerometer (unit see metadata riegl.pose_sensors)"
RDB_RIEGL_ACCELEROMETER_RAW_UNIT                = ""
RDB_RIEGL_ACCELEROMETER_RAW_LENGTH              = 3
RDB_RIEGL_ACCELEROMETER_RAW_RESOLUTION          = 1.0
RDB_RIEGL_ACCELEROMETER_RAW_MINIMUM             = -32768.0
RDB_RIEGL_ACCELEROMETER_RAW_MAXIMUM             = 32767.0
RDB_RIEGL_ACCELEROMETER_RAW_DEFAULT             = -32768.0
RDB_RIEGL_ACCELEROMETER_RAW_INVALID             = -32768.0
RDB_RIEGL_ACCELEROMETER_RAW_NAMED_VALUES        = ""
RDB_RIEGL_ACCELEROMETER_RAW_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_ACCELEROMETER_RAW_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_ACCELEROMETER_RAW_LOD_SETTINGS        = "default"
RDB_RIEGL_ACCELEROMETER_RAW_SCALE               = 1.0

# Raw measurement values of a gyroscope (unit see metadata riegl.pose_sensors)
RDB_RIEGL_GYROSCOPE_RAW                     = "riegl.gyroscope_raw"
RDB_RIEGL_GYROSCOPE_RAW_NAME                = "riegl.gyroscope_raw"
RDB_RIEGL_GYROSCOPE_RAW_TITLE               = "Gyroscope Raw Values"
RDB_RIEGL_GYROSCOPE_RAW_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_GYROSCOPE_RAW_TAGS                = "direction"
RDB_RIEGL_GYROSCOPE_RAW_DESCRIPTION         = "Raw measurement values of a gyroscope (unit see metadata riegl.pose_sensors)"
RDB_RIEGL_GYROSCOPE_RAW_UNIT                = ""
RDB_RIEGL_GYROSCOPE_RAW_LENGTH              = 3
RDB_RIEGL_GYROSCOPE_RAW_RESOLUTION          = 1.0
RDB_RIEGL_GYROSCOPE_RAW_MINIMUM             = -32768.0
RDB_RIEGL_GYROSCOPE_RAW_MAXIMUM             = 32767.0
RDB_RIEGL_GYROSCOPE_RAW_DEFAULT             = -32768.0
RDB_RIEGL_GYROSCOPE_RAW_INVALID             = -32768.0
RDB_RIEGL_GYROSCOPE_RAW_NAMED_VALUES        = ""
RDB_RIEGL_GYROSCOPE_RAW_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_GYROSCOPE_RAW_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_GYROSCOPE_RAW_LOD_SETTINGS        = "default"
RDB_RIEGL_GYROSCOPE_RAW_SCALE               = 1.0

# Raw measurement values of a magnetic field sensor (unit see metadata riegl.pose_sensors)
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW                     = "riegl.magnetic_field_sensor_raw"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_NAME                = "riegl.magnetic_field_sensor_raw"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_TITLE               = "Magnetic Field Sensor Raw Values"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_TAGS                = "direction"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_DESCRIPTION         = "Raw measurement values of a magnetic field sensor (unit see metadata riegl.pose_sensors)"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_UNIT                = ""
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_LENGTH              = 3
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_RESOLUTION          = 1.0
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_MINIMUM             = -32768.0
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_MAXIMUM             = 32767.0
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_DEFAULT             = -32768.0
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_INVALID             = -32768.0
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_NAMED_VALUES        = ""
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_LOD_SETTINGS        = "default"
RDB_RIEGL_MAGNETIC_FIELD_SENSOR_RAW_SCALE               = 1.0

# Geodetic (Geographic) Latitude
RDB_RIEGL_POF_LATITUDE                     = "riegl.pof_latitude"
RDB_RIEGL_POF_LATITUDE_NAME                = "riegl.pof_latitude"
RDB_RIEGL_POF_LATITUDE_TITLE               = "Latitude"
RDB_RIEGL_POF_LATITUDE_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_POF_LATITUDE_TAGS                = ""
RDB_RIEGL_POF_LATITUDE_DESCRIPTION         = "Geodetic (Geographic) Latitude"
RDB_RIEGL_POF_LATITUDE_UNIT                = "deg"
RDB_RIEGL_POF_LATITUDE_LENGTH              = 1
RDB_RIEGL_POF_LATITUDE_RESOLUTION          = 1.0e-9
RDB_RIEGL_POF_LATITUDE_MINIMUM             = -90.0
RDB_RIEGL_POF_LATITUDE_MAXIMUM             = 90.0
RDB_RIEGL_POF_LATITUDE_DEFAULT             = 0.0
RDB_RIEGL_POF_LATITUDE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_LATITUDE_NAMED_VALUES        = ""
RDB_RIEGL_POF_LATITUDE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_LATITUDE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA_SHUFFLE
RDB_RIEGL_POF_LATITUDE_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_LATITUDE_SCALE               = 1.0
#
RDB_RIEGL_POF_LATITUDE_NORTH = 90.0
RDB_RIEGL_POF_LATITUDE_SOUTH = -90.0

# Geodetic (Geographic) Longitude
RDB_RIEGL_POF_LONGITUDE                     = "riegl.pof_longitude"
RDB_RIEGL_POF_LONGITUDE_NAME                = "riegl.pof_longitude"
RDB_RIEGL_POF_LONGITUDE_TITLE               = "Longitude"
RDB_RIEGL_POF_LONGITUDE_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_POF_LONGITUDE_TAGS                = ""
RDB_RIEGL_POF_LONGITUDE_DESCRIPTION         = "Geodetic (Geographic) Longitude"
RDB_RIEGL_POF_LONGITUDE_UNIT                = "deg"
RDB_RIEGL_POF_LONGITUDE_LENGTH              = 1
RDB_RIEGL_POF_LONGITUDE_RESOLUTION          = 1.0e-9
RDB_RIEGL_POF_LONGITUDE_MINIMUM             = -180.0
RDB_RIEGL_POF_LONGITUDE_MAXIMUM             = 180.0
RDB_RIEGL_POF_LONGITUDE_DEFAULT             = 0.0
RDB_RIEGL_POF_LONGITUDE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_LONGITUDE_NAMED_VALUES        = ""
RDB_RIEGL_POF_LONGITUDE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_LONGITUDE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA_SHUFFLE
RDB_RIEGL_POF_LONGITUDE_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_LONGITUDE_SCALE               = 1.0
#
RDB_RIEGL_POF_LONGITUDE_EAST = 180.0
RDB_RIEGL_POF_LONGITUDE_WEST = -180.0

# Height (vertical distance) wrt. to the ellipsoid of the defined geodetic datum
RDB_RIEGL_POF_HEIGHT                     = "riegl.pof_height"
RDB_RIEGL_POF_HEIGHT_NAME                = "riegl.pof_height"
RDB_RIEGL_POF_HEIGHT_TITLE               = "Ellipsoidal Height"
RDB_RIEGL_POF_HEIGHT_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_POF_HEIGHT_TAGS                = ""
RDB_RIEGL_POF_HEIGHT_DESCRIPTION         = "Height (vertical distance) wrt. to the ellipsoid of the defined geodetic datum"
RDB_RIEGL_POF_HEIGHT_UNIT                = "m"
RDB_RIEGL_POF_HEIGHT_LENGTH              = 1
RDB_RIEGL_POF_HEIGHT_RESOLUTION          = 250.0e-6
RDB_RIEGL_POF_HEIGHT_MINIMUM             = -10000.0
RDB_RIEGL_POF_HEIGHT_MAXIMUM             = 40000.0
RDB_RIEGL_POF_HEIGHT_DEFAULT             = 0.0
RDB_RIEGL_POF_HEIGHT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_HEIGHT_NAMED_VALUES        = ""
RDB_RIEGL_POF_HEIGHT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_HEIGHT_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA_SHUFFLE
RDB_RIEGL_POF_HEIGHT_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_HEIGHT_SCALE               = 1.0

# Rotation about the body axis pointing in forward direction (x-axis for NED systems)
RDB_RIEGL_POF_ROLL                     = "riegl.pof_roll"
RDB_RIEGL_POF_ROLL_NAME                = "riegl.pof_roll"
RDB_RIEGL_POF_ROLL_TITLE               = "Roll Angle"
RDB_RIEGL_POF_ROLL_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_POF_ROLL_TAGS                = ""
RDB_RIEGL_POF_ROLL_DESCRIPTION         = "Rotation about the body axis pointing in forward direction (x-axis for NED systems)"
RDB_RIEGL_POF_ROLL_UNIT                = "deg"
RDB_RIEGL_POF_ROLL_LENGTH              = 1
RDB_RIEGL_POF_ROLL_RESOLUTION          = 1.0e-6
RDB_RIEGL_POF_ROLL_MINIMUM             = -180.0
RDB_RIEGL_POF_ROLL_MAXIMUM             = 180.0
RDB_RIEGL_POF_ROLL_DEFAULT             = 0.0
RDB_RIEGL_POF_ROLL_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_ROLL_NAMED_VALUES        = ""
RDB_RIEGL_POF_ROLL_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_ROLL_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA_SHUFFLE
RDB_RIEGL_POF_ROLL_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_ROLL_SCALE               = 1.0

# Rotation about the body axis pointing in transverse direction (y-axis for NED systems)
RDB_RIEGL_POF_PITCH                     = "riegl.pof_pitch"
RDB_RIEGL_POF_PITCH_NAME                = "riegl.pof_pitch"
RDB_RIEGL_POF_PITCH_TITLE               = "Pitch Angle"
RDB_RIEGL_POF_PITCH_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_POF_PITCH_TAGS                = ""
RDB_RIEGL_POF_PITCH_DESCRIPTION         = "Rotation about the body axis pointing in transverse direction (y-axis for NED systems)"
RDB_RIEGL_POF_PITCH_UNIT                = "deg"
RDB_RIEGL_POF_PITCH_LENGTH              = 1
RDB_RIEGL_POF_PITCH_RESOLUTION          = 1.0e-6
RDB_RIEGL_POF_PITCH_MINIMUM             = -180.0
RDB_RIEGL_POF_PITCH_MAXIMUM             = 180.0
RDB_RIEGL_POF_PITCH_DEFAULT             = 0.0
RDB_RIEGL_POF_PITCH_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_PITCH_NAMED_VALUES        = ""
RDB_RIEGL_POF_PITCH_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_PITCH_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA_SHUFFLE
RDB_RIEGL_POF_PITCH_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_PITCH_SCALE               = 1.0

# Rotation about the body axis pointing in vertical direction (z-axis for NED systems)
RDB_RIEGL_POF_YAW                     = "riegl.pof_yaw"
RDB_RIEGL_POF_YAW_NAME                = "riegl.pof_yaw"
RDB_RIEGL_POF_YAW_TITLE               = "Yaw Angle"
RDB_RIEGL_POF_YAW_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_POF_YAW_TAGS                = ""
RDB_RIEGL_POF_YAW_DESCRIPTION         = "Rotation about the body axis pointing in vertical direction (z-axis for NED systems)"
RDB_RIEGL_POF_YAW_UNIT                = "deg"
RDB_RIEGL_POF_YAW_LENGTH              = 1
RDB_RIEGL_POF_YAW_RESOLUTION          = 1.0e-6
RDB_RIEGL_POF_YAW_MINIMUM             = 0.0
RDB_RIEGL_POF_YAW_MAXIMUM             = 360.0
RDB_RIEGL_POF_YAW_DEFAULT             = 0.0
RDB_RIEGL_POF_YAW_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_YAW_NAMED_VALUES        = ""
RDB_RIEGL_POF_YAW_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_YAW_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA_SHUFFLE
RDB_RIEGL_POF_YAW_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_YAW_SCALE               = 1.0

# Position of the platform in the coordinate system defined by the geo_tag (0: X, 1: Y, 2: Z)
RDB_RIEGL_POF_XYZ                     = "riegl.pof_xyz"
RDB_RIEGL_POF_XYZ_NAME                = "riegl.pof_xyz"
RDB_RIEGL_POF_XYZ_TITLE               = "XYZ"
RDB_RIEGL_POF_XYZ_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_POF_XYZ_TAGS                = "position, transform"
RDB_RIEGL_POF_XYZ_DESCRIPTION         = "Position of the platform in the coordinate system defined by the geo_tag (0: X, 1: Y, 2: Z)"
RDB_RIEGL_POF_XYZ_UNIT                = "m"
RDB_RIEGL_POF_XYZ_LENGTH              = 3
RDB_RIEGL_POF_XYZ_RESOLUTION          = 0.00025
RDB_RIEGL_POF_XYZ_MINIMUM             = -535000.0
RDB_RIEGL_POF_XYZ_MAXIMUM             = 535000.0
RDB_RIEGL_POF_XYZ_DEFAULT             = 0.0
RDB_RIEGL_POF_XYZ_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_XYZ_NAMED_VALUES        = ""
RDB_RIEGL_POF_XYZ_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_XYZ_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_XYZ_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_XYZ_SCALE               = 1.0
#
RDB_RIEGL_POF_XYZ_X = 0
RDB_RIEGL_POF_XYZ_Y = 1
RDB_RIEGL_POF_XYZ_Z = 2

# Rotation about y-axis of the coordinate system defined by the geo_tag
RDB_RIEGL_POF_ROLL_NED                     = "riegl.pof_roll_ned"
RDB_RIEGL_POF_ROLL_NED_NAME                = "riegl.pof_roll_ned"
RDB_RIEGL_POF_ROLL_NED_TITLE               = "Roll Angle NED"
RDB_RIEGL_POF_ROLL_NED_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_POF_ROLL_NED_TAGS                = ""
RDB_RIEGL_POF_ROLL_NED_DESCRIPTION         = "Rotation about y-axis of the coordinate system defined by the geo_tag"
RDB_RIEGL_POF_ROLL_NED_UNIT                = "deg"
RDB_RIEGL_POF_ROLL_NED_LENGTH              = 1
RDB_RIEGL_POF_ROLL_NED_RESOLUTION          = 1.0e-6
RDB_RIEGL_POF_ROLL_NED_MINIMUM             = -180.0
RDB_RIEGL_POF_ROLL_NED_MAXIMUM             = 180.0
RDB_RIEGL_POF_ROLL_NED_DEFAULT             = 0.0
RDB_RIEGL_POF_ROLL_NED_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_ROLL_NED_NAMED_VALUES        = ""
RDB_RIEGL_POF_ROLL_NED_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_ROLL_NED_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA_SHUFFLE
RDB_RIEGL_POF_ROLL_NED_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_ROLL_NED_SCALE               = 1.0

# Rotation about x-axis of the coordinate system defined by the geo_tag
RDB_RIEGL_POF_PITCH_NED                     = "riegl.pof_pitch_ned"
RDB_RIEGL_POF_PITCH_NED_NAME                = "riegl.pof_pitch_ned"
RDB_RIEGL_POF_PITCH_NED_TITLE               = "Pitch Angle NED"
RDB_RIEGL_POF_PITCH_NED_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_POF_PITCH_NED_TAGS                = ""
RDB_RIEGL_POF_PITCH_NED_DESCRIPTION         = "Rotation about x-axis of the coordinate system defined by the geo_tag"
RDB_RIEGL_POF_PITCH_NED_UNIT                = "deg"
RDB_RIEGL_POF_PITCH_NED_LENGTH              = 1
RDB_RIEGL_POF_PITCH_NED_RESOLUTION          = 1.0e-6
RDB_RIEGL_POF_PITCH_NED_MINIMUM             = -180.0
RDB_RIEGL_POF_PITCH_NED_MAXIMUM             = 180.0
RDB_RIEGL_POF_PITCH_NED_DEFAULT             = 0.0
RDB_RIEGL_POF_PITCH_NED_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_PITCH_NED_NAMED_VALUES        = ""
RDB_RIEGL_POF_PITCH_NED_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_PITCH_NED_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA_SHUFFLE
RDB_RIEGL_POF_PITCH_NED_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_PITCH_NED_SCALE               = 1.0

# Rotation about inverted z-axis of the coordinate system defined by the geo_tag
RDB_RIEGL_POF_YAW_NED                     = "riegl.pof_yaw_ned"
RDB_RIEGL_POF_YAW_NED_NAME                = "riegl.pof_yaw_ned"
RDB_RIEGL_POF_YAW_NED_TITLE               = "Yaw Angle NED"
RDB_RIEGL_POF_YAW_NED_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_POF_YAW_NED_TAGS                = ""
RDB_RIEGL_POF_YAW_NED_DESCRIPTION         = "Rotation about inverted z-axis of the coordinate system defined by the geo_tag"
RDB_RIEGL_POF_YAW_NED_UNIT                = "deg"
RDB_RIEGL_POF_YAW_NED_LENGTH              = 1
RDB_RIEGL_POF_YAW_NED_RESOLUTION          = 1.0e-6
RDB_RIEGL_POF_YAW_NED_MINIMUM             = 0.0
RDB_RIEGL_POF_YAW_NED_MAXIMUM             = 360.0
RDB_RIEGL_POF_YAW_NED_DEFAULT             = 0.0
RDB_RIEGL_POF_YAW_NED_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_YAW_NED_NAMED_VALUES        = ""
RDB_RIEGL_POF_YAW_NED_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_YAW_NED_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA_SHUFFLE
RDB_RIEGL_POF_YAW_NED_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_YAW_NED_SCALE               = 1.0

# Water surface intersection point coordinates wrt. application coordinate system (0: X, 1: Y, 2: Z)
RDB_RIEGL_HYDRO_INTERSECTION_POINT                     = "riegl.hydro_intersection_point"
RDB_RIEGL_HYDRO_INTERSECTION_POINT_NAME                = "riegl.hydro_intersection_point"
RDB_RIEGL_HYDRO_INTERSECTION_POINT_TITLE               = "Water Surface Intersection Point"
RDB_RIEGL_HYDRO_INTERSECTION_POINT_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_HYDRO_INTERSECTION_POINT_TAGS                = "position, transform"
RDB_RIEGL_HYDRO_INTERSECTION_POINT_DESCRIPTION         = "Water surface intersection point coordinates wrt. application coordinate system (0: X, 1: Y, 2: Z)"
RDB_RIEGL_HYDRO_INTERSECTION_POINT_UNIT                = "m"
RDB_RIEGL_HYDRO_INTERSECTION_POINT_LENGTH              = 3
RDB_RIEGL_HYDRO_INTERSECTION_POINT_RESOLUTION          = 0.00025
RDB_RIEGL_HYDRO_INTERSECTION_POINT_MINIMUM             = -535000.0
RDB_RIEGL_HYDRO_INTERSECTION_POINT_MAXIMUM             = 535000.0
RDB_RIEGL_HYDRO_INTERSECTION_POINT_DEFAULT             = 0.0
RDB_RIEGL_HYDRO_INTERSECTION_POINT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_HYDRO_INTERSECTION_POINT_NAMED_VALUES        = ""
RDB_RIEGL_HYDRO_INTERSECTION_POINT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_HYDRO_INTERSECTION_POINT_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_HYDRO_INTERSECTION_POINT_LOD_SETTINGS        = "default"
RDB_RIEGL_HYDRO_INTERSECTION_POINT_SCALE               = 1.0
#
RDB_RIEGL_HYDRO_INTERSECTION_POINT_X = 0
RDB_RIEGL_HYDRO_INTERSECTION_POINT_Y = 1
RDB_RIEGL_HYDRO_INTERSECTION_POINT_Z = 2

# Water surface intersection normal vector wrt. application coordinate system (0: X, 1: Y, 2: Z)
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL                     = "riegl.hydro_intersection_normal"
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_NAME                = "riegl.hydro_intersection_normal"
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_TITLE               = "Water Surface Intersection Normal"
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_TAGS                = "direction, transform"
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_DESCRIPTION         = "Water surface intersection normal vector wrt. application coordinate system (0: X, 1: Y, 2: Z)"
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_UNIT                = ""
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_LENGTH              = 3
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_RESOLUTION          = 0.00003125
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_MINIMUM             = -1.0
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_MAXIMUM             = 1.0
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_DEFAULT             = 0.0
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_NAMED_VALUES        = ""
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_LOD_SETTINGS        = "default"
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_SCALE               = 1.0
#
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_X = 0
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_Y = 1
RDB_RIEGL_HYDRO_INTERSECTION_NORMAL_Z = 2

# Water surface model uncertainty (0: X, 1: Y, 2: Z)
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY                     = "riegl.hydro_wsm_uncertainty"
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_NAME                = "riegl.hydro_wsm_uncertainty"
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_TITLE               = "Water Surface Model Uncertainty"
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_TAGS                = "direction, transform"
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_DESCRIPTION         = "Water surface model uncertainty (0: X, 1: Y, 2: Z)"
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_UNIT                = "m"
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_LENGTH              = 3
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_RESOLUTION          = 0.0001
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_MINIMUM             = -3.2768
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_MAXIMUM             = 3.2767
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_DEFAULT             = 0.0
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_NAMED_VALUES        = ""
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_LOD_SETTINGS        = "default"
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_SCALE               = 1.0
#
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_X = 0
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_Y = 1
RDB_RIEGL_HYDRO_WSM_UNCERTAINTY_Z = 2

# Accuracy of Cartesian coordinates (0: X, 1: Y, 2: Z)
RDB_RIEGL_XYZ_ACCURACIES                     = "riegl.xyz_accuracies"
RDB_RIEGL_XYZ_ACCURACIES_NAME                = "riegl.xyz_accuracies"
RDB_RIEGL_XYZ_ACCURACIES_TITLE               = "XYZ Accuracies"
RDB_RIEGL_XYZ_ACCURACIES_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_XYZ_ACCURACIES_TAGS                = "direction, transform"
RDB_RIEGL_XYZ_ACCURACIES_DESCRIPTION         = "Accuracy of Cartesian coordinates (0: X, 1: Y, 2: Z)"
RDB_RIEGL_XYZ_ACCURACIES_UNIT                = "m"
RDB_RIEGL_XYZ_ACCURACIES_LENGTH              = 3
RDB_RIEGL_XYZ_ACCURACIES_RESOLUTION          = 0.00025
RDB_RIEGL_XYZ_ACCURACIES_MINIMUM             = 0.0
RDB_RIEGL_XYZ_ACCURACIES_MAXIMUM             = 1000.0
RDB_RIEGL_XYZ_ACCURACIES_DEFAULT             = 0.0
RDB_RIEGL_XYZ_ACCURACIES_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_XYZ_ACCURACIES_NAMED_VALUES        = ""
RDB_RIEGL_XYZ_ACCURACIES_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_XYZ_ACCURACIES_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_XYZ_ACCURACIES_LOD_SETTINGS        = "default"
RDB_RIEGL_XYZ_ACCURACIES_SCALE               = 1.0

# Direction of zenith vector wrt. application coordinate system (0: X, 1: Y, 2: Z)
RDB_RIEGL_ZENITH_VECTOR                     = "riegl.zenith_vector"
RDB_RIEGL_ZENITH_VECTOR_NAME                = "riegl.zenith_vector"
RDB_RIEGL_ZENITH_VECTOR_TITLE               = "Zenith Vector"
RDB_RIEGL_ZENITH_VECTOR_GROUP               = "Coordinates/Vectors"
RDB_RIEGL_ZENITH_VECTOR_TAGS                = "direction, transform"
RDB_RIEGL_ZENITH_VECTOR_DESCRIPTION         = "Direction of zenith vector wrt. application coordinate system (0: X, 1: Y, 2: Z)"
RDB_RIEGL_ZENITH_VECTOR_UNIT                = ""
RDB_RIEGL_ZENITH_VECTOR_LENGTH              = 3
RDB_RIEGL_ZENITH_VECTOR_RESOLUTION          = 0.00003125
RDB_RIEGL_ZENITH_VECTOR_MINIMUM             = -1.0
RDB_RIEGL_ZENITH_VECTOR_MAXIMUM             = 1.0
RDB_RIEGL_ZENITH_VECTOR_DEFAULT             = 0.0
RDB_RIEGL_ZENITH_VECTOR_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_ZENITH_VECTOR_NAMED_VALUES        = ""
RDB_RIEGL_ZENITH_VECTOR_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_ZENITH_VECTOR_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_ZENITH_VECTOR_LOD_SETTINGS        = "default"
RDB_RIEGL_ZENITH_VECTOR_SCALE               = 1.0

# ______________________________________________________________________________
#
# POINT ATTRIBUTE GROUP "Time"
# ______________________________________________________________________________
#

# Laser shot timestamp (in units of 4 pico seconds = 4e-12 s)
RDB_RIEGL_SHOT_TIMESTAMP_HR                     = "riegl.shot_timestamp_hr"
RDB_RIEGL_SHOT_TIMESTAMP_HR_NAME                = "riegl.shot_timestamp_hr"
RDB_RIEGL_SHOT_TIMESTAMP_HR_TITLE               = "Laser Shot Timestamp"
RDB_RIEGL_SHOT_TIMESTAMP_HR_GROUP               = "Time"
RDB_RIEGL_SHOT_TIMESTAMP_HR_TAGS                = ""
RDB_RIEGL_SHOT_TIMESTAMP_HR_DESCRIPTION         = "Laser shot timestamp (in units of 4 pico seconds = 4e-12 s)"
RDB_RIEGL_SHOT_TIMESTAMP_HR_UNIT                = "4ps"
RDB_RIEGL_SHOT_TIMESTAMP_HR_LENGTH              = 1
RDB_RIEGL_SHOT_TIMESTAMP_HR_RESOLUTION          = 1.0
RDB_RIEGL_SHOT_TIMESTAMP_HR_MINIMUM             = 0.0
RDB_RIEGL_SHOT_TIMESTAMP_HR_MAXIMUM             = 9.0e18
RDB_RIEGL_SHOT_TIMESTAMP_HR_DEFAULT             = 0.0
RDB_RIEGL_SHOT_TIMESTAMP_HR_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SHOT_TIMESTAMP_HR_NAMED_VALUES        = ""
RDB_RIEGL_SHOT_TIMESTAMP_HR_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_SHOT_TIMESTAMP_HR_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_SHOT_TIMESTAMP_HR_LOD_SETTINGS        = "default"
RDB_RIEGL_SHOT_TIMESTAMP_HR_SCALE               = 1.0
#
RDB_RIEGL_SHOT_TIMESTAMP_HR_RESOLUTION = 4.0e-12

# Laser shot timestamp (100 nano seconds resolution)
RDB_RIEGL_TIMESTAMP                     = "riegl.timestamp"
RDB_RIEGL_TIMESTAMP_NAME                = "riegl.timestamp"
RDB_RIEGL_TIMESTAMP_TITLE               = "Timestamp"
RDB_RIEGL_TIMESTAMP_GROUP               = "Time"
RDB_RIEGL_TIMESTAMP_TAGS                = ""
RDB_RIEGL_TIMESTAMP_DESCRIPTION         = "Laser shot timestamp (100 nano seconds resolution)"
RDB_RIEGL_TIMESTAMP_UNIT                = "s"
RDB_RIEGL_TIMESTAMP_LENGTH              = 1
RDB_RIEGL_TIMESTAMP_RESOLUTION          = 1.0e-7
RDB_RIEGL_TIMESTAMP_MINIMUM             = 0.0
RDB_RIEGL_TIMESTAMP_MAXIMUM             = 9.0e8
RDB_RIEGL_TIMESTAMP_DEFAULT             = 0.0
RDB_RIEGL_TIMESTAMP_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_TIMESTAMP_NAMED_VALUES        = ""
RDB_RIEGL_TIMESTAMP_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_TIMESTAMP_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_TIMESTAMP_LOD_SETTINGS        = "default"
RDB_RIEGL_TIMESTAMP_SCALE               = 1.0

# Start of waveform sample block relative to laser shot timestamp (in units of 4 pico seconds = 4e-12 s)
RDB_RIEGL_WFM_SBL_TIME_OFFSET                     = "riegl.wfm_sbl_time_offset"
RDB_RIEGL_WFM_SBL_TIME_OFFSET_NAME                = "riegl.wfm_sbl_time_offset"
RDB_RIEGL_WFM_SBL_TIME_OFFSET_TITLE               = "Waveform Sample Block Time Offset"
RDB_RIEGL_WFM_SBL_TIME_OFFSET_GROUP               = "Time"
RDB_RIEGL_WFM_SBL_TIME_OFFSET_TAGS                = ""
RDB_RIEGL_WFM_SBL_TIME_OFFSET_DESCRIPTION         = "Start of waveform sample block relative to laser shot timestamp (in units of 4 pico seconds = 4e-12 s)"
RDB_RIEGL_WFM_SBL_TIME_OFFSET_UNIT                = "4ps"
RDB_RIEGL_WFM_SBL_TIME_OFFSET_LENGTH              = 1
RDB_RIEGL_WFM_SBL_TIME_OFFSET_RESOLUTION          = 1.0
RDB_RIEGL_WFM_SBL_TIME_OFFSET_MINIMUM             = -2.0e9
RDB_RIEGL_WFM_SBL_TIME_OFFSET_MAXIMUM             = 2.0e9
RDB_RIEGL_WFM_SBL_TIME_OFFSET_DEFAULT             = 0.0
RDB_RIEGL_WFM_SBL_TIME_OFFSET_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_WFM_SBL_TIME_OFFSET_NAMED_VALUES        = ""
RDB_RIEGL_WFM_SBL_TIME_OFFSET_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_WFM_SBL_TIME_OFFSET_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_WFM_SBL_TIME_OFFSET_LOD_SETTINGS        = "default"
RDB_RIEGL_WFM_SBL_TIME_OFFSET_SCALE               = 1.0
#
RDB_RIEGL_WFM_SBL_TIME_OFFSET_RESOLUTION = 4.0e-12

# Position of echo relative to start of waveform sample block (in units of 4 pico seconds = 4e-12 s)
RDB_RIEGL_WFM_ECHO_TIME_OFFSET                     = "riegl.wfm_echo_time_offset"
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_NAME                = "riegl.wfm_echo_time_offset"
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_TITLE               = "Echo Time Offset"
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_GROUP               = "Time"
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_TAGS                = ""
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_DESCRIPTION         = "Position of echo relative to start of waveform sample block (in units of 4 pico seconds = 4e-12 s)"
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_UNIT                = "4ps"
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_LENGTH              = 1
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_RESOLUTION          = 1.0
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_MINIMUM             = -2.0e9
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_MAXIMUM             = 2.0e9
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_DEFAULT             = 0.0
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_NAMED_VALUES        = ""
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_LOD_SETTINGS        = "default"
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_SCALE               = 1.0
#
RDB_RIEGL_WFM_ECHO_TIME_OFFSET_RESOLUTION = 4.0e-12

# External timestamp (100 nano seconds resolution)
RDB_RIEGL_PPS_TIMESTAMP_EXTERN                     = "riegl.pps_timestamp_extern"
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_NAME                = "riegl.pps_timestamp_extern"
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_TITLE               = "External Timestamp"
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_GROUP               = "Time"
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_TAGS                = ""
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_DESCRIPTION         = "External timestamp (100 nano seconds resolution)"
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_UNIT                = "s"
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_LENGTH              = 1
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_RESOLUTION          = 1.0e-7
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_MINIMUM             = 0.0
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_MAXIMUM             = 9.0e8
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_DEFAULT             = 0.0
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_NAMED_VALUES        = ""
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_LOD_SETTINGS        = "default"
RDB_RIEGL_PPS_TIMESTAMP_EXTERN_SCALE               = 1.0

# Internal timestamp (in units of 4 pico seconds = 4e-12 s)
RDB_RIEGL_PPS_TIMESTAMP_INTERN                     = "riegl.pps_timestamp_intern"
RDB_RIEGL_PPS_TIMESTAMP_INTERN_NAME                = "riegl.pps_timestamp_intern"
RDB_RIEGL_PPS_TIMESTAMP_INTERN_TITLE               = "Internal Timestamp"
RDB_RIEGL_PPS_TIMESTAMP_INTERN_GROUP               = "Time"
RDB_RIEGL_PPS_TIMESTAMP_INTERN_TAGS                = ""
RDB_RIEGL_PPS_TIMESTAMP_INTERN_DESCRIPTION         = "Internal timestamp (in units of 4 pico seconds = 4e-12 s)"
RDB_RIEGL_PPS_TIMESTAMP_INTERN_UNIT                = "4ps"
RDB_RIEGL_PPS_TIMESTAMP_INTERN_LENGTH              = 1
RDB_RIEGL_PPS_TIMESTAMP_INTERN_RESOLUTION          = 1.0
RDB_RIEGL_PPS_TIMESTAMP_INTERN_MINIMUM             = 0.0
RDB_RIEGL_PPS_TIMESTAMP_INTERN_MAXIMUM             = 9.0e18
RDB_RIEGL_PPS_TIMESTAMP_INTERN_DEFAULT             = 0.0
RDB_RIEGL_PPS_TIMESTAMP_INTERN_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_PPS_TIMESTAMP_INTERN_NAMED_VALUES        = ""
RDB_RIEGL_PPS_TIMESTAMP_INTERN_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PPS_TIMESTAMP_INTERN_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_PPS_TIMESTAMP_INTERN_LOD_SETTINGS        = "default"
RDB_RIEGL_PPS_TIMESTAMP_INTERN_SCALE               = 1.0
#
RDB_RIEGL_PPS_TIMESTAMP_INTERN_RESOLUTION = 4.0e-12

# Minimum laser shot timestamp within voxel (100 nano seconds resolution)
RDB_RIEGL_TIMESTAMP_MIN                     = "riegl.timestamp_min"
RDB_RIEGL_TIMESTAMP_MIN_NAME                = "riegl.timestamp_min"
RDB_RIEGL_TIMESTAMP_MIN_TITLE               = "Timestamp Minimum"
RDB_RIEGL_TIMESTAMP_MIN_GROUP               = "Time"
RDB_RIEGL_TIMESTAMP_MIN_TAGS                = ""
RDB_RIEGL_TIMESTAMP_MIN_DESCRIPTION         = "Minimum laser shot timestamp within voxel (100 nano seconds resolution)"
RDB_RIEGL_TIMESTAMP_MIN_UNIT                = "s"
RDB_RIEGL_TIMESTAMP_MIN_LENGTH              = 1
RDB_RIEGL_TIMESTAMP_MIN_RESOLUTION          = 1.0e-7
RDB_RIEGL_TIMESTAMP_MIN_MINIMUM             = 0.0
RDB_RIEGL_TIMESTAMP_MIN_MAXIMUM             = 9.0e8
RDB_RIEGL_TIMESTAMP_MIN_DEFAULT             = 0.0
RDB_RIEGL_TIMESTAMP_MIN_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_TIMESTAMP_MIN_NAMED_VALUES        = ""
RDB_RIEGL_TIMESTAMP_MIN_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_TIMESTAMP_MIN_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_TIMESTAMP_MIN_LOD_SETTINGS        = "default"
RDB_RIEGL_TIMESTAMP_MIN_SCALE               = 1.0

# Maximum laser shot timestamp within voxel (100 nano seconds resolution)
RDB_RIEGL_TIMESTAMP_MAX                     = "riegl.timestamp_max"
RDB_RIEGL_TIMESTAMP_MAX_NAME                = "riegl.timestamp_max"
RDB_RIEGL_TIMESTAMP_MAX_TITLE               = "Timestamp Maximum"
RDB_RIEGL_TIMESTAMP_MAX_GROUP               = "Time"
RDB_RIEGL_TIMESTAMP_MAX_TAGS                = ""
RDB_RIEGL_TIMESTAMP_MAX_DESCRIPTION         = "Maximum laser shot timestamp within voxel (100 nano seconds resolution)"
RDB_RIEGL_TIMESTAMP_MAX_UNIT                = "s"
RDB_RIEGL_TIMESTAMP_MAX_LENGTH              = 1
RDB_RIEGL_TIMESTAMP_MAX_RESOLUTION          = 1.0e-7
RDB_RIEGL_TIMESTAMP_MAX_MINIMUM             = 0.0
RDB_RIEGL_TIMESTAMP_MAX_MAXIMUM             = 9.0e8
RDB_RIEGL_TIMESTAMP_MAX_DEFAULT             = 0.0
RDB_RIEGL_TIMESTAMP_MAX_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_TIMESTAMP_MAX_NAMED_VALUES        = ""
RDB_RIEGL_TIMESTAMP_MAX_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_TIMESTAMP_MAX_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_TIMESTAMP_MAX_LOD_SETTINGS        = "default"
RDB_RIEGL_TIMESTAMP_MAX_SCALE               = 1.0

# Timestamp (100 nano seconds resolution)
RDB_RIEGL_POF_TIMESTAMP                     = "riegl.pof_timestamp"
RDB_RIEGL_POF_TIMESTAMP_NAME                = "riegl.pof_timestamp"
RDB_RIEGL_POF_TIMESTAMP_TITLE               = "Timestamp"
RDB_RIEGL_POF_TIMESTAMP_GROUP               = "Time"
RDB_RIEGL_POF_TIMESTAMP_TAGS                = ""
RDB_RIEGL_POF_TIMESTAMP_DESCRIPTION         = "Timestamp (100 nano seconds resolution)"
RDB_RIEGL_POF_TIMESTAMP_UNIT                = "s"
RDB_RIEGL_POF_TIMESTAMP_LENGTH              = 1
RDB_RIEGL_POF_TIMESTAMP_RESOLUTION          = 1.0e-7
RDB_RIEGL_POF_TIMESTAMP_MINIMUM             = 0.0
RDB_RIEGL_POF_TIMESTAMP_MAXIMUM             = 9.0e8
RDB_RIEGL_POF_TIMESTAMP_DEFAULT             = 0.0
RDB_RIEGL_POF_TIMESTAMP_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_TIMESTAMP_NAMED_VALUES        = ""
RDB_RIEGL_POF_TIMESTAMP_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_TIMESTAMP_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA_SHUFFLE
RDB_RIEGL_POF_TIMESTAMP_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_TIMESTAMP_SCALE               = 1.0

# Date of acquisition (0: year, 1: month [1-12], 2: day [1-31], not specified if any is 0)
RDB_RIEGL_ACQUISITION_DATE                     = "riegl.acquisition_date"
RDB_RIEGL_ACQUISITION_DATE_NAME                = "riegl.acquisition_date"
RDB_RIEGL_ACQUISITION_DATE_TITLE               = "Acquisition Date"
RDB_RIEGL_ACQUISITION_DATE_GROUP               = "Time"
RDB_RIEGL_ACQUISITION_DATE_TAGS                = ""
RDB_RIEGL_ACQUISITION_DATE_DESCRIPTION         = "Date of acquisition (0: year, 1: month [1-12], 2: day [1-31], not specified if any is 0)"
RDB_RIEGL_ACQUISITION_DATE_UNIT                = ""
RDB_RIEGL_ACQUISITION_DATE_LENGTH              = 3
RDB_RIEGL_ACQUISITION_DATE_RESOLUTION          = 1.0
RDB_RIEGL_ACQUISITION_DATE_MINIMUM             = 0.0
RDB_RIEGL_ACQUISITION_DATE_MAXIMUM             = 4095.0
RDB_RIEGL_ACQUISITION_DATE_DEFAULT             = 0.0
RDB_RIEGL_ACQUISITION_DATE_INVALID             = 0.0
RDB_RIEGL_ACQUISITION_DATE_NAMED_VALUES        = ""
RDB_RIEGL_ACQUISITION_DATE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_ACQUISITION_DATE_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_ACQUISITION_DATE_LOD_SETTINGS        = "default"
RDB_RIEGL_ACQUISITION_DATE_SCALE               = 1.0
#
RDB_RIEGL_ACQUISITION_DATE_YEAR = 0
RDB_RIEGL_ACQUISITION_DATE_MONTH = 1
RDB_RIEGL_ACQUISITION_DATE_DAY = 2

# ______________________________________________________________________________
#
# POINT ATTRIBUTE GROUP "Primary Attributes"
# ______________________________________________________________________________
#

# Target surface reflectance
RDB_RIEGL_REFLECTANCE                     = "riegl.reflectance"
RDB_RIEGL_REFLECTANCE_NAME                = "riegl.reflectance"
RDB_RIEGL_REFLECTANCE_TITLE               = "Reflectance"
RDB_RIEGL_REFLECTANCE_GROUP               = "Primary Attributes"
RDB_RIEGL_REFLECTANCE_TAGS                = ""
RDB_RIEGL_REFLECTANCE_DESCRIPTION         = "Target surface reflectance"
RDB_RIEGL_REFLECTANCE_UNIT                = "dB"
RDB_RIEGL_REFLECTANCE_LENGTH              = 1
RDB_RIEGL_REFLECTANCE_RESOLUTION          = 0.01
RDB_RIEGL_REFLECTANCE_MINIMUM             = -327.68
RDB_RIEGL_REFLECTANCE_MAXIMUM             = 327.67
RDB_RIEGL_REFLECTANCE_DEFAULT             = 0.0
RDB_RIEGL_REFLECTANCE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_REFLECTANCE_NAMED_VALUES        = ""
RDB_RIEGL_REFLECTANCE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_REFLECTANCE_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_REFLECTANCE_LOD_SETTINGS        = "default"
RDB_RIEGL_REFLECTANCE_SCALE               = 1.0

# Echo signal amplitude
RDB_RIEGL_AMPLITUDE                     = "riegl.amplitude"
RDB_RIEGL_AMPLITUDE_NAME                = "riegl.amplitude"
RDB_RIEGL_AMPLITUDE_TITLE               = "Amplitude"
RDB_RIEGL_AMPLITUDE_GROUP               = "Primary Attributes"
RDB_RIEGL_AMPLITUDE_TAGS                = ""
RDB_RIEGL_AMPLITUDE_DESCRIPTION         = "Echo signal amplitude"
RDB_RIEGL_AMPLITUDE_UNIT                = "dB"
RDB_RIEGL_AMPLITUDE_LENGTH              = 1
RDB_RIEGL_AMPLITUDE_RESOLUTION          = 0.01
RDB_RIEGL_AMPLITUDE_MINIMUM             = -327.68
RDB_RIEGL_AMPLITUDE_MAXIMUM             = 327.67
RDB_RIEGL_AMPLITUDE_DEFAULT             = 0.0
RDB_RIEGL_AMPLITUDE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_AMPLITUDE_NAMED_VALUES        = ""
RDB_RIEGL_AMPLITUDE_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_AMPLITUDE_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_AMPLITUDE_LOD_SETTINGS        = "default"
RDB_RIEGL_AMPLITUDE_SCALE               = 1.0

# Uncalibrated echo signal amplitude (for legacy RIEGL LMS instruments)
RDB_RIEGL_INTENSITY                     = "riegl.intensity"
RDB_RIEGL_INTENSITY_NAME                = "riegl.intensity"
RDB_RIEGL_INTENSITY_TITLE               = "Intensity"
RDB_RIEGL_INTENSITY_GROUP               = "Primary Attributes"
RDB_RIEGL_INTENSITY_TAGS                = ""
RDB_RIEGL_INTENSITY_DESCRIPTION         = "Uncalibrated echo signal amplitude (for legacy RIEGL LMS instruments)"
RDB_RIEGL_INTENSITY_UNIT                = ""
RDB_RIEGL_INTENSITY_LENGTH              = 1
RDB_RIEGL_INTENSITY_RESOLUTION          = 1.0
RDB_RIEGL_INTENSITY_MINIMUM             = 0.0
RDB_RIEGL_INTENSITY_MAXIMUM             = 65535.0
RDB_RIEGL_INTENSITY_DEFAULT             = 0.0
RDB_RIEGL_INTENSITY_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_INTENSITY_NAMED_VALUES        = ""
RDB_RIEGL_INTENSITY_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_INTENSITY_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_INTENSITY_LOD_SETTINGS        = "default"
RDB_RIEGL_INTENSITY_SCALE               = 1.0

# Gain of photodiode
RDB_RIEGL_GAIN                     = "riegl.gain"
RDB_RIEGL_GAIN_NAME                = "riegl.gain"
RDB_RIEGL_GAIN_TITLE               = "Gain"
RDB_RIEGL_GAIN_GROUP               = "Primary Attributes"
RDB_RIEGL_GAIN_TAGS                = ""
RDB_RIEGL_GAIN_DESCRIPTION         = "Gain of photodiode"
RDB_RIEGL_GAIN_UNIT                = "dB"
RDB_RIEGL_GAIN_LENGTH              = 1
RDB_RIEGL_GAIN_RESOLUTION          = 0.01
RDB_RIEGL_GAIN_MINIMUM             = -327.68
RDB_RIEGL_GAIN_MAXIMUM             = 327.67
RDB_RIEGL_GAIN_DEFAULT             = 0.0
RDB_RIEGL_GAIN_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_GAIN_NAMED_VALUES        = ""
RDB_RIEGL_GAIN_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_GAIN_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_GAIN_LOD_SETTINGS        = "default"
RDB_RIEGL_GAIN_SCALE               = 1.0

# Pulse shape deviation (negative means unavailable)
RDB_RIEGL_DEVIATION                     = "riegl.deviation"
RDB_RIEGL_DEVIATION_NAME                = "riegl.deviation"
RDB_RIEGL_DEVIATION_TITLE               = "Deviation"
RDB_RIEGL_DEVIATION_GROUP               = "Primary Attributes"
RDB_RIEGL_DEVIATION_TAGS                = ""
RDB_RIEGL_DEVIATION_DESCRIPTION         = "Pulse shape deviation (negative means unavailable)"
RDB_RIEGL_DEVIATION_UNIT                = ""
RDB_RIEGL_DEVIATION_LENGTH              = 1
RDB_RIEGL_DEVIATION_RESOLUTION          = 1.0
RDB_RIEGL_DEVIATION_MINIMUM             = -1.0
RDB_RIEGL_DEVIATION_MAXIMUM             = 32767.0
RDB_RIEGL_DEVIATION_DEFAULT             = 0.0
RDB_RIEGL_DEVIATION_INVALID             = -1.0
RDB_RIEGL_DEVIATION_NAMED_VALUES        = ""
RDB_RIEGL_DEVIATION_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_DEVIATION_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_DEVIATION_LOD_SETTINGS        = "default"
RDB_RIEGL_DEVIATION_SCALE               = 1.0
#
RDB_RIEGL_DEVIATION_UNAVAILABLE = -1

# Pulse width (full width at half maximum, for Q-Series instruments, 0 = invalid)
RDB_RIEGL_PULSE_WIDTH                     = "riegl.pulse_width"
RDB_RIEGL_PULSE_WIDTH_NAME                = "riegl.pulse_width"
RDB_RIEGL_PULSE_WIDTH_TITLE               = "Pulse Width"
RDB_RIEGL_PULSE_WIDTH_GROUP               = "Primary Attributes"
RDB_RIEGL_PULSE_WIDTH_TAGS                = ""
RDB_RIEGL_PULSE_WIDTH_DESCRIPTION         = "Pulse width (full width at half maximum, for Q-Series instruments, 0 = invalid)"
RDB_RIEGL_PULSE_WIDTH_UNIT                = "ns"
RDB_RIEGL_PULSE_WIDTH_LENGTH              = 1
RDB_RIEGL_PULSE_WIDTH_RESOLUTION          = 0.1
RDB_RIEGL_PULSE_WIDTH_MINIMUM             = 0.0
RDB_RIEGL_PULSE_WIDTH_MAXIMUM             = 6553.5
RDB_RIEGL_PULSE_WIDTH_DEFAULT             = 0.0
RDB_RIEGL_PULSE_WIDTH_INVALID             = 0.0
RDB_RIEGL_PULSE_WIDTH_NAMED_VALUES        = ""
RDB_RIEGL_PULSE_WIDTH_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_PULSE_WIDTH_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PULSE_WIDTH_LOD_SETTINGS        = "default"
RDB_RIEGL_PULSE_WIDTH_SCALE               = 1.0
#
RDB_RIEGL_PULSE_WIDTH_INVALID = 0.0

# Point class number
RDB_RIEGL_CLASS                     = "riegl.class"
RDB_RIEGL_CLASS_NAME                = "riegl.class"
RDB_RIEGL_CLASS_TITLE               = "Point Class"
RDB_RIEGL_CLASS_GROUP               = "Primary Attributes"
RDB_RIEGL_CLASS_TAGS                = "enumeration"
RDB_RIEGL_CLASS_DESCRIPTION         = "Point class number"
RDB_RIEGL_CLASS_UNIT                = ""
RDB_RIEGL_CLASS_LENGTH              = 1
RDB_RIEGL_CLASS_RESOLUTION          = 1.0
RDB_RIEGL_CLASS_MINIMUM             = 0.0
RDB_RIEGL_CLASS_MAXIMUM             = 65535.0
RDB_RIEGL_CLASS_DEFAULT             = 0.0
RDB_RIEGL_CLASS_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_CLASS_NAMED_VALUES        = "0=Created, never classified\n"
RDB_RIEGL_CLASS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_CLASS_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_CLASS_LOD_SETTINGS        = "default"
RDB_RIEGL_CLASS_SCALE               = 1.0

# Point color derived from digital camera, 0: Red, 1: Green, 2: Blue, 3: Alpha (0 = no color); additional colors (if any) are stored in riegl.rgba_2, riegl.rgba_3, ...
RDB_RIEGL_RGBA                     = "riegl.rgba"
RDB_RIEGL_RGBA_NAME                = "riegl.rgba"
RDB_RIEGL_RGBA_TITLE               = "True Color"
RDB_RIEGL_RGBA_GROUP               = "Primary Attributes"
RDB_RIEGL_RGBA_TAGS                = "color"
RDB_RIEGL_RGBA_DESCRIPTION         = "Point color derived from digital camera, 0: Red, 1: Green, 2: Blue, 3: Alpha (0 = no color); additional colors (if any) are stored in riegl.rgba_2, riegl.rgba_3, ..."
RDB_RIEGL_RGBA_UNIT                = ""
RDB_RIEGL_RGBA_LENGTH              = 4
RDB_RIEGL_RGBA_RESOLUTION          = 1.0
RDB_RIEGL_RGBA_MINIMUM             = 0.0
RDB_RIEGL_RGBA_MAXIMUM             = 255.0
RDB_RIEGL_RGBA_DEFAULT             = 0.0
RDB_RIEGL_RGBA_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_RGBA_NAMED_VALUES        = ""
RDB_RIEGL_RGBA_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_RGBA_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_RGBA_LOD_SETTINGS        = "default"
RDB_RIEGL_RGBA_SCALE               = 1.0
#
RDB_RIEGL_RGBA_RED = 0
RDB_RIEGL_RGBA_GREEN = 1
RDB_RIEGL_RGBA_BLUE = 2
RDB_RIEGL_RGBA_ALPHA = 3

# Point near infrared (NIR) value derived from NIR camera
RDB_RIEGL_NIR                     = "riegl.nir"
RDB_RIEGL_NIR_NAME                = "riegl.nir"
RDB_RIEGL_NIR_TITLE               = "Near Infrared Brightness"
RDB_RIEGL_NIR_GROUP               = "Primary Attributes"
RDB_RIEGL_NIR_TAGS                = ""
RDB_RIEGL_NIR_DESCRIPTION         = "Point near infrared (NIR) value derived from NIR camera"
RDB_RIEGL_NIR_UNIT                = ""
RDB_RIEGL_NIR_LENGTH              = 1
RDB_RIEGL_NIR_RESOLUTION          = 1.0
RDB_RIEGL_NIR_MINIMUM             = 0.0
RDB_RIEGL_NIR_MAXIMUM             = 65535.0
RDB_RIEGL_NIR_DEFAULT             = 0.0
RDB_RIEGL_NIR_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_NIR_NAMED_VALUES        = ""
RDB_RIEGL_NIR_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_NIR_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_NIR_LOD_SETTINGS        = "default"
RDB_RIEGL_NIR_SCALE               = 1.0

# Target temperature measured by thermal camera
RDB_RIEGL_TEMPERATURE                     = "riegl.temperature"
RDB_RIEGL_TEMPERATURE_NAME                = "riegl.temperature"
RDB_RIEGL_TEMPERATURE_TITLE               = "Temperature"
RDB_RIEGL_TEMPERATURE_GROUP               = "Primary Attributes"
RDB_RIEGL_TEMPERATURE_TAGS                = ""
RDB_RIEGL_TEMPERATURE_DESCRIPTION         = "Target temperature measured by thermal camera"
RDB_RIEGL_TEMPERATURE_UNIT                = "°C"
RDB_RIEGL_TEMPERATURE_LENGTH              = 1
RDB_RIEGL_TEMPERATURE_RESOLUTION          = 0.001
RDB_RIEGL_TEMPERATURE_MINIMUM             = -273.15
RDB_RIEGL_TEMPERATURE_MAXIMUM             = 4.0e6
RDB_RIEGL_TEMPERATURE_DEFAULT             = 4.0e6
RDB_RIEGL_TEMPERATURE_INVALID             = 4.0e6
RDB_RIEGL_TEMPERATURE_NAMED_VALUES        = ""
RDB_RIEGL_TEMPERATURE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_TEMPERATURE_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_TEMPERATURE_LOD_SETTINGS        = "default"
RDB_RIEGL_TEMPERATURE_SCALE               = 1.0

# Index of assigned MTA zone. Nearest MTA zone has index 1
RDB_RIEGL_MTA_ZONE                     = "riegl.mta_zone"
RDB_RIEGL_MTA_ZONE_NAME                = "riegl.mta_zone"
RDB_RIEGL_MTA_ZONE_TITLE               = "MTA Zone Assigned"
RDB_RIEGL_MTA_ZONE_GROUP               = "Primary Attributes"
RDB_RIEGL_MTA_ZONE_TAGS                = "enumeration"
RDB_RIEGL_MTA_ZONE_DESCRIPTION         = "Index of assigned MTA zone. Nearest MTA zone has index 1"
RDB_RIEGL_MTA_ZONE_UNIT                = ""
RDB_RIEGL_MTA_ZONE_LENGTH              = 1
RDB_RIEGL_MTA_ZONE_RESOLUTION          = 1.0
RDB_RIEGL_MTA_ZONE_MINIMUM             = 1.0
RDB_RIEGL_MTA_ZONE_MAXIMUM             = 255.0
RDB_RIEGL_MTA_ZONE_DEFAULT             = 1.0
RDB_RIEGL_MTA_ZONE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_MTA_ZONE_NAMED_VALUES        = ""
RDB_RIEGL_MTA_ZONE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_MTA_ZONE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_MTA_ZONE_LOD_SETTINGS        = "default"
RDB_RIEGL_MTA_ZONE_SCALE               = 1.0

# 1 for points with uncertain MTA zone assignment, 0 for certainly assigned MTA zone
RDB_RIEGL_MTA_UNCERTAIN_POINT                     = "riegl.mta_uncertain_point"
RDB_RIEGL_MTA_UNCERTAIN_POINT_NAME                = "riegl.mta_uncertain_point"
RDB_RIEGL_MTA_UNCERTAIN_POINT_TITLE               = "MTA Uncertain Point"
RDB_RIEGL_MTA_UNCERTAIN_POINT_GROUP               = "Primary Attributes"
RDB_RIEGL_MTA_UNCERTAIN_POINT_TAGS                = "boolean"
RDB_RIEGL_MTA_UNCERTAIN_POINT_DESCRIPTION         = "1 for points with uncertain MTA zone assignment, 0 for certainly assigned MTA zone"
RDB_RIEGL_MTA_UNCERTAIN_POINT_UNIT                = ""
RDB_RIEGL_MTA_UNCERTAIN_POINT_LENGTH              = 1
RDB_RIEGL_MTA_UNCERTAIN_POINT_RESOLUTION          = 1.0
RDB_RIEGL_MTA_UNCERTAIN_POINT_MINIMUM             = 0.0
RDB_RIEGL_MTA_UNCERTAIN_POINT_MAXIMUM             = 1.0
RDB_RIEGL_MTA_UNCERTAIN_POINT_DEFAULT             = 0.0
RDB_RIEGL_MTA_UNCERTAIN_POINT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_MTA_UNCERTAIN_POINT_NAMED_VALUES        = ""
RDB_RIEGL_MTA_UNCERTAIN_POINT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_MTA_UNCERTAIN_POINT_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_MTA_UNCERTAIN_POINT_LOD_SETTINGS        = "default"
RDB_RIEGL_MTA_UNCERTAIN_POINT_SCALE               = 1.0
#
RDB_RIEGL_MTA_UNCERTAIN_POINT_FALSE = 0
RDB_RIEGL_MTA_UNCERTAIN_POINT_TRUE = 1

# 1 for all points originating from a full waveform analysis (FWA), 0 for all points originating from online waveform processing (OWP)
RDB_RIEGL_FWA                     = "riegl.fwa"
RDB_RIEGL_FWA_NAME                = "riegl.fwa"
RDB_RIEGL_FWA_TITLE               = "Full Waveform Analysis"
RDB_RIEGL_FWA_GROUP               = "Primary Attributes"
RDB_RIEGL_FWA_TAGS                = "boolean"
RDB_RIEGL_FWA_DESCRIPTION         = "1 for all points originating from a full waveform analysis (FWA), 0 for all points originating from online waveform processing (OWP)"
RDB_RIEGL_FWA_UNIT                = ""
RDB_RIEGL_FWA_LENGTH              = 1
RDB_RIEGL_FWA_RESOLUTION          = 1.0
RDB_RIEGL_FWA_MINIMUM             = 0.0
RDB_RIEGL_FWA_MAXIMUM             = 1.0
RDB_RIEGL_FWA_DEFAULT             = 0.0
RDB_RIEGL_FWA_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_FWA_NAMED_VALUES        = "0=Origin OWP\n1=Origin FWA\n"
RDB_RIEGL_FWA_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_FWA_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_FWA_LOD_SETTINGS        = "default"
RDB_RIEGL_FWA_SCALE               = 1.0
#
RDB_RIEGL_FWA_ONLINE_WAVEFORM_PROCESSING = 0
RDB_RIEGL_FWA_FULL_WAVEFORM_ANALYSIS = 1

# Background Radiation (for VZ-400-HT/HAT only)
RDB_RIEGL_BACKGROUND_RADIATION                     = "riegl.background_radiation"
RDB_RIEGL_BACKGROUND_RADIATION_NAME                = "riegl.background_radiation"
RDB_RIEGL_BACKGROUND_RADIATION_TITLE               = "Background Radiation"
RDB_RIEGL_BACKGROUND_RADIATION_GROUP               = "Primary Attributes"
RDB_RIEGL_BACKGROUND_RADIATION_TAGS                = ""
RDB_RIEGL_BACKGROUND_RADIATION_DESCRIPTION         = "Background Radiation (for VZ-400-HT/HAT only)"
RDB_RIEGL_BACKGROUND_RADIATION_UNIT                = ""
RDB_RIEGL_BACKGROUND_RADIATION_LENGTH              = 1
RDB_RIEGL_BACKGROUND_RADIATION_RESOLUTION          = 1.0
RDB_RIEGL_BACKGROUND_RADIATION_MINIMUM             = 0.0
RDB_RIEGL_BACKGROUND_RADIATION_MAXIMUM             = 65535.0
RDB_RIEGL_BACKGROUND_RADIATION_DEFAULT             = 0.0
RDB_RIEGL_BACKGROUND_RADIATION_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_BACKGROUND_RADIATION_NAMED_VALUES        = ""
RDB_RIEGL_BACKGROUND_RADIATION_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_BACKGROUND_RADIATION_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_BACKGROUND_RADIATION_LOD_SETTINGS        = "default"
RDB_RIEGL_BACKGROUND_RADIATION_SCALE               = 1.0

# Background Radiation (for VZ-400-HTo only, Si-PD)
RDB_RIEGL_BACKGROUND_RADIATION_SI                     = "riegl.background_radiation_si"
RDB_RIEGL_BACKGROUND_RADIATION_SI_NAME                = "riegl.background_radiation_si"
RDB_RIEGL_BACKGROUND_RADIATION_SI_TITLE               = "Background Radiation Si-PD"
RDB_RIEGL_BACKGROUND_RADIATION_SI_GROUP               = "Primary Attributes"
RDB_RIEGL_BACKGROUND_RADIATION_SI_TAGS                = ""
RDB_RIEGL_BACKGROUND_RADIATION_SI_DESCRIPTION         = "Background Radiation (for VZ-400-HTo only, Si-PD)"
RDB_RIEGL_BACKGROUND_RADIATION_SI_UNIT                = ""
RDB_RIEGL_BACKGROUND_RADIATION_SI_LENGTH              = 1
RDB_RIEGL_BACKGROUND_RADIATION_SI_RESOLUTION          = 1.0
RDB_RIEGL_BACKGROUND_RADIATION_SI_MINIMUM             = 0.0
RDB_RIEGL_BACKGROUND_RADIATION_SI_MAXIMUM             = 65535.0
RDB_RIEGL_BACKGROUND_RADIATION_SI_DEFAULT             = 0.0
RDB_RIEGL_BACKGROUND_RADIATION_SI_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_BACKGROUND_RADIATION_SI_NAMED_VALUES        = ""
RDB_RIEGL_BACKGROUND_RADIATION_SI_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_BACKGROUND_RADIATION_SI_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_BACKGROUND_RADIATION_SI_LOD_SETTINGS        = "default"
RDB_RIEGL_BACKGROUND_RADIATION_SI_SCALE               = 1.0

# Background Radiation (for VZ-400-HTo only, InGaAs-PD)
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS                     = "riegl.background_radiation_ingaas"
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_NAME                = "riegl.background_radiation_ingaas"
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_TITLE               = "Background Radiation InGaAs-PD"
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_GROUP               = "Primary Attributes"
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_TAGS                = ""
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_DESCRIPTION         = "Background Radiation (for VZ-400-HTo only, InGaAs-PD)"
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_UNIT                = ""
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_LENGTH              = 1
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_RESOLUTION          = 1.0
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_MINIMUM             = 0.0
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_MAXIMUM             = 65535.0
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_DEFAULT             = 0.0
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_NAMED_VALUES        = ""
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_LOD_SETTINGS        = "default"
RDB_RIEGL_BACKGROUND_RADIATION_INGAAS_SCALE               = 1.0

# Estimated temperature derived from Background Radiation Si-PD
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI                     = "riegl.temperature_estimated_si"
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_NAME                = "riegl.temperature_estimated_si"
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_TITLE               = "Temperature Estimated Si-PD"
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_GROUP               = "Primary Attributes"
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_TAGS                = ""
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_DESCRIPTION         = "Estimated temperature derived from Background Radiation Si-PD"
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_UNIT                = "°C"
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_LENGTH              = 1
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_RESOLUTION          = 1.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_MINIMUM             = -1.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_MAXIMUM             = 2000.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_DEFAULT             = 0.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_INVALID             = -1.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_NAMED_VALUES        = ""
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_LOD_SETTINGS        = "default"
RDB_RIEGL_TEMPERATURE_ESTIMATED_SI_SCALE               = 1.0

# Estimated temperature derived from Background Radiation InGaAs-PD
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS                     = "riegl.temperature_estimated_ingaas"
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_NAME                = "riegl.temperature_estimated_ingaas"
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_TITLE               = "Temperature Estimated InGaAs-PD"
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_GROUP               = "Primary Attributes"
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_TAGS                = ""
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_DESCRIPTION         = "Estimated temperature derived from Background Radiation InGaAs-PD"
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_UNIT                = "°C"
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_LENGTH              = 1
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_RESOLUTION          = 1.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_MINIMUM             = -1.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_MAXIMUM             = 2000.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_DEFAULT             = 0.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_INVALID             = -1.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_NAMED_VALUES        = ""
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_LOD_SETTINGS        = "default"
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SCALE               = 1.0

# Estimated temperature derived from difference in Background Radiation InGaAs and Si
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI                     = "riegl.temperature_estimated_ingaas_si"
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_NAME                = "riegl.temperature_estimated_ingaas_si"
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_TITLE               = "Temperature Estimated InGaAs/Si-PD"
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_GROUP               = "Primary Attributes"
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_TAGS                = ""
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_DESCRIPTION         = "Estimated temperature derived from difference in Background Radiation InGaAs and Si"
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_UNIT                = "°C"
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_LENGTH              = 1
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_RESOLUTION          = 1.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_MINIMUM             = -1.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_MAXIMUM             = 2000.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_DEFAULT             = 0.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_INVALID             = -1.0
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_NAMED_VALUES        = ""
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_LOD_SETTINGS        = "default"
RDB_RIEGL_TEMPERATURE_ESTIMATED_INGAAS_SI_SCALE               = 1.0

# nth target of a laser-shot (0 = unknown, 1 = first target, ...)
RDB_RIEGL_TARGET_INDEX                     = "riegl.target_index"
RDB_RIEGL_TARGET_INDEX_NAME                = "riegl.target_index"
RDB_RIEGL_TARGET_INDEX_TITLE               = "Target Index"
RDB_RIEGL_TARGET_INDEX_GROUP               = "Primary Attributes"
RDB_RIEGL_TARGET_INDEX_TAGS                = ""
RDB_RIEGL_TARGET_INDEX_DESCRIPTION         = "nth target of a laser-shot (0 = unknown, 1 = first target, ...)"
RDB_RIEGL_TARGET_INDEX_UNIT                = ""
RDB_RIEGL_TARGET_INDEX_LENGTH              = 1
RDB_RIEGL_TARGET_INDEX_RESOLUTION          = 1.0
RDB_RIEGL_TARGET_INDEX_MINIMUM             = 0.0
RDB_RIEGL_TARGET_INDEX_MAXIMUM             = 255.0
RDB_RIEGL_TARGET_INDEX_DEFAULT             = 1.0
RDB_RIEGL_TARGET_INDEX_INVALID             = 0.0
RDB_RIEGL_TARGET_INDEX_NAMED_VALUES        = ""
RDB_RIEGL_TARGET_INDEX_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_TARGET_INDEX_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_TARGET_INDEX_LOD_SETTINGS        = "default"
RDB_RIEGL_TARGET_INDEX_SCALE               = 1.0

# Number of targets of a laser-shot (0 = unknown, 1 = one target, ...)
RDB_RIEGL_TARGET_COUNT                     = "riegl.target_count"
RDB_RIEGL_TARGET_COUNT_NAME                = "riegl.target_count"
RDB_RIEGL_TARGET_COUNT_TITLE               = "Target Count"
RDB_RIEGL_TARGET_COUNT_GROUP               = "Primary Attributes"
RDB_RIEGL_TARGET_COUNT_TAGS                = ""
RDB_RIEGL_TARGET_COUNT_DESCRIPTION         = "Number of targets of a laser-shot (0 = unknown, 1 = one target, ...)"
RDB_RIEGL_TARGET_COUNT_UNIT                = ""
RDB_RIEGL_TARGET_COUNT_LENGTH              = 1
RDB_RIEGL_TARGET_COUNT_RESOLUTION          = 1.0
RDB_RIEGL_TARGET_COUNT_MINIMUM             = 0.0
RDB_RIEGL_TARGET_COUNT_MAXIMUM             = 255.0
RDB_RIEGL_TARGET_COUNT_DEFAULT             = 1.0
RDB_RIEGL_TARGET_COUNT_INVALID             = 0.0
RDB_RIEGL_TARGET_COUNT_NAMED_VALUES        = ""
RDB_RIEGL_TARGET_COUNT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_TARGET_COUNT_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_TARGET_COUNT_LOD_SETTINGS        = "default"
RDB_RIEGL_TARGET_COUNT_SCALE               = 1.0

# Target rank among all targets of a laser-shot (0 = unknown, 1 = single, 2 = first, 3 = intermediate, 4 = last target)
RDB_RIEGL_TARGET_TYPE                     = "riegl.target_type"
RDB_RIEGL_TARGET_TYPE_NAME                = "riegl.target_type"
RDB_RIEGL_TARGET_TYPE_TITLE               = "Target Type"
RDB_RIEGL_TARGET_TYPE_GROUP               = "Primary Attributes"
RDB_RIEGL_TARGET_TYPE_TAGS                = "enumeration"
RDB_RIEGL_TARGET_TYPE_DESCRIPTION         = "Target rank among all targets of a laser-shot (0 = unknown, 1 = single, 2 = first, 3 = intermediate, 4 = last target)"
RDB_RIEGL_TARGET_TYPE_UNIT                = ""
RDB_RIEGL_TARGET_TYPE_LENGTH              = 1
RDB_RIEGL_TARGET_TYPE_RESOLUTION          = 1.0
RDB_RIEGL_TARGET_TYPE_MINIMUM             = 0.0
RDB_RIEGL_TARGET_TYPE_MAXIMUM             = 4.0
RDB_RIEGL_TARGET_TYPE_DEFAULT             = 0.0
RDB_RIEGL_TARGET_TYPE_INVALID             = 0.0
RDB_RIEGL_TARGET_TYPE_NAMED_VALUES        = "1=Single target\n2=First target\n3=Intermediate target\n4=Last target\n"
RDB_RIEGL_TARGET_TYPE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_TARGET_TYPE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_TARGET_TYPE_LOD_SETTINGS        = "default"
RDB_RIEGL_TARGET_TYPE_SCALE               = 1.0
#
RDB_RIEGL_TARGET_TYPE_UNKNOWN = 0
RDB_RIEGL_TARGET_TYPE_SINGLE = 1
RDB_RIEGL_TARGET_TYPE_FIRST = 2
RDB_RIEGL_TARGET_TYPE_INTERMEDIATE = 3
RDB_RIEGL_TARGET_TYPE_LAST = 4

# Identifier of first echo that belongs to the laser shot (0 = invalid). This is not an array index but the value of riegl.id of the echo.
RDB_RIEGL_ECHO_FIRST                     = "riegl.echo_first"
RDB_RIEGL_ECHO_FIRST_NAME                = "riegl.echo_first"
RDB_RIEGL_ECHO_FIRST_TITLE               = "Echo First"
RDB_RIEGL_ECHO_FIRST_GROUP               = "Primary Attributes"
RDB_RIEGL_ECHO_FIRST_TAGS                = ""
RDB_RIEGL_ECHO_FIRST_DESCRIPTION         = "Identifier of first echo that belongs to the laser shot (0 = invalid). This is not an array index but the value of riegl.id of the echo."
RDB_RIEGL_ECHO_FIRST_UNIT                = ""
RDB_RIEGL_ECHO_FIRST_LENGTH              = 1
RDB_RIEGL_ECHO_FIRST_RESOLUTION          = 1.0
RDB_RIEGL_ECHO_FIRST_MINIMUM             = 0.0
RDB_RIEGL_ECHO_FIRST_MAXIMUM             = 1.0e12
RDB_RIEGL_ECHO_FIRST_DEFAULT             = 0.0
RDB_RIEGL_ECHO_FIRST_INVALID             = 0.0
RDB_RIEGL_ECHO_FIRST_NAMED_VALUES        = ""
RDB_RIEGL_ECHO_FIRST_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_ECHO_FIRST_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_ECHO_FIRST_LOD_SETTINGS        = "default"
RDB_RIEGL_ECHO_FIRST_SCALE               = 1.0
#
RDB_RIEGL_ECHO_FIRST_INVALID = 0

# Number of echoes that belong to the laser shot
RDB_RIEGL_ECHO_COUNT                     = "riegl.echo_count"
RDB_RIEGL_ECHO_COUNT_NAME                = "riegl.echo_count"
RDB_RIEGL_ECHO_COUNT_TITLE               = "Echo Count"
RDB_RIEGL_ECHO_COUNT_GROUP               = "Primary Attributes"
RDB_RIEGL_ECHO_COUNT_TAGS                = ""
RDB_RIEGL_ECHO_COUNT_DESCRIPTION         = "Number of echoes that belong to the laser shot"
RDB_RIEGL_ECHO_COUNT_UNIT                = ""
RDB_RIEGL_ECHO_COUNT_LENGTH              = 1
RDB_RIEGL_ECHO_COUNT_RESOLUTION          = 1.0
RDB_RIEGL_ECHO_COUNT_MINIMUM             = 0.0
RDB_RIEGL_ECHO_COUNT_MAXIMUM             = 65535.0
RDB_RIEGL_ECHO_COUNT_DEFAULT             = 0.0
RDB_RIEGL_ECHO_COUNT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_ECHO_COUNT_NAMED_VALUES        = ""
RDB_RIEGL_ECHO_COUNT_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_ECHO_COUNT_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_ECHO_COUNT_LOD_SETTINGS        = "default"
RDB_RIEGL_ECHO_COUNT_SCALE               = 1.0

# Height at center of grid cell
RDB_RIEGL_HEIGHT_CENTER                     = "riegl.height_center"
RDB_RIEGL_HEIGHT_CENTER_NAME                = "riegl.height_center"
RDB_RIEGL_HEIGHT_CENTER_TITLE               = "Height Center"
RDB_RIEGL_HEIGHT_CENTER_GROUP               = "Primary Attributes"
RDB_RIEGL_HEIGHT_CENTER_TAGS                = ""
RDB_RIEGL_HEIGHT_CENTER_DESCRIPTION         = "Height at center of grid cell"
RDB_RIEGL_HEIGHT_CENTER_UNIT                = "m"
RDB_RIEGL_HEIGHT_CENTER_LENGTH              = 1
RDB_RIEGL_HEIGHT_CENTER_RESOLUTION          = 0.00025
RDB_RIEGL_HEIGHT_CENTER_MINIMUM             = -100000.0
RDB_RIEGL_HEIGHT_CENTER_MAXIMUM             = 100000.0
RDB_RIEGL_HEIGHT_CENTER_DEFAULT             = 0.0
RDB_RIEGL_HEIGHT_CENTER_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_HEIGHT_CENTER_NAMED_VALUES        = ""
RDB_RIEGL_HEIGHT_CENTER_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_HEIGHT_CENTER_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_HEIGHT_CENTER_LOD_SETTINGS        = "default"
RDB_RIEGL_HEIGHT_CENTER_SCALE               = 1.0

# Mean height within grid cell
RDB_RIEGL_HEIGHT_MEAN                     = "riegl.height_mean"
RDB_RIEGL_HEIGHT_MEAN_NAME                = "riegl.height_mean"
RDB_RIEGL_HEIGHT_MEAN_TITLE               = "Height Mean"
RDB_RIEGL_HEIGHT_MEAN_GROUP               = "Primary Attributes"
RDB_RIEGL_HEIGHT_MEAN_TAGS                = ""
RDB_RIEGL_HEIGHT_MEAN_DESCRIPTION         = "Mean height within grid cell"
RDB_RIEGL_HEIGHT_MEAN_UNIT                = "m"
RDB_RIEGL_HEIGHT_MEAN_LENGTH              = 1
RDB_RIEGL_HEIGHT_MEAN_RESOLUTION          = 0.00025
RDB_RIEGL_HEIGHT_MEAN_MINIMUM             = -100000.0
RDB_RIEGL_HEIGHT_MEAN_MAXIMUM             = 100000.0
RDB_RIEGL_HEIGHT_MEAN_DEFAULT             = 0.0
RDB_RIEGL_HEIGHT_MEAN_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_HEIGHT_MEAN_NAMED_VALUES        = ""
RDB_RIEGL_HEIGHT_MEAN_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_HEIGHT_MEAN_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_HEIGHT_MEAN_LOD_SETTINGS        = "default"
RDB_RIEGL_HEIGHT_MEAN_SCALE               = 1.0

# Minimum height within grid cell
RDB_RIEGL_HEIGHT_MIN                     = "riegl.height_min"
RDB_RIEGL_HEIGHT_MIN_NAME                = "riegl.height_min"
RDB_RIEGL_HEIGHT_MIN_TITLE               = "Height Minimum"
RDB_RIEGL_HEIGHT_MIN_GROUP               = "Primary Attributes"
RDB_RIEGL_HEIGHT_MIN_TAGS                = ""
RDB_RIEGL_HEIGHT_MIN_DESCRIPTION         = "Minimum height within grid cell"
RDB_RIEGL_HEIGHT_MIN_UNIT                = "m"
RDB_RIEGL_HEIGHT_MIN_LENGTH              = 1
RDB_RIEGL_HEIGHT_MIN_RESOLUTION          = 0.00025
RDB_RIEGL_HEIGHT_MIN_MINIMUM             = -100000.0
RDB_RIEGL_HEIGHT_MIN_MAXIMUM             = 100000.0
RDB_RIEGL_HEIGHT_MIN_DEFAULT             = 0.0
RDB_RIEGL_HEIGHT_MIN_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_HEIGHT_MIN_NAMED_VALUES        = ""
RDB_RIEGL_HEIGHT_MIN_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_HEIGHT_MIN_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_HEIGHT_MIN_LOD_SETTINGS        = "default"
RDB_RIEGL_HEIGHT_MIN_SCALE               = 1.0

# Maximum height within grid cell
RDB_RIEGL_HEIGHT_MAX                     = "riegl.height_max"
RDB_RIEGL_HEIGHT_MAX_NAME                = "riegl.height_max"
RDB_RIEGL_HEIGHT_MAX_TITLE               = "Height Maximum"
RDB_RIEGL_HEIGHT_MAX_GROUP               = "Primary Attributes"
RDB_RIEGL_HEIGHT_MAX_TAGS                = ""
RDB_RIEGL_HEIGHT_MAX_DESCRIPTION         = "Maximum height within grid cell"
RDB_RIEGL_HEIGHT_MAX_UNIT                = "m"
RDB_RIEGL_HEIGHT_MAX_LENGTH              = 1
RDB_RIEGL_HEIGHT_MAX_RESOLUTION          = 0.00025
RDB_RIEGL_HEIGHT_MAX_MINIMUM             = -100000.0
RDB_RIEGL_HEIGHT_MAX_MAXIMUM             = 100000.0
RDB_RIEGL_HEIGHT_MAX_DEFAULT             = 0.0
RDB_RIEGL_HEIGHT_MAX_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_HEIGHT_MAX_NAMED_VALUES        = ""
RDB_RIEGL_HEIGHT_MAX_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_HEIGHT_MAX_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_HEIGHT_MAX_LOD_SETTINGS        = "default"
RDB_RIEGL_HEIGHT_MAX_SCALE               = 1.0

# Number of points this point represents (e.g. points combined to voxels or plane patches, 0 = unknown)
RDB_RIEGL_POINT_COUNT                     = "riegl.point_count"
RDB_RIEGL_POINT_COUNT_NAME                = "riegl.point_count"
RDB_RIEGL_POINT_COUNT_TITLE               = "Point Count"
RDB_RIEGL_POINT_COUNT_GROUP               = "Primary Attributes"
RDB_RIEGL_POINT_COUNT_TAGS                = ""
RDB_RIEGL_POINT_COUNT_DESCRIPTION         = "Number of points this point represents (e.g. points combined to voxels or plane patches, 0 = unknown)"
RDB_RIEGL_POINT_COUNT_UNIT                = ""
RDB_RIEGL_POINT_COUNT_LENGTH              = 1
RDB_RIEGL_POINT_COUNT_RESOLUTION          = 1.0
RDB_RIEGL_POINT_COUNT_MINIMUM             = 0.0
RDB_RIEGL_POINT_COUNT_MAXIMUM             = 4294967295.0
RDB_RIEGL_POINT_COUNT_DEFAULT             = 0.0
RDB_RIEGL_POINT_COUNT_INVALID             = 0.0
RDB_RIEGL_POINT_COUNT_NAMED_VALUES        = ""
RDB_RIEGL_POINT_COUNT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POINT_COUNT_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POINT_COUNT_LOD_SETTINGS        = "default"
RDB_RIEGL_POINT_COUNT_SCALE               = 1.0
#
RDB_RIEGL_POINT_COUNT_UNKNOWN = 0

# Number of total points in a grid cell this point represents.
RDB_RIEGL_POINT_COUNT_GRID_CELL                     = "riegl.point_count_grid_cell"
RDB_RIEGL_POINT_COUNT_GRID_CELL_NAME                = "riegl.point_count_grid_cell"
RDB_RIEGL_POINT_COUNT_GRID_CELL_TITLE               = "Point Count of Grid Cell"
RDB_RIEGL_POINT_COUNT_GRID_CELL_GROUP               = "Primary Attributes"
RDB_RIEGL_POINT_COUNT_GRID_CELL_TAGS                = ""
RDB_RIEGL_POINT_COUNT_GRID_CELL_DESCRIPTION         = "Number of total points in a grid cell this point represents."
RDB_RIEGL_POINT_COUNT_GRID_CELL_UNIT                = ""
RDB_RIEGL_POINT_COUNT_GRID_CELL_LENGTH              = 1
RDB_RIEGL_POINT_COUNT_GRID_CELL_RESOLUTION          = 1.0
RDB_RIEGL_POINT_COUNT_GRID_CELL_MINIMUM             = 0.0
RDB_RIEGL_POINT_COUNT_GRID_CELL_MAXIMUM             = 4294967295.0
RDB_RIEGL_POINT_COUNT_GRID_CELL_DEFAULT             = 0.0
RDB_RIEGL_POINT_COUNT_GRID_CELL_INVALID             = 0.0
RDB_RIEGL_POINT_COUNT_GRID_CELL_NAMED_VALUES        = ""
RDB_RIEGL_POINT_COUNT_GRID_CELL_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POINT_COUNT_GRID_CELL_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POINT_COUNT_GRID_CELL_LOD_SETTINGS        = "default"
RDB_RIEGL_POINT_COUNT_GRID_CELL_SCALE               = 1.0
#
RDB_RIEGL_POINT_COUNT_GRID_CELL_UNKNOWN = 0

# Volume extents along 0: riegl.pca_axis_max, 1: riegl.pca_axis_min x riegl.pca_axis_max, 2: riegl.pca_axis_min
RDB_RIEGL_PCA_EXTENTS                     = "riegl.pca_extents"
RDB_RIEGL_PCA_EXTENTS_NAME                = "riegl.pca_extents"
RDB_RIEGL_PCA_EXTENTS_TITLE               = "PCA Extents"
RDB_RIEGL_PCA_EXTENTS_GROUP               = "Primary Attributes"
RDB_RIEGL_PCA_EXTENTS_TAGS                = ""
RDB_RIEGL_PCA_EXTENTS_DESCRIPTION         = "Volume extents along 0: riegl.pca_axis_max, 1: riegl.pca_axis_min x riegl.pca_axis_max, 2: riegl.pca_axis_min"
RDB_RIEGL_PCA_EXTENTS_UNIT                = "m"
RDB_RIEGL_PCA_EXTENTS_LENGTH              = 3
RDB_RIEGL_PCA_EXTENTS_RESOLUTION          = 0.00025
RDB_RIEGL_PCA_EXTENTS_MINIMUM             = 0.0
RDB_RIEGL_PCA_EXTENTS_MAXIMUM             = 1000.0
RDB_RIEGL_PCA_EXTENTS_DEFAULT             = 0.0
RDB_RIEGL_PCA_EXTENTS_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_PCA_EXTENTS_NAMED_VALUES        = ""
RDB_RIEGL_PCA_EXTENTS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PCA_EXTENTS_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PCA_EXTENTS_LOD_SETTINGS        = "default"
RDB_RIEGL_PCA_EXTENTS_SCALE               = 1.0

# Volume extents along riegl.pca_axis_min or riegl.surface_normal (result of PCA)
RDB_RIEGL_PCA_THICKNESS                     = "riegl.pca_thickness"
RDB_RIEGL_PCA_THICKNESS_NAME                = "riegl.pca_thickness"
RDB_RIEGL_PCA_THICKNESS_TITLE               = "PCA Thickness"
RDB_RIEGL_PCA_THICKNESS_GROUP               = "Primary Attributes"
RDB_RIEGL_PCA_THICKNESS_TAGS                = ""
RDB_RIEGL_PCA_THICKNESS_DESCRIPTION         = "Volume extents along riegl.pca_axis_min or riegl.surface_normal (result of PCA)"
RDB_RIEGL_PCA_THICKNESS_UNIT                = "m"
RDB_RIEGL_PCA_THICKNESS_LENGTH              = 1
RDB_RIEGL_PCA_THICKNESS_RESOLUTION          = 0.00025
RDB_RIEGL_PCA_THICKNESS_MINIMUM             = 0.0
RDB_RIEGL_PCA_THICKNESS_MAXIMUM             = 1000.0
RDB_RIEGL_PCA_THICKNESS_DEFAULT             = 0.0
RDB_RIEGL_PCA_THICKNESS_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_PCA_THICKNESS_NAMED_VALUES        = ""
RDB_RIEGL_PCA_THICKNESS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PCA_THICKNESS_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PCA_THICKNESS_LOD_SETTINGS        = "default"
RDB_RIEGL_PCA_THICKNESS_SCALE               = 1.0

# Standard deviation, e.g. of residual point-to-plane distances (0 = unknown)
RDB_RIEGL_STD_DEV                     = "riegl.std_dev"
RDB_RIEGL_STD_DEV_NAME                = "riegl.std_dev"
RDB_RIEGL_STD_DEV_TITLE               = "Standard Deviation"
RDB_RIEGL_STD_DEV_GROUP               = "Primary Attributes"
RDB_RIEGL_STD_DEV_TAGS                = ""
RDB_RIEGL_STD_DEV_DESCRIPTION         = "Standard deviation, e.g. of residual point-to-plane distances (0 = unknown)"
RDB_RIEGL_STD_DEV_UNIT                = "m"
RDB_RIEGL_STD_DEV_LENGTH              = 1
RDB_RIEGL_STD_DEV_RESOLUTION          = 0.0001
RDB_RIEGL_STD_DEV_MINIMUM             = 0.0
RDB_RIEGL_STD_DEV_MAXIMUM             = 65.535
RDB_RIEGL_STD_DEV_DEFAULT             = 0.0
RDB_RIEGL_STD_DEV_INVALID             = 0.0
RDB_RIEGL_STD_DEV_NAMED_VALUES        = ""
RDB_RIEGL_STD_DEV_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_STD_DEV_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_STD_DEV_LOD_SETTINGS        = "default"
RDB_RIEGL_STD_DEV_SCALE               = 1.0
#
RDB_RIEGL_STD_DEV_UNKNOWN = 0.0

# Confidence ellipse for the normal vector of a plane patch (0: up-axis, 1: width-axis, tilt angle wrt. up-axis)
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL                     = "riegl.plane_confidence_normal"
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_NAME                = "riegl.plane_confidence_normal"
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_TITLE               = "Confidence Normal Direction"
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_GROUP               = "Primary Attributes"
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_TAGS                = ""
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_DESCRIPTION         = "Confidence ellipse for the normal vector of a plane patch (0: up-axis, 1: width-axis, tilt angle wrt. up-axis)"
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_UNIT                = "deg"
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_LENGTH              = 3
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_RESOLUTION          = 0.006
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_MINIMUM             = -180.006
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_MAXIMUM             = 180.0
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_DEFAULT             = 0.0
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_INVALID             = -180.006
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_NAMED_VALUES        = ""
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_LOD_SETTINGS        = "default"
RDB_RIEGL_PLANE_CONFIDENCE_NORMAL_SCALE               = 1.0

# Plane patch slope class number. Meaning see metadata riegl.plane_slope_class_info (0 = invalid)
RDB_RIEGL_PLANE_SLOPE_CLASS                     = "riegl.plane_slope_class"
RDB_RIEGL_PLANE_SLOPE_CLASS_NAME                = "riegl.plane_slope_class"
RDB_RIEGL_PLANE_SLOPE_CLASS_TITLE               = "Plane Patch Slope Class"
RDB_RIEGL_PLANE_SLOPE_CLASS_GROUP               = "Primary Attributes"
RDB_RIEGL_PLANE_SLOPE_CLASS_TAGS                = "enumeration"
RDB_RIEGL_PLANE_SLOPE_CLASS_DESCRIPTION         = "Plane patch slope class number. Meaning see metadata riegl.plane_slope_class_info (0 = invalid)"
RDB_RIEGL_PLANE_SLOPE_CLASS_UNIT                = ""
RDB_RIEGL_PLANE_SLOPE_CLASS_LENGTH              = 1
RDB_RIEGL_PLANE_SLOPE_CLASS_RESOLUTION          = 1.0
RDB_RIEGL_PLANE_SLOPE_CLASS_MINIMUM             = 0.0
RDB_RIEGL_PLANE_SLOPE_CLASS_MAXIMUM             = 255.0
RDB_RIEGL_PLANE_SLOPE_CLASS_DEFAULT             = 0.0
RDB_RIEGL_PLANE_SLOPE_CLASS_INVALID             = 0.0
RDB_RIEGL_PLANE_SLOPE_CLASS_NAMED_VALUES        = ""
RDB_RIEGL_PLANE_SLOPE_CLASS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PLANE_SLOPE_CLASS_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_PLANE_SLOPE_CLASS_LOD_SETTINGS        = "default"
RDB_RIEGL_PLANE_SLOPE_CLASS_SCALE               = 1.0

# 8x8 occupancy matrix indicating point support of plane patch
RDB_RIEGL_PLANE_OCCUPANCY                     = "riegl.plane_occupancy"
RDB_RIEGL_PLANE_OCCUPANCY_NAME                = "riegl.plane_occupancy"
RDB_RIEGL_PLANE_OCCUPANCY_TITLE               = "Plane Patch Occupancy"
RDB_RIEGL_PLANE_OCCUPANCY_GROUP               = "Primary Attributes"
RDB_RIEGL_PLANE_OCCUPANCY_TAGS                = ""
RDB_RIEGL_PLANE_OCCUPANCY_DESCRIPTION         = "8x8 occupancy matrix indicating point support of plane patch"
RDB_RIEGL_PLANE_OCCUPANCY_UNIT                = ""
RDB_RIEGL_PLANE_OCCUPANCY_LENGTH              = 8
RDB_RIEGL_PLANE_OCCUPANCY_RESOLUTION          = 1.0
RDB_RIEGL_PLANE_OCCUPANCY_MINIMUM             = 0.0
RDB_RIEGL_PLANE_OCCUPANCY_MAXIMUM             = 255.0
RDB_RIEGL_PLANE_OCCUPANCY_DEFAULT             = 0.0
RDB_RIEGL_PLANE_OCCUPANCY_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_PLANE_OCCUPANCY_NAMED_VALUES        = ""
RDB_RIEGL_PLANE_OCCUPANCY_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PLANE_OCCUPANCY_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_PLANE_OCCUPANCY_LOD_SETTINGS        = "default"
RDB_RIEGL_PLANE_OCCUPANCY_SCALE               = 1.0

# Size of plane patch along the longer edge (0 = unknown)
RDB_RIEGL_PLANE_WIDTH                     = "riegl.plane_width"
RDB_RIEGL_PLANE_WIDTH_NAME                = "riegl.plane_width"
RDB_RIEGL_PLANE_WIDTH_TITLE               = "Plane Patch Width"
RDB_RIEGL_PLANE_WIDTH_GROUP               = "Primary Attributes"
RDB_RIEGL_PLANE_WIDTH_TAGS                = ""
RDB_RIEGL_PLANE_WIDTH_DESCRIPTION         = "Size of plane patch along the longer edge (0 = unknown)"
RDB_RIEGL_PLANE_WIDTH_UNIT                = "m"
RDB_RIEGL_PLANE_WIDTH_LENGTH              = 1
RDB_RIEGL_PLANE_WIDTH_RESOLUTION          = 0.001
RDB_RIEGL_PLANE_WIDTH_MINIMUM             = 0.0
RDB_RIEGL_PLANE_WIDTH_MAXIMUM             = 1000.0
RDB_RIEGL_PLANE_WIDTH_DEFAULT             = 0.0
RDB_RIEGL_PLANE_WIDTH_INVALID             = 0.0
RDB_RIEGL_PLANE_WIDTH_NAMED_VALUES        = ""
RDB_RIEGL_PLANE_WIDTH_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PLANE_WIDTH_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PLANE_WIDTH_LOD_SETTINGS        = "default"
RDB_RIEGL_PLANE_WIDTH_SCALE               = 1.0
#
RDB_RIEGL_PLANE_WIDTH_UNKNOWN = 0.0

# Size of plane patch along the shorter edge (0 = unknown)
RDB_RIEGL_PLANE_HEIGHT                     = "riegl.plane_height"
RDB_RIEGL_PLANE_HEIGHT_NAME                = "riegl.plane_height"
RDB_RIEGL_PLANE_HEIGHT_TITLE               = "Plane Patch Height"
RDB_RIEGL_PLANE_HEIGHT_GROUP               = "Primary Attributes"
RDB_RIEGL_PLANE_HEIGHT_TAGS                = ""
RDB_RIEGL_PLANE_HEIGHT_DESCRIPTION         = "Size of plane patch along the shorter edge (0 = unknown)"
RDB_RIEGL_PLANE_HEIGHT_UNIT                = "m"
RDB_RIEGL_PLANE_HEIGHT_LENGTH              = 1
RDB_RIEGL_PLANE_HEIGHT_RESOLUTION          = 0.001
RDB_RIEGL_PLANE_HEIGHT_MINIMUM             = 0.0
RDB_RIEGL_PLANE_HEIGHT_MAXIMUM             = 1000.0
RDB_RIEGL_PLANE_HEIGHT_DEFAULT             = 0.0
RDB_RIEGL_PLANE_HEIGHT_INVALID             = 0.0
RDB_RIEGL_PLANE_HEIGHT_NAMED_VALUES        = ""
RDB_RIEGL_PLANE_HEIGHT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PLANE_HEIGHT_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PLANE_HEIGHT_LOD_SETTINGS        = "default"
RDB_RIEGL_PLANE_HEIGHT_SCALE               = 1.0
#
RDB_RIEGL_PLANE_HEIGHT_UNKNOWN = 0.0

# For merged plane patches, the number of plane patches the merged plane patch is based on
RDB_RIEGL_PLANE_COUNT                     = "riegl.plane_count"
RDB_RIEGL_PLANE_COUNT_NAME                = "riegl.plane_count"
RDB_RIEGL_PLANE_COUNT_TITLE               = "Plane Patch Count"
RDB_RIEGL_PLANE_COUNT_GROUP               = "Primary Attributes"
RDB_RIEGL_PLANE_COUNT_TAGS                = ""
RDB_RIEGL_PLANE_COUNT_DESCRIPTION         = "For merged plane patches, the number of plane patches the merged plane patch is based on"
RDB_RIEGL_PLANE_COUNT_UNIT                = ""
RDB_RIEGL_PLANE_COUNT_LENGTH              = 1
RDB_RIEGL_PLANE_COUNT_RESOLUTION          = 1.0
RDB_RIEGL_PLANE_COUNT_MINIMUM             = 0.0
RDB_RIEGL_PLANE_COUNT_MAXIMUM             = 65535.0
RDB_RIEGL_PLANE_COUNT_DEFAULT             = 1.0
RDB_RIEGL_PLANE_COUNT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_PLANE_COUNT_NAMED_VALUES        = ""
RDB_RIEGL_PLANE_COUNT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PLANE_COUNT_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PLANE_COUNT_LOD_SETTINGS        = "default"
RDB_RIEGL_PLANE_COUNT_SCALE               = 1.0

# The number of source plane patch files the plane patch has matches to
RDB_RIEGL_MATCH_COUNT                     = "riegl.match_count"
RDB_RIEGL_MATCH_COUNT_NAME                = "riegl.match_count"
RDB_RIEGL_MATCH_COUNT_TITLE               = "Plane Patch Match Count"
RDB_RIEGL_MATCH_COUNT_GROUP               = "Primary Attributes"
RDB_RIEGL_MATCH_COUNT_TAGS                = ""
RDB_RIEGL_MATCH_COUNT_DESCRIPTION         = "The number of source plane patch files the plane patch has matches to"
RDB_RIEGL_MATCH_COUNT_UNIT                = ""
RDB_RIEGL_MATCH_COUNT_LENGTH              = 1
RDB_RIEGL_MATCH_COUNT_RESOLUTION          = 1.0
RDB_RIEGL_MATCH_COUNT_MINIMUM             = 0.0
RDB_RIEGL_MATCH_COUNT_MAXIMUM             = 65535.0
RDB_RIEGL_MATCH_COUNT_DEFAULT             = 0.0
RDB_RIEGL_MATCH_COUNT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_MATCH_COUNT_NAMED_VALUES        = ""
RDB_RIEGL_MATCH_COUNT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_MATCH_COUNT_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_MATCH_COUNT_LOD_SETTINGS        = "default"
RDB_RIEGL_MATCH_COUNT_SCALE               = 1.0

# Distance between the origins of two plane patches, projected onto the average of their normal vectors
RDB_RIEGL_PLANE_PATCH_DISTANCE                     = "riegl.plane_patch_distance"
RDB_RIEGL_PLANE_PATCH_DISTANCE_NAME                = "riegl.plane_patch_distance"
RDB_RIEGL_PLANE_PATCH_DISTANCE_TITLE               = "Plane Patch Distance"
RDB_RIEGL_PLANE_PATCH_DISTANCE_GROUP               = "Primary Attributes"
RDB_RIEGL_PLANE_PATCH_DISTANCE_TAGS                = ""
RDB_RIEGL_PLANE_PATCH_DISTANCE_DESCRIPTION         = "Distance between the origins of two plane patches, projected onto the average of their normal vectors"
RDB_RIEGL_PLANE_PATCH_DISTANCE_UNIT                = "m"
RDB_RIEGL_PLANE_PATCH_DISTANCE_LENGTH              = 1
RDB_RIEGL_PLANE_PATCH_DISTANCE_RESOLUTION          = 0.00025
RDB_RIEGL_PLANE_PATCH_DISTANCE_MINIMUM             = -2100.0
RDB_RIEGL_PLANE_PATCH_DISTANCE_MAXIMUM             = 2000.0
RDB_RIEGL_PLANE_PATCH_DISTANCE_DEFAULT             = -2100.0
RDB_RIEGL_PLANE_PATCH_DISTANCE_INVALID             = -2100.0
RDB_RIEGL_PLANE_PATCH_DISTANCE_NAMED_VALUES        = ""
RDB_RIEGL_PLANE_PATCH_DISTANCE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PLANE_PATCH_DISTANCE_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PLANE_PATCH_DISTANCE_LOD_SETTINGS        = "default"
RDB_RIEGL_PLANE_PATCH_DISTANCE_SCALE               = 1.0
#
RDB_RIEGL_PLANE_PATCH_DISTANCE_LOWEST = -2000.0

# Distance between the origins of two plane patches, projected onto the plane defined by the average of their normal vectors
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE                     = "riegl.plane_patch_lateral_distance"
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_NAME                = "riegl.plane_patch_lateral_distance"
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_TITLE               = "Plane Patch Lateral Distance"
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_GROUP               = "Primary Attributes"
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_TAGS                = ""
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_DESCRIPTION         = "Distance between the origins of two plane patches, projected onto the plane defined by the average of their normal vectors"
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_UNIT                = "m"
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_LENGTH              = 1
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_RESOLUTION          = 0.00025
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_MINIMUM             = -2100.0
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_MAXIMUM             = 2000.0
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_DEFAULT             = -2100.0
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_INVALID             = -2100.0
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_NAMED_VALUES        = ""
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_LOD_SETTINGS        = "default"
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_SCALE               = 1.0
#
RDB_RIEGL_PLANE_PATCH_LATERAL_DISTANCE_LOWEST = -2000.0

# Angle between the normal vectors of two plane patches
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE                     = "riegl.plane_patch_angular_distance"
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_NAME                = "riegl.plane_patch_angular_distance"
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_TITLE               = "Plane Patch Angular Distance"
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_GROUP               = "Primary Attributes"
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_TAGS                = ""
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_DESCRIPTION         = "Angle between the normal vectors of two plane patches"
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_UNIT                = "deg"
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_LENGTH              = 1
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_RESOLUTION          = 1.0e-6
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_MINIMUM             = -1.0
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_MAXIMUM             = 180.0
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_DEFAULT             = -1.0
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_INVALID             = -1.0
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_NAMED_VALUES        = ""
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_LOD_SETTINGS        = "default"
RDB_RIEGL_PLANE_PATCH_ANGULAR_DISTANCE_SCALE               = 1.0

# Accuracy in North direction
RDB_RIEGL_POF_ACCURACY_NORTH                     = "riegl.pof_accuracy_north"
RDB_RIEGL_POF_ACCURACY_NORTH_NAME                = "riegl.pof_accuracy_north"
RDB_RIEGL_POF_ACCURACY_NORTH_TITLE               = "Accuracy North"
RDB_RIEGL_POF_ACCURACY_NORTH_GROUP               = "Primary Attributes"
RDB_RIEGL_POF_ACCURACY_NORTH_TAGS                = ""
RDB_RIEGL_POF_ACCURACY_NORTH_DESCRIPTION         = "Accuracy in North direction"
RDB_RIEGL_POF_ACCURACY_NORTH_UNIT                = "m"
RDB_RIEGL_POF_ACCURACY_NORTH_LENGTH              = 1
RDB_RIEGL_POF_ACCURACY_NORTH_RESOLUTION          = 1.0e-6
RDB_RIEGL_POF_ACCURACY_NORTH_MINIMUM             = 0.0
RDB_RIEGL_POF_ACCURACY_NORTH_MAXIMUM             = 1000.0
RDB_RIEGL_POF_ACCURACY_NORTH_DEFAULT             = 0.0
RDB_RIEGL_POF_ACCURACY_NORTH_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_ACCURACY_NORTH_NAMED_VALUES        = ""
RDB_RIEGL_POF_ACCURACY_NORTH_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_ACCURACY_NORTH_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_ACCURACY_NORTH_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_ACCURACY_NORTH_SCALE               = 1.0

# Accuracy in East direction
RDB_RIEGL_POF_ACCURACY_EAST                     = "riegl.pof_accuracy_east"
RDB_RIEGL_POF_ACCURACY_EAST_NAME                = "riegl.pof_accuracy_east"
RDB_RIEGL_POF_ACCURACY_EAST_TITLE               = "Accuracy East"
RDB_RIEGL_POF_ACCURACY_EAST_GROUP               = "Primary Attributes"
RDB_RIEGL_POF_ACCURACY_EAST_TAGS                = ""
RDB_RIEGL_POF_ACCURACY_EAST_DESCRIPTION         = "Accuracy in East direction"
RDB_RIEGL_POF_ACCURACY_EAST_UNIT                = "m"
RDB_RIEGL_POF_ACCURACY_EAST_LENGTH              = 1
RDB_RIEGL_POF_ACCURACY_EAST_RESOLUTION          = 1.0e-6
RDB_RIEGL_POF_ACCURACY_EAST_MINIMUM             = 0.0
RDB_RIEGL_POF_ACCURACY_EAST_MAXIMUM             = 1000.0
RDB_RIEGL_POF_ACCURACY_EAST_DEFAULT             = 0.0
RDB_RIEGL_POF_ACCURACY_EAST_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_ACCURACY_EAST_NAMED_VALUES        = ""
RDB_RIEGL_POF_ACCURACY_EAST_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_ACCURACY_EAST_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_ACCURACY_EAST_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_ACCURACY_EAST_SCALE               = 1.0

# Accuracy in Down direction
RDB_RIEGL_POF_ACCURACY_DOWN                     = "riegl.pof_accuracy_down"
RDB_RIEGL_POF_ACCURACY_DOWN_NAME                = "riegl.pof_accuracy_down"
RDB_RIEGL_POF_ACCURACY_DOWN_TITLE               = "Accuracy Down"
RDB_RIEGL_POF_ACCURACY_DOWN_GROUP               = "Primary Attributes"
RDB_RIEGL_POF_ACCURACY_DOWN_TAGS                = ""
RDB_RIEGL_POF_ACCURACY_DOWN_DESCRIPTION         = "Accuracy in Down direction"
RDB_RIEGL_POF_ACCURACY_DOWN_UNIT                = "m"
RDB_RIEGL_POF_ACCURACY_DOWN_LENGTH              = 1
RDB_RIEGL_POF_ACCURACY_DOWN_RESOLUTION          = 1.0e-6
RDB_RIEGL_POF_ACCURACY_DOWN_MINIMUM             = 0.0
RDB_RIEGL_POF_ACCURACY_DOWN_MAXIMUM             = 1000.0
RDB_RIEGL_POF_ACCURACY_DOWN_DEFAULT             = 0.0
RDB_RIEGL_POF_ACCURACY_DOWN_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_ACCURACY_DOWN_NAMED_VALUES        = ""
RDB_RIEGL_POF_ACCURACY_DOWN_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_ACCURACY_DOWN_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_ACCURACY_DOWN_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_ACCURACY_DOWN_SCALE               = 1.0

# Accuracy of Roll rotation
RDB_RIEGL_POF_ACCURACY_ROLL                     = "riegl.pof_accuracy_roll"
RDB_RIEGL_POF_ACCURACY_ROLL_NAME                = "riegl.pof_accuracy_roll"
RDB_RIEGL_POF_ACCURACY_ROLL_TITLE               = "Accuracy Roll"
RDB_RIEGL_POF_ACCURACY_ROLL_GROUP               = "Primary Attributes"
RDB_RIEGL_POF_ACCURACY_ROLL_TAGS                = ""
RDB_RIEGL_POF_ACCURACY_ROLL_DESCRIPTION         = "Accuracy of Roll rotation"
RDB_RIEGL_POF_ACCURACY_ROLL_UNIT                = "deg"
RDB_RIEGL_POF_ACCURACY_ROLL_LENGTH              = 1
RDB_RIEGL_POF_ACCURACY_ROLL_RESOLUTION          = 1.0e-6
RDB_RIEGL_POF_ACCURACY_ROLL_MINIMUM             = 0.0
RDB_RIEGL_POF_ACCURACY_ROLL_MAXIMUM             = 360.0
RDB_RIEGL_POF_ACCURACY_ROLL_DEFAULT             = 0.0
RDB_RIEGL_POF_ACCURACY_ROLL_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_ACCURACY_ROLL_NAMED_VALUES        = ""
RDB_RIEGL_POF_ACCURACY_ROLL_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_ACCURACY_ROLL_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_ACCURACY_ROLL_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_ACCURACY_ROLL_SCALE               = 1.0

# Accuracy of Pitch rotation
RDB_RIEGL_POF_ACCURACY_PITCH                     = "riegl.pof_accuracy_pitch"
RDB_RIEGL_POF_ACCURACY_PITCH_NAME                = "riegl.pof_accuracy_pitch"
RDB_RIEGL_POF_ACCURACY_PITCH_TITLE               = "Accuracy Pitch"
RDB_RIEGL_POF_ACCURACY_PITCH_GROUP               = "Primary Attributes"
RDB_RIEGL_POF_ACCURACY_PITCH_TAGS                = ""
RDB_RIEGL_POF_ACCURACY_PITCH_DESCRIPTION         = "Accuracy of Pitch rotation"
RDB_RIEGL_POF_ACCURACY_PITCH_UNIT                = "deg"
RDB_RIEGL_POF_ACCURACY_PITCH_LENGTH              = 1
RDB_RIEGL_POF_ACCURACY_PITCH_RESOLUTION          = 1.0e-6
RDB_RIEGL_POF_ACCURACY_PITCH_MINIMUM             = 0.0
RDB_RIEGL_POF_ACCURACY_PITCH_MAXIMUM             = 360.0
RDB_RIEGL_POF_ACCURACY_PITCH_DEFAULT             = 0.0
RDB_RIEGL_POF_ACCURACY_PITCH_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_ACCURACY_PITCH_NAMED_VALUES        = ""
RDB_RIEGL_POF_ACCURACY_PITCH_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_ACCURACY_PITCH_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_ACCURACY_PITCH_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_ACCURACY_PITCH_SCALE               = 1.0

# Accuracy of Yaw rotation
RDB_RIEGL_POF_ACCURACY_YAW                     = "riegl.pof_accuracy_yaw"
RDB_RIEGL_POF_ACCURACY_YAW_NAME                = "riegl.pof_accuracy_yaw"
RDB_RIEGL_POF_ACCURACY_YAW_TITLE               = "Accuracy Yaw"
RDB_RIEGL_POF_ACCURACY_YAW_GROUP               = "Primary Attributes"
RDB_RIEGL_POF_ACCURACY_YAW_TAGS                = ""
RDB_RIEGL_POF_ACCURACY_YAW_DESCRIPTION         = "Accuracy of Yaw rotation"
RDB_RIEGL_POF_ACCURACY_YAW_UNIT                = "deg"
RDB_RIEGL_POF_ACCURACY_YAW_LENGTH              = 1
RDB_RIEGL_POF_ACCURACY_YAW_RESOLUTION          = 1.0e-6
RDB_RIEGL_POF_ACCURACY_YAW_MINIMUM             = 0.0
RDB_RIEGL_POF_ACCURACY_YAW_MAXIMUM             = 360.0
RDB_RIEGL_POF_ACCURACY_YAW_DEFAULT             = 0.0
RDB_RIEGL_POF_ACCURACY_YAW_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_ACCURACY_YAW_NAMED_VALUES        = ""
RDB_RIEGL_POF_ACCURACY_YAW_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_ACCURACY_YAW_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_ACCURACY_YAW_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_ACCURACY_YAW_SCALE               = 1.0

# Waveform sample block channel number (255 = invalid)
RDB_RIEGL_WFM_SBL_CHANNEL                     = "riegl.wfm_sbl_channel"
RDB_RIEGL_WFM_SBL_CHANNEL_NAME                = "riegl.wfm_sbl_channel"
RDB_RIEGL_WFM_SBL_CHANNEL_TITLE               = "Waveform Sample Block Channel"
RDB_RIEGL_WFM_SBL_CHANNEL_GROUP               = "Primary Attributes"
RDB_RIEGL_WFM_SBL_CHANNEL_TAGS                = "enumeration"
RDB_RIEGL_WFM_SBL_CHANNEL_DESCRIPTION         = "Waveform sample block channel number (255 = invalid)"
RDB_RIEGL_WFM_SBL_CHANNEL_UNIT                = ""
RDB_RIEGL_WFM_SBL_CHANNEL_LENGTH              = 1
RDB_RIEGL_WFM_SBL_CHANNEL_RESOLUTION          = 1.0
RDB_RIEGL_WFM_SBL_CHANNEL_MINIMUM             = 0.0
RDB_RIEGL_WFM_SBL_CHANNEL_MAXIMUM             = 255.0
RDB_RIEGL_WFM_SBL_CHANNEL_DEFAULT             = 255.0
RDB_RIEGL_WFM_SBL_CHANNEL_INVALID             = 255.0
RDB_RIEGL_WFM_SBL_CHANNEL_NAMED_VALUES        = "0=High power\n1=Low power\n3=Reference pulse\n"
RDB_RIEGL_WFM_SBL_CHANNEL_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_WFM_SBL_CHANNEL_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_WFM_SBL_CHANNEL_LOD_SETTINGS        = "default"
RDB_RIEGL_WFM_SBL_CHANNEL_SCALE               = 1.0
#
RDB_RIEGL_WFM_SBL_CHANNEL_INVALID = 255

# Waveform sample value mean
RDB_RIEGL_WFM_SBL_MEAN                     = "riegl.wfm_sbl_mean"
RDB_RIEGL_WFM_SBL_MEAN_NAME                = "riegl.wfm_sbl_mean"
RDB_RIEGL_WFM_SBL_MEAN_TITLE               = "Waveform Sample Value Mean"
RDB_RIEGL_WFM_SBL_MEAN_GROUP               = "Primary Attributes"
RDB_RIEGL_WFM_SBL_MEAN_TAGS                = ""
RDB_RIEGL_WFM_SBL_MEAN_DESCRIPTION         = "Waveform sample value mean"
RDB_RIEGL_WFM_SBL_MEAN_UNIT                = ""
RDB_RIEGL_WFM_SBL_MEAN_LENGTH              = 1
RDB_RIEGL_WFM_SBL_MEAN_RESOLUTION          = 0.0625
RDB_RIEGL_WFM_SBL_MEAN_MINIMUM             = 0.0
RDB_RIEGL_WFM_SBL_MEAN_MAXIMUM             = 4095.0
RDB_RIEGL_WFM_SBL_MEAN_DEFAULT             = 0.0
RDB_RIEGL_WFM_SBL_MEAN_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_WFM_SBL_MEAN_NAMED_VALUES        = ""
RDB_RIEGL_WFM_SBL_MEAN_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_WFM_SBL_MEAN_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_WFM_SBL_MEAN_LOD_SETTINGS        = "default"
RDB_RIEGL_WFM_SBL_MEAN_SCALE               = 1.0

# Waveform sample value standard deviation
RDB_RIEGL_WFM_SBL_STD_DEV                     = "riegl.wfm_sbl_std_dev"
RDB_RIEGL_WFM_SBL_STD_DEV_NAME                = "riegl.wfm_sbl_std_dev"
RDB_RIEGL_WFM_SBL_STD_DEV_TITLE               = "Waveform Sample Value Standard Deviation"
RDB_RIEGL_WFM_SBL_STD_DEV_GROUP               = "Primary Attributes"
RDB_RIEGL_WFM_SBL_STD_DEV_TAGS                = ""
RDB_RIEGL_WFM_SBL_STD_DEV_DESCRIPTION         = "Waveform sample value standard deviation"
RDB_RIEGL_WFM_SBL_STD_DEV_UNIT                = ""
RDB_RIEGL_WFM_SBL_STD_DEV_LENGTH              = 1
RDB_RIEGL_WFM_SBL_STD_DEV_RESOLUTION          = 0.25
RDB_RIEGL_WFM_SBL_STD_DEV_MINIMUM             = 0.0
RDB_RIEGL_WFM_SBL_STD_DEV_MAXIMUM             = 255.0
RDB_RIEGL_WFM_SBL_STD_DEV_DEFAULT             = 0.0
RDB_RIEGL_WFM_SBL_STD_DEV_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_WFM_SBL_STD_DEV_NAMED_VALUES        = ""
RDB_RIEGL_WFM_SBL_STD_DEV_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_WFM_SBL_STD_DEV_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_WFM_SBL_STD_DEV_LOD_SETTINGS        = "default"
RDB_RIEGL_WFM_SBL_STD_DEV_SCALE               = 1.0

# Identifier of first waveform sample block that belongs to the laser shot (0 = invalid). This is not an array index but the value of riegl.id of the block.
RDB_RIEGL_WFM_SBL_FIRST                     = "riegl.wfm_sbl_first"
RDB_RIEGL_WFM_SBL_FIRST_NAME                = "riegl.wfm_sbl_first"
RDB_RIEGL_WFM_SBL_FIRST_TITLE               = "Waveform Sample Block First"
RDB_RIEGL_WFM_SBL_FIRST_GROUP               = "Primary Attributes"
RDB_RIEGL_WFM_SBL_FIRST_TAGS                = ""
RDB_RIEGL_WFM_SBL_FIRST_DESCRIPTION         = "Identifier of first waveform sample block that belongs to the laser shot (0 = invalid). This is not an array index but the value of riegl.id of the block."
RDB_RIEGL_WFM_SBL_FIRST_UNIT                = ""
RDB_RIEGL_WFM_SBL_FIRST_LENGTH              = 1
RDB_RIEGL_WFM_SBL_FIRST_RESOLUTION          = 1.0
RDB_RIEGL_WFM_SBL_FIRST_MINIMUM             = 0.0
RDB_RIEGL_WFM_SBL_FIRST_MAXIMUM             = 1.0e12
RDB_RIEGL_WFM_SBL_FIRST_DEFAULT             = 0.0
RDB_RIEGL_WFM_SBL_FIRST_INVALID             = 0.0
RDB_RIEGL_WFM_SBL_FIRST_NAMED_VALUES        = ""
RDB_RIEGL_WFM_SBL_FIRST_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_WFM_SBL_FIRST_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_WFM_SBL_FIRST_LOD_SETTINGS        = "default"
RDB_RIEGL_WFM_SBL_FIRST_SCALE               = 1.0
#
RDB_RIEGL_WFM_SBL_FIRST_INVALID = 0

# Number of waveform sample blocks that belong to the laser shot
RDB_RIEGL_WFM_SBL_COUNT                     = "riegl.wfm_sbl_count"
RDB_RIEGL_WFM_SBL_COUNT_NAME                = "riegl.wfm_sbl_count"
RDB_RIEGL_WFM_SBL_COUNT_TITLE               = "Waveform Sample Block Count"
RDB_RIEGL_WFM_SBL_COUNT_GROUP               = "Primary Attributes"
RDB_RIEGL_WFM_SBL_COUNT_TAGS                = ""
RDB_RIEGL_WFM_SBL_COUNT_DESCRIPTION         = "Number of waveform sample blocks that belong to the laser shot"
RDB_RIEGL_WFM_SBL_COUNT_UNIT                = ""
RDB_RIEGL_WFM_SBL_COUNT_LENGTH              = 1
RDB_RIEGL_WFM_SBL_COUNT_RESOLUTION          = 1.0
RDB_RIEGL_WFM_SBL_COUNT_MINIMUM             = 0.0
RDB_RIEGL_WFM_SBL_COUNT_MAXIMUM             = 65535.0
RDB_RIEGL_WFM_SBL_COUNT_DEFAULT             = 0.0
RDB_RIEGL_WFM_SBL_COUNT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_WFM_SBL_COUNT_NAMED_VALUES        = ""
RDB_RIEGL_WFM_SBL_COUNT_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_WFM_SBL_COUNT_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_WFM_SBL_COUNT_LOD_SETTINGS        = "default"
RDB_RIEGL_WFM_SBL_COUNT_SCALE               = 1.0

# Identifier of first waveform sample value that belongs to the sample block (0 = invalid). This is not an array index but the value of riegl.id of the sample.
RDB_RIEGL_WFM_SDA_FIRST                     = "riegl.wfm_sda_first"
RDB_RIEGL_WFM_SDA_FIRST_NAME                = "riegl.wfm_sda_first"
RDB_RIEGL_WFM_SDA_FIRST_TITLE               = "Waveform Sample Data First"
RDB_RIEGL_WFM_SDA_FIRST_GROUP               = "Primary Attributes"
RDB_RIEGL_WFM_SDA_FIRST_TAGS                = ""
RDB_RIEGL_WFM_SDA_FIRST_DESCRIPTION         = "Identifier of first waveform sample value that belongs to the sample block (0 = invalid). This is not an array index but the value of riegl.id of the sample."
RDB_RIEGL_WFM_SDA_FIRST_UNIT                = ""
RDB_RIEGL_WFM_SDA_FIRST_LENGTH              = 1
RDB_RIEGL_WFM_SDA_FIRST_RESOLUTION          = 1.0
RDB_RIEGL_WFM_SDA_FIRST_MINIMUM             = 0.0
RDB_RIEGL_WFM_SDA_FIRST_MAXIMUM             = 1.0e12
RDB_RIEGL_WFM_SDA_FIRST_DEFAULT             = 0.0
RDB_RIEGL_WFM_SDA_FIRST_INVALID             = 0.0
RDB_RIEGL_WFM_SDA_FIRST_NAMED_VALUES        = ""
RDB_RIEGL_WFM_SDA_FIRST_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_WFM_SDA_FIRST_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_WFM_SDA_FIRST_LOD_SETTINGS        = "default"
RDB_RIEGL_WFM_SDA_FIRST_SCALE               = 1.0
#
RDB_RIEGL_WFM_SDA_FIRST_INVALID = 0

# Number of waveform sample values that belong to the sample block
RDB_RIEGL_WFM_SDA_COUNT                     = "riegl.wfm_sda_count"
RDB_RIEGL_WFM_SDA_COUNT_NAME                = "riegl.wfm_sda_count"
RDB_RIEGL_WFM_SDA_COUNT_TITLE               = "Waveform Sample Data Count"
RDB_RIEGL_WFM_SDA_COUNT_GROUP               = "Primary Attributes"
RDB_RIEGL_WFM_SDA_COUNT_TAGS                = ""
RDB_RIEGL_WFM_SDA_COUNT_DESCRIPTION         = "Number of waveform sample values that belong to the sample block"
RDB_RIEGL_WFM_SDA_COUNT_UNIT                = ""
RDB_RIEGL_WFM_SDA_COUNT_LENGTH              = 1
RDB_RIEGL_WFM_SDA_COUNT_RESOLUTION          = 1.0
RDB_RIEGL_WFM_SDA_COUNT_MINIMUM             = 0.0
RDB_RIEGL_WFM_SDA_COUNT_MAXIMUM             = 65535.0
RDB_RIEGL_WFM_SDA_COUNT_DEFAULT             = 0.0
RDB_RIEGL_WFM_SDA_COUNT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_WFM_SDA_COUNT_NAMED_VALUES        = ""
RDB_RIEGL_WFM_SDA_COUNT_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_WFM_SDA_COUNT_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_WFM_SDA_COUNT_LOD_SETTINGS        = "default"
RDB_RIEGL_WFM_SDA_COUNT_SCALE               = 1.0

# Raw waveform sample value
RDB_RIEGL_WFM_SAMPLE_VALUE                     = "riegl.wfm_sample_value"
RDB_RIEGL_WFM_SAMPLE_VALUE_NAME                = "riegl.wfm_sample_value"
RDB_RIEGL_WFM_SAMPLE_VALUE_TITLE               = "Waveform Sample Value"
RDB_RIEGL_WFM_SAMPLE_VALUE_GROUP               = "Primary Attributes"
RDB_RIEGL_WFM_SAMPLE_VALUE_TAGS                = ""
RDB_RIEGL_WFM_SAMPLE_VALUE_DESCRIPTION         = "Raw waveform sample value"
RDB_RIEGL_WFM_SAMPLE_VALUE_UNIT                = ""
RDB_RIEGL_WFM_SAMPLE_VALUE_LENGTH              = 1
RDB_RIEGL_WFM_SAMPLE_VALUE_RESOLUTION          = 1.0
RDB_RIEGL_WFM_SAMPLE_VALUE_MINIMUM             = 0.0
RDB_RIEGL_WFM_SAMPLE_VALUE_MAXIMUM             = 65535.0
RDB_RIEGL_WFM_SAMPLE_VALUE_DEFAULT             = 0.0
RDB_RIEGL_WFM_SAMPLE_VALUE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_WFM_SAMPLE_VALUE_NAMED_VALUES        = ""
RDB_RIEGL_WFM_SAMPLE_VALUE_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_WFM_SAMPLE_VALUE_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_WFM_SAMPLE_VALUE_LOD_SETTINGS        = "default"
RDB_RIEGL_WFM_SAMPLE_VALUE_SCALE               = 1.0

# Zero-based index of control object type listed in riegl.control_object_catalog (meta data entry)
RDB_RIEGL_CONTROL_OBJECT_TYPE                     = "riegl.control_object_type"
RDB_RIEGL_CONTROL_OBJECT_TYPE_NAME                = "riegl.control_object_type"
RDB_RIEGL_CONTROL_OBJECT_TYPE_TITLE               = "Control Object Type"
RDB_RIEGL_CONTROL_OBJECT_TYPE_GROUP               = "Primary Attributes"
RDB_RIEGL_CONTROL_OBJECT_TYPE_TAGS                = "enumeration"
RDB_RIEGL_CONTROL_OBJECT_TYPE_DESCRIPTION         = "Zero-based index of control object type listed in riegl.control_object_catalog (meta data entry)"
RDB_RIEGL_CONTROL_OBJECT_TYPE_UNIT                = ""
RDB_RIEGL_CONTROL_OBJECT_TYPE_LENGTH              = 1
RDB_RIEGL_CONTROL_OBJECT_TYPE_RESOLUTION          = 1.0
RDB_RIEGL_CONTROL_OBJECT_TYPE_MINIMUM             = -1.0
RDB_RIEGL_CONTROL_OBJECT_TYPE_MAXIMUM             = 32767.0
RDB_RIEGL_CONTROL_OBJECT_TYPE_DEFAULT             = -1.0
RDB_RIEGL_CONTROL_OBJECT_TYPE_INVALID             = -1.0
RDB_RIEGL_CONTROL_OBJECT_TYPE_NAMED_VALUES        = ""
RDB_RIEGL_CONTROL_OBJECT_TYPE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_CONTROL_OBJECT_TYPE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_CONTROL_OBJECT_TYPE_LOD_SETTINGS        = "default"
RDB_RIEGL_CONTROL_OBJECT_TYPE_SCALE               = 1.0

# Model fit quality value between 0 and 1 (0 = unspecified)
RDB_RIEGL_MODEL_FIT_QUALITY                     = "riegl.model_fit_quality"
RDB_RIEGL_MODEL_FIT_QUALITY_NAME                = "riegl.model_fit_quality"
RDB_RIEGL_MODEL_FIT_QUALITY_TITLE               = "Model Fit Quality"
RDB_RIEGL_MODEL_FIT_QUALITY_GROUP               = "Primary Attributes"
RDB_RIEGL_MODEL_FIT_QUALITY_TAGS                = ""
RDB_RIEGL_MODEL_FIT_QUALITY_DESCRIPTION         = "Model fit quality value between 0 and 1 (0 = unspecified)"
RDB_RIEGL_MODEL_FIT_QUALITY_UNIT                = ""
RDB_RIEGL_MODEL_FIT_QUALITY_LENGTH              = 1
RDB_RIEGL_MODEL_FIT_QUALITY_RESOLUTION          = 0.001
RDB_RIEGL_MODEL_FIT_QUALITY_MINIMUM             = 0.0
RDB_RIEGL_MODEL_FIT_QUALITY_MAXIMUM             = 1.0
RDB_RIEGL_MODEL_FIT_QUALITY_DEFAULT             = 0.0
RDB_RIEGL_MODEL_FIT_QUALITY_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_MODEL_FIT_QUALITY_NAMED_VALUES        = ""
RDB_RIEGL_MODEL_FIT_QUALITY_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_MODEL_FIT_QUALITY_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_MODEL_FIT_QUALITY_LOD_SETTINGS        = "default"
RDB_RIEGL_MODEL_FIT_QUALITY_SCALE               = 1.0

# Observed inclination angle of the surface in the vicinity of a control point. It is defined as the arccosine of the vertical component of the surface normal vector. Hence: angle = 0 deg: horizontal (floor); angle = 90 deg: vertical (wall); angle = 180 deg: horizontal (ceiling)
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE                     = "riegl.cp_surface_inclination_angle"
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_NAME                = "riegl.cp_surface_inclination_angle"
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_TITLE               = "Surface Inclination Angle"
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_GROUP               = "Primary Attributes"
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_TAGS                = ""
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_DESCRIPTION         = "Observed inclination angle of the surface in the vicinity of a control point. It is defined as the arccosine of the vertical component of the surface normal vector. Hence: angle = 0 deg: horizontal (floor); angle = 90 deg: vertical (wall); angle = 180 deg: horizontal (ceiling)"
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_UNIT                = "deg"
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_LENGTH              = 1
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_RESOLUTION          = 0.01
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_MINIMUM             = 0.0
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_MAXIMUM             = 180.0
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_DEFAULT             = 0.0
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_NAMED_VALUES        = ""
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_LOD_SETTINGS        = "default"
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_SCALE               = 1.0
#
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_FLOOR = 0.0
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_WALL = 90.0
RDB_RIEGL_CP_SURFACE_INCLINATION_ANGLE_CEILING = 180.0

# Tolerance angle for the inclination of the surface in the vicinity of a control point
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE                     = "riegl.cp_surface_inclination_tolerance_angle"
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_NAME                = "riegl.cp_surface_inclination_tolerance_angle"
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_TITLE               = "Surface Inclination Tolerance Angle"
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_GROUP               = "Primary Attributes"
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_TAGS                = ""
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_DESCRIPTION         = "Tolerance angle for the inclination of the surface in the vicinity of a control point"
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_UNIT                = "deg"
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_LENGTH              = 1
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_RESOLUTION          = 0.01
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_MINIMUM             = 0.0
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_MAXIMUM             = 180.0
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_DEFAULT             = 180.0
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_NAMED_VALUES        = ""
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_LOD_SETTINGS        = "default"
RDB_RIEGL_CP_SURFACE_INCLINATION_TOLERANCE_ANGLE_SCALE               = 1.0

# Confidence value for xy position of observed point wrt. local observation coordinate system
RDB_RIEGL_OBS_CONFIDENCE_XY                     = "riegl.obs_confidence_xy"
RDB_RIEGL_OBS_CONFIDENCE_XY_NAME                = "riegl.obs_confidence_xy"
RDB_RIEGL_OBS_CONFIDENCE_XY_TITLE               = "XY confidence of observed point"
RDB_RIEGL_OBS_CONFIDENCE_XY_GROUP               = "Primary Attributes"
RDB_RIEGL_OBS_CONFIDENCE_XY_TAGS                = ""
RDB_RIEGL_OBS_CONFIDENCE_XY_DESCRIPTION         = "Confidence value for xy position of observed point wrt. local observation coordinate system"
RDB_RIEGL_OBS_CONFIDENCE_XY_UNIT                = "m"
RDB_RIEGL_OBS_CONFIDENCE_XY_LENGTH              = 1
RDB_RIEGL_OBS_CONFIDENCE_XY_RESOLUTION          = 1e-06
RDB_RIEGL_OBS_CONFIDENCE_XY_MINIMUM             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_XY_MAXIMUM             = 1000.0
RDB_RIEGL_OBS_CONFIDENCE_XY_DEFAULT             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_XY_INVALID             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_XY_NAMED_VALUES        = ""
RDB_RIEGL_OBS_CONFIDENCE_XY_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_OBS_CONFIDENCE_XY_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_OBS_CONFIDENCE_XY_LOD_SETTINGS        = "default"
RDB_RIEGL_OBS_CONFIDENCE_XY_SCALE               = 1.0

# Confidence value for z position of observed point wrt. local observation coordinate system
RDB_RIEGL_OBS_CONFIDENCE_Z                     = "riegl.obs_confidence_z"
RDB_RIEGL_OBS_CONFIDENCE_Z_NAME                = "riegl.obs_confidence_z"
RDB_RIEGL_OBS_CONFIDENCE_Z_TITLE               = "Z confidence of observed point"
RDB_RIEGL_OBS_CONFIDENCE_Z_GROUP               = "Primary Attributes"
RDB_RIEGL_OBS_CONFIDENCE_Z_TAGS                = ""
RDB_RIEGL_OBS_CONFIDENCE_Z_DESCRIPTION         = "Confidence value for z position of observed point wrt. local observation coordinate system"
RDB_RIEGL_OBS_CONFIDENCE_Z_UNIT                = "m"
RDB_RIEGL_OBS_CONFIDENCE_Z_LENGTH              = 1
RDB_RIEGL_OBS_CONFIDENCE_Z_RESOLUTION          = 1e-06
RDB_RIEGL_OBS_CONFIDENCE_Z_MINIMUM             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_Z_MAXIMUM             = 1000.0
RDB_RIEGL_OBS_CONFIDENCE_Z_DEFAULT             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_Z_INVALID             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_Z_NAMED_VALUES        = ""
RDB_RIEGL_OBS_CONFIDENCE_Z_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_OBS_CONFIDENCE_Z_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_OBS_CONFIDENCE_Z_LOD_SETTINGS        = "default"
RDB_RIEGL_OBS_CONFIDENCE_Z_SCALE               = 1.0

# Confidence of observation coordinates in local radial direction (range)
RDB_RIEGL_OBS_CONFIDENCE_RANGE                     = "riegl.obs_confidence_range"
RDB_RIEGL_OBS_CONFIDENCE_RANGE_NAME                = "riegl.obs_confidence_range"
RDB_RIEGL_OBS_CONFIDENCE_RANGE_TITLE               = "Positional confidence of observation in radial direction"
RDB_RIEGL_OBS_CONFIDENCE_RANGE_GROUP               = "Primary Attributes"
RDB_RIEGL_OBS_CONFIDENCE_RANGE_TAGS                = ""
RDB_RIEGL_OBS_CONFIDENCE_RANGE_DESCRIPTION         = "Confidence of observation coordinates in local radial direction (range)"
RDB_RIEGL_OBS_CONFIDENCE_RANGE_UNIT                = "m"
RDB_RIEGL_OBS_CONFIDENCE_RANGE_LENGTH              = 1
RDB_RIEGL_OBS_CONFIDENCE_RANGE_RESOLUTION          = 1e-06
RDB_RIEGL_OBS_CONFIDENCE_RANGE_MINIMUM             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_RANGE_MAXIMUM             = 1.0
RDB_RIEGL_OBS_CONFIDENCE_RANGE_DEFAULT             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_RANGE_INVALID             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_RANGE_NAMED_VALUES        = ""
RDB_RIEGL_OBS_CONFIDENCE_RANGE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_OBS_CONFIDENCE_RANGE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_OBS_CONFIDENCE_RANGE_LOD_SETTINGS        = "default"
RDB_RIEGL_OBS_CONFIDENCE_RANGE_SCALE               = 1.0

# Confidence of observation coordinates in local elevation direction (theta)
RDB_RIEGL_OBS_CONFIDENCE_THETA                     = "riegl.obs_confidence_theta"
RDB_RIEGL_OBS_CONFIDENCE_THETA_NAME                = "riegl.obs_confidence_theta"
RDB_RIEGL_OBS_CONFIDENCE_THETA_TITLE               = "Positional confidence of observation in theta direction"
RDB_RIEGL_OBS_CONFIDENCE_THETA_GROUP               = "Primary Attributes"
RDB_RIEGL_OBS_CONFIDENCE_THETA_TAGS                = ""
RDB_RIEGL_OBS_CONFIDENCE_THETA_DESCRIPTION         = "Confidence of observation coordinates in local elevation direction (theta)"
RDB_RIEGL_OBS_CONFIDENCE_THETA_UNIT                = "deg"
RDB_RIEGL_OBS_CONFIDENCE_THETA_LENGTH              = 1
RDB_RIEGL_OBS_CONFIDENCE_THETA_RESOLUTION          = 1e-06
RDB_RIEGL_OBS_CONFIDENCE_THETA_MINIMUM             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_THETA_MAXIMUM             = 1.0
RDB_RIEGL_OBS_CONFIDENCE_THETA_DEFAULT             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_THETA_INVALID             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_THETA_NAMED_VALUES        = ""
RDB_RIEGL_OBS_CONFIDENCE_THETA_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_OBS_CONFIDENCE_THETA_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_OBS_CONFIDENCE_THETA_LOD_SETTINGS        = "default"
RDB_RIEGL_OBS_CONFIDENCE_THETA_SCALE               = 1.0

# Confidence of observation coordinates in local azimuth direction (phi)
RDB_RIEGL_OBS_CONFIDENCE_PHI                     = "riegl.obs_confidence_phi"
RDB_RIEGL_OBS_CONFIDENCE_PHI_NAME                = "riegl.obs_confidence_phi"
RDB_RIEGL_OBS_CONFIDENCE_PHI_TITLE               = "Positional confidence of observation in phi direction"
RDB_RIEGL_OBS_CONFIDENCE_PHI_GROUP               = "Primary Attributes"
RDB_RIEGL_OBS_CONFIDENCE_PHI_TAGS                = ""
RDB_RIEGL_OBS_CONFIDENCE_PHI_DESCRIPTION         = "Confidence of observation coordinates in local azimuth direction (phi)"
RDB_RIEGL_OBS_CONFIDENCE_PHI_UNIT                = "deg"
RDB_RIEGL_OBS_CONFIDENCE_PHI_LENGTH              = 1
RDB_RIEGL_OBS_CONFIDENCE_PHI_RESOLUTION          = 1e-06
RDB_RIEGL_OBS_CONFIDENCE_PHI_MINIMUM             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_PHI_MAXIMUM             = 1.0
RDB_RIEGL_OBS_CONFIDENCE_PHI_DEFAULT             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_PHI_INVALID             = 0.0
RDB_RIEGL_OBS_CONFIDENCE_PHI_NAMED_VALUES        = ""
RDB_RIEGL_OBS_CONFIDENCE_PHI_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_OBS_CONFIDENCE_PHI_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_OBS_CONFIDENCE_PHI_LOD_SETTINGS        = "default"
RDB_RIEGL_OBS_CONFIDENCE_PHI_SCALE               = 1.0

# Confidence value for rotation angle within plane of observed signal
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT                     = "riegl.obs_signal_confidence_rot"
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_NAME                = "riegl.obs_signal_confidence_rot"
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_TITLE               = "Rotation angle confidence of observed signal"
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_GROUP               = "Primary Attributes"
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_TAGS                = ""
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_DESCRIPTION         = "Confidence value for rotation angle within plane of observed signal"
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_UNIT                = "deg"
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_LENGTH              = 1
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_RESOLUTION          = 1e-06
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_MINIMUM             = 0.0
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_MAXIMUM             = 360.0
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_DEFAULT             = 0.0
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_INVALID             = 0.0
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_NAMED_VALUES        = ""
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_LOD_SETTINGS        = "default"
RDB_RIEGL_OBS_SIGNAL_CONFIDENCE_ROT_SCALE               = 1.0

# Flag indicating if observation shall be used for adjustment (0 = used as verification point; 1 = used for adjustment)
RDB_RIEGL_USED_FOR_ADJUSTMENT                     = "riegl.used_for_adjustment"
RDB_RIEGL_USED_FOR_ADJUSTMENT_NAME                = "riegl.used_for_adjustment"
RDB_RIEGL_USED_FOR_ADJUSTMENT_TITLE               = "Used for Adjustment"
RDB_RIEGL_USED_FOR_ADJUSTMENT_GROUP               = "Primary Attributes"
RDB_RIEGL_USED_FOR_ADJUSTMENT_TAGS                = "enumeration"
RDB_RIEGL_USED_FOR_ADJUSTMENT_DESCRIPTION         = "Flag indicating if observation shall be used for adjustment (0 = used as verification point; 1 = used for adjustment)"
RDB_RIEGL_USED_FOR_ADJUSTMENT_UNIT                = ""
RDB_RIEGL_USED_FOR_ADJUSTMENT_LENGTH              = 1
RDB_RIEGL_USED_FOR_ADJUSTMENT_RESOLUTION          = 1.0
RDB_RIEGL_USED_FOR_ADJUSTMENT_MINIMUM             = 0.0
RDB_RIEGL_USED_FOR_ADJUSTMENT_MAXIMUM             = 1.0
RDB_RIEGL_USED_FOR_ADJUSTMENT_DEFAULT             = 1.0
RDB_RIEGL_USED_FOR_ADJUSTMENT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_USED_FOR_ADJUSTMENT_NAMED_VALUES        = "0=Used as verification point\n1=Used for adjustment\n"
RDB_RIEGL_USED_FOR_ADJUSTMENT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_USED_FOR_ADJUSTMENT_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_USED_FOR_ADJUSTMENT_LOD_SETTINGS        = "default"
RDB_RIEGL_USED_FOR_ADJUSTMENT_SCALE               = 1.0
#
RDB_RIEGL_USED_FOR_ADJUSTMENT_VERIFICATION = 0
RDB_RIEGL_USED_FOR_ADJUSTMENT_ADJUSTMENT = 1

# ID (riegl.id) of a referenced object (0 = invalid)
RDB_RIEGL_REFERENCE_OBJECT_ID                     = "riegl.reference_object_id"
RDB_RIEGL_REFERENCE_OBJECT_ID_NAME                = "riegl.reference_object_id"
RDB_RIEGL_REFERENCE_OBJECT_ID_TITLE               = "Reference Object ID"
RDB_RIEGL_REFERENCE_OBJECT_ID_GROUP               = "Primary Attributes"
RDB_RIEGL_REFERENCE_OBJECT_ID_TAGS                = ""
RDB_RIEGL_REFERENCE_OBJECT_ID_DESCRIPTION         = "ID (riegl.id) of a referenced object (0 = invalid)"
RDB_RIEGL_REFERENCE_OBJECT_ID_UNIT                = ""
RDB_RIEGL_REFERENCE_OBJECT_ID_LENGTH              = 1
RDB_RIEGL_REFERENCE_OBJECT_ID_RESOLUTION          = 1.0
RDB_RIEGL_REFERENCE_OBJECT_ID_MINIMUM             = 0.0
RDB_RIEGL_REFERENCE_OBJECT_ID_MAXIMUM             = 1000000000000.0
RDB_RIEGL_REFERENCE_OBJECT_ID_DEFAULT             = 0.0
RDB_RIEGL_REFERENCE_OBJECT_ID_INVALID             = 0.0
RDB_RIEGL_REFERENCE_OBJECT_ID_NAMED_VALUES        = ""
RDB_RIEGL_REFERENCE_OBJECT_ID_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_REFERENCE_OBJECT_ID_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_REFERENCE_OBJECT_ID_LOD_SETTINGS        = "default"
RDB_RIEGL_REFERENCE_OBJECT_ID_SCALE               = 1.0

# ______________________________________________________________________________
#
# POINT ATTRIBUTE GROUP "Secondary Attributes"
# ______________________________________________________________________________
#

# Raw range of echo
RDB_RIEGL_RAW_RANGE                     = "riegl.raw_range"
RDB_RIEGL_RAW_RANGE_NAME                = "riegl.raw_range"
RDB_RIEGL_RAW_RANGE_TITLE               = "Raw Range"
RDB_RIEGL_RAW_RANGE_GROUP               = "Secondary Attributes"
RDB_RIEGL_RAW_RANGE_TAGS                = ""
RDB_RIEGL_RAW_RANGE_DESCRIPTION         = "Raw range of echo"
RDB_RIEGL_RAW_RANGE_UNIT                = "m"
RDB_RIEGL_RAW_RANGE_LENGTH              = 1
RDB_RIEGL_RAW_RANGE_RESOLUTION          = 0.00025
RDB_RIEGL_RAW_RANGE_MINIMUM             = -50000.0
RDB_RIEGL_RAW_RANGE_MAXIMUM             = 50000.0
RDB_RIEGL_RAW_RANGE_DEFAULT             = 0.0
RDB_RIEGL_RAW_RANGE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_RAW_RANGE_NAMED_VALUES        = ""
RDB_RIEGL_RAW_RANGE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_RAW_RANGE_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_RAW_RANGE_LOD_SETTINGS        = "default"
RDB_RIEGL_RAW_RANGE_SCALE               = 1.0

# Raw line angle
RDB_RIEGL_RAW_LINE_ANGLE                     = "riegl.raw_line_angle"
RDB_RIEGL_RAW_LINE_ANGLE_NAME                = "riegl.raw_line_angle"
RDB_RIEGL_RAW_LINE_ANGLE_TITLE               = "Raw line angle"
RDB_RIEGL_RAW_LINE_ANGLE_GROUP               = "Secondary Attributes"
RDB_RIEGL_RAW_LINE_ANGLE_TAGS                = ""
RDB_RIEGL_RAW_LINE_ANGLE_DESCRIPTION         = "Raw line angle"
RDB_RIEGL_RAW_LINE_ANGLE_UNIT                = "deg"
RDB_RIEGL_RAW_LINE_ANGLE_LENGTH              = 1
RDB_RIEGL_RAW_LINE_ANGLE_RESOLUTION          = 1e-6
RDB_RIEGL_RAW_LINE_ANGLE_MINIMUM             = 0.0
RDB_RIEGL_RAW_LINE_ANGLE_MAXIMUM             = 360.0
RDB_RIEGL_RAW_LINE_ANGLE_DEFAULT             = 0.0
RDB_RIEGL_RAW_LINE_ANGLE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_RAW_LINE_ANGLE_NAMED_VALUES        = ""
RDB_RIEGL_RAW_LINE_ANGLE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_RAW_LINE_ANGLE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_RAW_LINE_ANGLE_LOD_SETTINGS        = "default"
RDB_RIEGL_RAW_LINE_ANGLE_SCALE               = 1.0

# Raw frame angle
RDB_RIEGL_RAW_FRAME_ANGLE                     = "riegl.raw_frame_angle"
RDB_RIEGL_RAW_FRAME_ANGLE_NAME                = "riegl.raw_frame_angle"
RDB_RIEGL_RAW_FRAME_ANGLE_TITLE               = "Raw frame angle"
RDB_RIEGL_RAW_FRAME_ANGLE_GROUP               = "Secondary Attributes"
RDB_RIEGL_RAW_FRAME_ANGLE_TAGS                = ""
RDB_RIEGL_RAW_FRAME_ANGLE_DESCRIPTION         = "Raw frame angle"
RDB_RIEGL_RAW_FRAME_ANGLE_UNIT                = "deg"
RDB_RIEGL_RAW_FRAME_ANGLE_LENGTH              = 1
RDB_RIEGL_RAW_FRAME_ANGLE_RESOLUTION          = 1e-6
RDB_RIEGL_RAW_FRAME_ANGLE_MINIMUM             = 0.0
RDB_RIEGL_RAW_FRAME_ANGLE_MAXIMUM             = 360.0
RDB_RIEGL_RAW_FRAME_ANGLE_DEFAULT             = 0.0
RDB_RIEGL_RAW_FRAME_ANGLE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_RAW_FRAME_ANGLE_NAMED_VALUES        = ""
RDB_RIEGL_RAW_FRAME_ANGLE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_RAW_FRAME_ANGLE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_RAW_FRAME_ANGLE_LOD_SETTINGS        = "default"
RDB_RIEGL_RAW_FRAME_ANGLE_SCALE               = 1.0

# Coarse line scan angle
RDB_RIEGL_LINE_ANGLE_COARSE                     = "riegl.line_angle_coarse"
RDB_RIEGL_LINE_ANGLE_COARSE_NAME                = "riegl.line_angle_coarse"
RDB_RIEGL_LINE_ANGLE_COARSE_TITLE               = "Line Angle Coarse"
RDB_RIEGL_LINE_ANGLE_COARSE_GROUP               = "Secondary Attributes"
RDB_RIEGL_LINE_ANGLE_COARSE_TAGS                = ""
RDB_RIEGL_LINE_ANGLE_COARSE_DESCRIPTION         = "Coarse line scan angle"
RDB_RIEGL_LINE_ANGLE_COARSE_UNIT                = "deg"
RDB_RIEGL_LINE_ANGLE_COARSE_LENGTH              = 1
RDB_RIEGL_LINE_ANGLE_COARSE_RESOLUTION          = 0.025
RDB_RIEGL_LINE_ANGLE_COARSE_MINIMUM             = 0.0
RDB_RIEGL_LINE_ANGLE_COARSE_MAXIMUM             = 360.0
RDB_RIEGL_LINE_ANGLE_COARSE_DEFAULT             = 0.0
RDB_RIEGL_LINE_ANGLE_COARSE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_LINE_ANGLE_COARSE_NAMED_VALUES        = ""
RDB_RIEGL_LINE_ANGLE_COARSE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_LINE_ANGLE_COARSE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_LINE_ANGLE_COARSE_LOD_SETTINGS        = "default"
RDB_RIEGL_LINE_ANGLE_COARSE_SCALE               = 1.0

# Reduced line scan angle
RDB_RIEGL_LINE_ANGLE_REDUCED                     = "riegl.line_angle_reduced"
RDB_RIEGL_LINE_ANGLE_REDUCED_NAME                = "riegl.line_angle_reduced"
RDB_RIEGL_LINE_ANGLE_REDUCED_TITLE               = "Line Angle Reduced"
RDB_RIEGL_LINE_ANGLE_REDUCED_GROUP               = "Secondary Attributes"
RDB_RIEGL_LINE_ANGLE_REDUCED_TAGS                = ""
RDB_RIEGL_LINE_ANGLE_REDUCED_DESCRIPTION         = "Reduced line scan angle"
RDB_RIEGL_LINE_ANGLE_REDUCED_UNIT                = "deg"
RDB_RIEGL_LINE_ANGLE_REDUCED_LENGTH              = 1
RDB_RIEGL_LINE_ANGLE_REDUCED_RESOLUTION          = 0.025
RDB_RIEGL_LINE_ANGLE_REDUCED_MINIMUM             = -360.0
RDB_RIEGL_LINE_ANGLE_REDUCED_MAXIMUM             = 360.0
RDB_RIEGL_LINE_ANGLE_REDUCED_DEFAULT             = 0.0
RDB_RIEGL_LINE_ANGLE_REDUCED_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_LINE_ANGLE_REDUCED_NAMED_VALUES        = ""
RDB_RIEGL_LINE_ANGLE_REDUCED_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_LINE_ANGLE_REDUCED_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_LINE_ANGLE_REDUCED_LOD_SETTINGS        = "default"
RDB_RIEGL_LINE_ANGLE_REDUCED_SCALE               = 1.0

# Coarse frame scan angle
RDB_RIEGL_FRAME_ANGLE_COARSE                     = "riegl.frame_angle_coarse"
RDB_RIEGL_FRAME_ANGLE_COARSE_NAME                = "riegl.frame_angle_coarse"
RDB_RIEGL_FRAME_ANGLE_COARSE_TITLE               = "Frame Angle Coarse"
RDB_RIEGL_FRAME_ANGLE_COARSE_GROUP               = "Secondary Attributes"
RDB_RIEGL_FRAME_ANGLE_COARSE_TAGS                = ""
RDB_RIEGL_FRAME_ANGLE_COARSE_DESCRIPTION         = "Coarse frame scan angle"
RDB_RIEGL_FRAME_ANGLE_COARSE_UNIT                = "deg"
RDB_RIEGL_FRAME_ANGLE_COARSE_LENGTH              = 1
RDB_RIEGL_FRAME_ANGLE_COARSE_RESOLUTION          = 0.001
RDB_RIEGL_FRAME_ANGLE_COARSE_MINIMUM             = 0.0
RDB_RIEGL_FRAME_ANGLE_COARSE_MAXIMUM             = 360.0
RDB_RIEGL_FRAME_ANGLE_COARSE_DEFAULT             = 0.0
RDB_RIEGL_FRAME_ANGLE_COARSE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_FRAME_ANGLE_COARSE_NAMED_VALUES        = ""
RDB_RIEGL_FRAME_ANGLE_COARSE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_FRAME_ANGLE_COARSE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_FRAME_ANGLE_COARSE_LOD_SETTINGS        = "default"
RDB_RIEGL_FRAME_ANGLE_COARSE_SCALE               = 1.0

# Scan Line Index in Scan
RDB_RIEGL_SCAN_LINE_INDEX                     = "riegl.scan_line_index"
RDB_RIEGL_SCAN_LINE_INDEX_NAME                = "riegl.scan_line_index"
RDB_RIEGL_SCAN_LINE_INDEX_TITLE               = "Scan Line Index"
RDB_RIEGL_SCAN_LINE_INDEX_GROUP               = "Secondary Attributes"
RDB_RIEGL_SCAN_LINE_INDEX_TAGS                = ""
RDB_RIEGL_SCAN_LINE_INDEX_DESCRIPTION         = "Scan Line Index in Scan"
RDB_RIEGL_SCAN_LINE_INDEX_UNIT                = ""
RDB_RIEGL_SCAN_LINE_INDEX_LENGTH              = 1
RDB_RIEGL_SCAN_LINE_INDEX_RESOLUTION          = 1.0
RDB_RIEGL_SCAN_LINE_INDEX_MINIMUM             = -2000000000.0
RDB_RIEGL_SCAN_LINE_INDEX_MAXIMUM             = 2000000000.0
RDB_RIEGL_SCAN_LINE_INDEX_DEFAULT             = 0.0
RDB_RIEGL_SCAN_LINE_INDEX_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SCAN_LINE_INDEX_NAMED_VALUES        = ""
RDB_RIEGL_SCAN_LINE_INDEX_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SCAN_LINE_INDEX_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_SCAN_LINE_INDEX_LOD_SETTINGS        = "default"
RDB_RIEGL_SCAN_LINE_INDEX_SCALE               = 1.0

# Laser Shot Index in Scan Line
RDB_RIEGL_SHOT_INDEX_LINE                     = "riegl.shot_index_line"
RDB_RIEGL_SHOT_INDEX_LINE_NAME                = "riegl.shot_index_line"
RDB_RIEGL_SHOT_INDEX_LINE_TITLE               = "Laser Shot Index in Line"
RDB_RIEGL_SHOT_INDEX_LINE_GROUP               = "Secondary Attributes"
RDB_RIEGL_SHOT_INDEX_LINE_TAGS                = ""
RDB_RIEGL_SHOT_INDEX_LINE_DESCRIPTION         = "Laser Shot Index in Scan Line"
RDB_RIEGL_SHOT_INDEX_LINE_UNIT                = ""
RDB_RIEGL_SHOT_INDEX_LINE_LENGTH              = 1
RDB_RIEGL_SHOT_INDEX_LINE_RESOLUTION          = 1.0
RDB_RIEGL_SHOT_INDEX_LINE_MINIMUM             = -2000000000.0
RDB_RIEGL_SHOT_INDEX_LINE_MAXIMUM             = 2000000000.0
RDB_RIEGL_SHOT_INDEX_LINE_DEFAULT             = 0.0
RDB_RIEGL_SHOT_INDEX_LINE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SHOT_INDEX_LINE_NAMED_VALUES        = ""
RDB_RIEGL_SHOT_INDEX_LINE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SHOT_INDEX_LINE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_SHOT_INDEX_LINE_LOD_SETTINGS        = "default"
RDB_RIEGL_SHOT_INDEX_LINE_SCALE               = 1.0

# Mirror facet number (0 = invalid, 1 = first facet, ...)
RDB_RIEGL_MIRROR_FACET                     = "riegl.mirror_facet"
RDB_RIEGL_MIRROR_FACET_NAME                = "riegl.mirror_facet"
RDB_RIEGL_MIRROR_FACET_TITLE               = "Mirror Facet"
RDB_RIEGL_MIRROR_FACET_GROUP               = "Secondary Attributes"
RDB_RIEGL_MIRROR_FACET_TAGS                = "enumeration"
RDB_RIEGL_MIRROR_FACET_DESCRIPTION         = "Mirror facet number (0 = invalid, 1 = first facet, ...)"
RDB_RIEGL_MIRROR_FACET_UNIT                = ""
RDB_RIEGL_MIRROR_FACET_LENGTH              = 1
RDB_RIEGL_MIRROR_FACET_RESOLUTION          = 1.0
RDB_RIEGL_MIRROR_FACET_MINIMUM             = 0.0
RDB_RIEGL_MIRROR_FACET_MAXIMUM             = 15.0
RDB_RIEGL_MIRROR_FACET_DEFAULT             = 0.0
RDB_RIEGL_MIRROR_FACET_INVALID             = 0.0
RDB_RIEGL_MIRROR_FACET_NAMED_VALUES        = ""
RDB_RIEGL_MIRROR_FACET_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_MIRROR_FACET_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_MIRROR_FACET_LOD_SETTINGS        = "default"
RDB_RIEGL_MIRROR_FACET_SCALE               = 1.0
#
RDB_RIEGL_MIRROR_FACET_INVALID = 0

# Scan segment number (0 = invalid, 1 = first segment, ...)
RDB_RIEGL_SCAN_SEGMENT                     = "riegl.scan_segment"
RDB_RIEGL_SCAN_SEGMENT_NAME                = "riegl.scan_segment"
RDB_RIEGL_SCAN_SEGMENT_TITLE               = "Scan Segment"
RDB_RIEGL_SCAN_SEGMENT_GROUP               = "Secondary Attributes"
RDB_RIEGL_SCAN_SEGMENT_TAGS                = "enumeration"
RDB_RIEGL_SCAN_SEGMENT_DESCRIPTION         = "Scan segment number (0 = invalid, 1 = first segment, ...)"
RDB_RIEGL_SCAN_SEGMENT_UNIT                = ""
RDB_RIEGL_SCAN_SEGMENT_LENGTH              = 1
RDB_RIEGL_SCAN_SEGMENT_RESOLUTION          = 1.0
RDB_RIEGL_SCAN_SEGMENT_MINIMUM             = 0.0
RDB_RIEGL_SCAN_SEGMENT_MAXIMUM             = 15.0
RDB_RIEGL_SCAN_SEGMENT_DEFAULT             = 0.0
RDB_RIEGL_SCAN_SEGMENT_INVALID             = 0.0
RDB_RIEGL_SCAN_SEGMENT_NAMED_VALUES        = ""
RDB_RIEGL_SCAN_SEGMENT_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_SCAN_SEGMENT_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_SCAN_SEGMENT_LOD_SETTINGS        = "default"
RDB_RIEGL_SCAN_SEGMENT_SCALE               = 1.0
#
RDB_RIEGL_SCAN_SEGMENT_INVALID = 0

# Waveform data available for laser-shot (0 = no, 1 = yes)
RDB_RIEGL_WAVEFORM_AVAILABLE                     = "riegl.waveform_available"
RDB_RIEGL_WAVEFORM_AVAILABLE_NAME                = "riegl.waveform_available"
RDB_RIEGL_WAVEFORM_AVAILABLE_TITLE               = "Waveform Available"
RDB_RIEGL_WAVEFORM_AVAILABLE_GROUP               = "Secondary Attributes"
RDB_RIEGL_WAVEFORM_AVAILABLE_TAGS                = "boolean"
RDB_RIEGL_WAVEFORM_AVAILABLE_DESCRIPTION         = "Waveform data available for laser-shot (0 = no, 1 = yes)"
RDB_RIEGL_WAVEFORM_AVAILABLE_UNIT                = ""
RDB_RIEGL_WAVEFORM_AVAILABLE_LENGTH              = 1
RDB_RIEGL_WAVEFORM_AVAILABLE_RESOLUTION          = 1.0
RDB_RIEGL_WAVEFORM_AVAILABLE_MINIMUM             = 0.0
RDB_RIEGL_WAVEFORM_AVAILABLE_MAXIMUM             = 1.0
RDB_RIEGL_WAVEFORM_AVAILABLE_DEFAULT             = 0.0
RDB_RIEGL_WAVEFORM_AVAILABLE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_WAVEFORM_AVAILABLE_NAMED_VALUES        = "0=No waveform available\n1=Waveform available\n"
RDB_RIEGL_WAVEFORM_AVAILABLE_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_WAVEFORM_AVAILABLE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_WAVEFORM_AVAILABLE_LOD_SETTINGS        = "default"
RDB_RIEGL_WAVEFORM_AVAILABLE_SCALE               = 1.0
#
RDB_RIEGL_WAVEFORM_AVAILABLE_FALSE = 0
RDB_RIEGL_WAVEFORM_AVAILABLE_TRUE = 1

# 1 if the point was refraction corrected, 0 otherwise
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED                     = "riegl.hydro_refraction_corrected"
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_NAME                = "riegl.hydro_refraction_corrected"
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_TITLE               = "Refraction-corrected"
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_GROUP               = "Secondary Attributes"
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_TAGS                = "boolean"
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_DESCRIPTION         = "1 if the point was refraction corrected, 0 otherwise"
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_UNIT                = ""
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_LENGTH              = 1
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_RESOLUTION          = 1.0
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_MINIMUM             = 0.0
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_MAXIMUM             = 1.0
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_DEFAULT             = 0.0
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_NAMED_VALUES        = "0=No refraction correction applied\n1=Refraction correction applied\n"
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_LOD_SETTINGS        = "default"
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_SCALE               = 1.0
#
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_FALSE = 0
RDB_RIEGL_HYDRO_REFRACTION_CORRECTED_TRUE = 1

# Extinction coefficient, i.e. exponential damping coefficient usually present in water bodies. N.B.: The factor is subject to refraction correction.
RDB_RIEGL_EXTINCTION                     = "riegl.extinction"
RDB_RIEGL_EXTINCTION_NAME                = "riegl.extinction"
RDB_RIEGL_EXTINCTION_TITLE               = "Extinction Coefficient"
RDB_RIEGL_EXTINCTION_GROUP               = "Secondary Attributes"
RDB_RIEGL_EXTINCTION_TAGS                = ""
RDB_RIEGL_EXTINCTION_DESCRIPTION         = "Extinction coefficient, i.e. exponential damping coefficient usually present in water bodies. N.B.: The factor is subject to refraction correction."
RDB_RIEGL_EXTINCTION_UNIT                = "dB/m"
RDB_RIEGL_EXTINCTION_LENGTH              = 1
RDB_RIEGL_EXTINCTION_RESOLUTION          = 0.001
RDB_RIEGL_EXTINCTION_MINIMUM             = -30.0
RDB_RIEGL_EXTINCTION_MAXIMUM             = 30.0
RDB_RIEGL_EXTINCTION_DEFAULT             = 0.0
RDB_RIEGL_EXTINCTION_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_EXTINCTION_NAMED_VALUES        = ""
RDB_RIEGL_EXTINCTION_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_EXTINCTION_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_EXTINCTION_LOD_SETTINGS        = "default"
RDB_RIEGL_EXTINCTION_SCALE               = 1.0

# Amplitude from volumetric backscatter in SVB FWA
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC                     = "riegl.svb_amplitude_volumetric"
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_NAME                = "riegl.svb_amplitude_volumetric"
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_TITLE               = "SVB Volumetric Backscatter Amplitude"
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_GROUP               = "Secondary Attributes"
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_TAGS                = ""
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_DESCRIPTION         = "Amplitude from volumetric backscatter in SVB FWA"
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_UNIT                = "dB"
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_LENGTH              = 1
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_RESOLUTION          = 0.01
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_MINIMUM             = -327.68
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_MAXIMUM             = 327.67
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_DEFAULT             = 0.0
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_NAMED_VALUES        = ""
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_LOD_SETTINGS        = "default"
RDB_RIEGL_SVB_AMPLITUDE_VOLUMETRIC_SCALE               = 1.0

# Indicates surface point from SVB FWA (1 = surface)
RDB_RIEGL_SVB_SURFACE                     = "riegl.svb_surface"
RDB_RIEGL_SVB_SURFACE_NAME                = "riegl.svb_surface"
RDB_RIEGL_SVB_SURFACE_TITLE               = "SVB Surface Point"
RDB_RIEGL_SVB_SURFACE_GROUP               = "Secondary Attributes"
RDB_RIEGL_SVB_SURFACE_TAGS                = "boolean"
RDB_RIEGL_SVB_SURFACE_DESCRIPTION         = "Indicates surface point from SVB FWA (1 = surface)"
RDB_RIEGL_SVB_SURFACE_UNIT                = ""
RDB_RIEGL_SVB_SURFACE_LENGTH              = 1
RDB_RIEGL_SVB_SURFACE_RESOLUTION          = 1.0
RDB_RIEGL_SVB_SURFACE_MINIMUM             = 0.0
RDB_RIEGL_SVB_SURFACE_MAXIMUM             = 1.0
RDB_RIEGL_SVB_SURFACE_DEFAULT             = 0.0
RDB_RIEGL_SVB_SURFACE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SVB_SURFACE_NAMED_VALUES        = ""
RDB_RIEGL_SVB_SURFACE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SVB_SURFACE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_SVB_SURFACE_LOD_SETTINGS        = "default"
RDB_RIEGL_SVB_SURFACE_SCALE               = 1.0
#
RDB_RIEGL_SVB_SURFACE_FALSE = 0
RDB_RIEGL_SVB_SURFACE_TRUE = 1

# Indicates bottom point from SVB FWA (1 = bottom)
RDB_RIEGL_SVB_BOTTOM                     = "riegl.svb_bottom"
RDB_RIEGL_SVB_BOTTOM_NAME                = "riegl.svb_bottom"
RDB_RIEGL_SVB_BOTTOM_TITLE               = "SVB Bottom Point"
RDB_RIEGL_SVB_BOTTOM_GROUP               = "Secondary Attributes"
RDB_RIEGL_SVB_BOTTOM_TAGS                = "boolean"
RDB_RIEGL_SVB_BOTTOM_DESCRIPTION         = "Indicates bottom point from SVB FWA (1 = bottom)"
RDB_RIEGL_SVB_BOTTOM_UNIT                = ""
RDB_RIEGL_SVB_BOTTOM_LENGTH              = 1
RDB_RIEGL_SVB_BOTTOM_RESOLUTION          = 1.0
RDB_RIEGL_SVB_BOTTOM_MINIMUM             = 0.0
RDB_RIEGL_SVB_BOTTOM_MAXIMUM             = 1.0
RDB_RIEGL_SVB_BOTTOM_DEFAULT             = 0.0
RDB_RIEGL_SVB_BOTTOM_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SVB_BOTTOM_NAMED_VALUES        = ""
RDB_RIEGL_SVB_BOTTOM_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SVB_BOTTOM_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_SVB_BOTTOM_LOD_SETTINGS        = "default"
RDB_RIEGL_SVB_BOTTOM_SCALE               = 1.0
#
RDB_RIEGL_SVB_BOTTOM_FALSE = 0
RDB_RIEGL_SVB_BOTTOM_TRUE = 1

# Path length between surface and bottom from SVB FWA
RDB_RIEGL_SVB_PATH_LENGTH                     = "riegl.svb_path_length"
RDB_RIEGL_SVB_PATH_LENGTH_NAME                = "riegl.svb_path_length"
RDB_RIEGL_SVB_PATH_LENGTH_TITLE               = "SVB Path Length"
RDB_RIEGL_SVB_PATH_LENGTH_GROUP               = "Secondary Attributes"
RDB_RIEGL_SVB_PATH_LENGTH_TAGS                = ""
RDB_RIEGL_SVB_PATH_LENGTH_DESCRIPTION         = "Path length between surface and bottom from SVB FWA"
RDB_RIEGL_SVB_PATH_LENGTH_UNIT                = "m"
RDB_RIEGL_SVB_PATH_LENGTH_LENGTH              = 1
RDB_RIEGL_SVB_PATH_LENGTH_RESOLUTION          = 0.004
RDB_RIEGL_SVB_PATH_LENGTH_MINIMUM             = 0.0
RDB_RIEGL_SVB_PATH_LENGTH_MAXIMUM             = 200.0
RDB_RIEGL_SVB_PATH_LENGTH_DEFAULT             = 0.0
RDB_RIEGL_SVB_PATH_LENGTH_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SVB_PATH_LENGTH_NAMED_VALUES        = ""
RDB_RIEGL_SVB_PATH_LENGTH_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SVB_PATH_LENGTH_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_SVB_PATH_LENGTH_LOD_SETTINGS        = "default"
RDB_RIEGL_SVB_PATH_LENGTH_SCALE               = 1.0

# 1 for all points of the first laser shot of a scan line, 0 otherwise
RDB_RIEGL_START_OF_SCAN_LINE                     = "riegl.start_of_scan_line"
RDB_RIEGL_START_OF_SCAN_LINE_NAME                = "riegl.start_of_scan_line"
RDB_RIEGL_START_OF_SCAN_LINE_TITLE               = "Start of Scan Line"
RDB_RIEGL_START_OF_SCAN_LINE_GROUP               = "Secondary Attributes"
RDB_RIEGL_START_OF_SCAN_LINE_TAGS                = "boolean"
RDB_RIEGL_START_OF_SCAN_LINE_DESCRIPTION         = "1 for all points of the first laser shot of a scan line, 0 otherwise"
RDB_RIEGL_START_OF_SCAN_LINE_UNIT                = ""
RDB_RIEGL_START_OF_SCAN_LINE_LENGTH              = 1
RDB_RIEGL_START_OF_SCAN_LINE_RESOLUTION          = 1.0
RDB_RIEGL_START_OF_SCAN_LINE_MINIMUM             = 0.0
RDB_RIEGL_START_OF_SCAN_LINE_MAXIMUM             = 1.0
RDB_RIEGL_START_OF_SCAN_LINE_DEFAULT             = 0.0
RDB_RIEGL_START_OF_SCAN_LINE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_START_OF_SCAN_LINE_NAMED_VALUES        = ""
RDB_RIEGL_START_OF_SCAN_LINE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_START_OF_SCAN_LINE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_START_OF_SCAN_LINE_LOD_SETTINGS        = "default"
RDB_RIEGL_START_OF_SCAN_LINE_SCALE               = 1.0
#
RDB_RIEGL_START_OF_SCAN_LINE_FALSE = 0
RDB_RIEGL_START_OF_SCAN_LINE_TRUE = 1

# 1 for all points of the last laser shot of a scan line, 0 otherwise
RDB_RIEGL_END_OF_SCAN_LINE                     = "riegl.end_of_scan_line"
RDB_RIEGL_END_OF_SCAN_LINE_NAME                = "riegl.end_of_scan_line"
RDB_RIEGL_END_OF_SCAN_LINE_TITLE               = "End of Scan Line"
RDB_RIEGL_END_OF_SCAN_LINE_GROUP               = "Secondary Attributes"
RDB_RIEGL_END_OF_SCAN_LINE_TAGS                = "boolean"
RDB_RIEGL_END_OF_SCAN_LINE_DESCRIPTION         = "1 for all points of the last laser shot of a scan line, 0 otherwise"
RDB_RIEGL_END_OF_SCAN_LINE_UNIT                = ""
RDB_RIEGL_END_OF_SCAN_LINE_LENGTH              = 1
RDB_RIEGL_END_OF_SCAN_LINE_RESOLUTION          = 1.0
RDB_RIEGL_END_OF_SCAN_LINE_MINIMUM             = 0.0
RDB_RIEGL_END_OF_SCAN_LINE_MAXIMUM             = 1.0
RDB_RIEGL_END_OF_SCAN_LINE_DEFAULT             = 0.0
RDB_RIEGL_END_OF_SCAN_LINE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_END_OF_SCAN_LINE_NAMED_VALUES        = ""
RDB_RIEGL_END_OF_SCAN_LINE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_END_OF_SCAN_LINE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_END_OF_SCAN_LINE_LOD_SETTINGS        = "default"
RDB_RIEGL_END_OF_SCAN_LINE_SCALE               = 1.0
#
RDB_RIEGL_END_OF_SCAN_LINE_FALSE = 0
RDB_RIEGL_END_OF_SCAN_LINE_TRUE = 1

# see LAS format specification 1.4-R13
RDB_RIEGL_SCAN_ANGLE                     = "riegl.scan_angle"
RDB_RIEGL_SCAN_ANGLE_NAME                = "riegl.scan_angle"
RDB_RIEGL_SCAN_ANGLE_TITLE               = "Scan Angle"
RDB_RIEGL_SCAN_ANGLE_GROUP               = "Secondary Attributes"
RDB_RIEGL_SCAN_ANGLE_TAGS                = ""
RDB_RIEGL_SCAN_ANGLE_DESCRIPTION         = "see LAS format specification 1.4-R13"
RDB_RIEGL_SCAN_ANGLE_UNIT                = "deg"
RDB_RIEGL_SCAN_ANGLE_LENGTH              = 1
RDB_RIEGL_SCAN_ANGLE_RESOLUTION          = 0.096
RDB_RIEGL_SCAN_ANGLE_MINIMUM             = -180.0
RDB_RIEGL_SCAN_ANGLE_MAXIMUM             = 180.0
RDB_RIEGL_SCAN_ANGLE_DEFAULT             = 0.0
RDB_RIEGL_SCAN_ANGLE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SCAN_ANGLE_NAMED_VALUES        = ""
RDB_RIEGL_SCAN_ANGLE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SCAN_ANGLE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_SCAN_ANGLE_LOD_SETTINGS        = "default"
RDB_RIEGL_SCAN_ANGLE_SCALE               = 1.0

# see LAS format specification 1.4-R13
RDB_RIEGL_SCAN_DIRECTION                     = "riegl.scan_direction"
RDB_RIEGL_SCAN_DIRECTION_NAME                = "riegl.scan_direction"
RDB_RIEGL_SCAN_DIRECTION_TITLE               = "Scan Direction"
RDB_RIEGL_SCAN_DIRECTION_GROUP               = "Secondary Attributes"
RDB_RIEGL_SCAN_DIRECTION_TAGS                = "enumeration"
RDB_RIEGL_SCAN_DIRECTION_DESCRIPTION         = "see LAS format specification 1.4-R13"
RDB_RIEGL_SCAN_DIRECTION_UNIT                = ""
RDB_RIEGL_SCAN_DIRECTION_LENGTH              = 1
RDB_RIEGL_SCAN_DIRECTION_RESOLUTION          = 1.0
RDB_RIEGL_SCAN_DIRECTION_MINIMUM             = 0.0
RDB_RIEGL_SCAN_DIRECTION_MAXIMUM             = 1.0
RDB_RIEGL_SCAN_DIRECTION_DEFAULT             = 0.0
RDB_RIEGL_SCAN_DIRECTION_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SCAN_DIRECTION_NAMED_VALUES        = "0=Negative\n1=Positive\n"
RDB_RIEGL_SCAN_DIRECTION_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SCAN_DIRECTION_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_SCAN_DIRECTION_LOD_SETTINGS        = "default"
RDB_RIEGL_SCAN_DIRECTION_SCALE               = 1.0

# Voxel has been collapsed with neighbor (0 = not collapsed, 1 = collapsed)
RDB_RIEGL_VOXEL_COLLAPSED                     = "riegl.voxel_collapsed"
RDB_RIEGL_VOXEL_COLLAPSED_NAME                = "riegl.voxel_collapsed"
RDB_RIEGL_VOXEL_COLLAPSED_TITLE               = "Voxel Collapsed with Neighbor"
RDB_RIEGL_VOXEL_COLLAPSED_GROUP               = "Secondary Attributes"
RDB_RIEGL_VOXEL_COLLAPSED_TAGS                = "boolean"
RDB_RIEGL_VOXEL_COLLAPSED_DESCRIPTION         = "Voxel has been collapsed with neighbor (0 = not collapsed, 1 = collapsed)"
RDB_RIEGL_VOXEL_COLLAPSED_UNIT                = ""
RDB_RIEGL_VOXEL_COLLAPSED_LENGTH              = 1
RDB_RIEGL_VOXEL_COLLAPSED_RESOLUTION          = 1.0
RDB_RIEGL_VOXEL_COLLAPSED_MINIMUM             = 0.0
RDB_RIEGL_VOXEL_COLLAPSED_MAXIMUM             = 1.0
RDB_RIEGL_VOXEL_COLLAPSED_DEFAULT             = 0.0
RDB_RIEGL_VOXEL_COLLAPSED_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_VOXEL_COLLAPSED_NAMED_VALUES        = ""
RDB_RIEGL_VOXEL_COLLAPSED_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_VOXEL_COLLAPSED_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_VOXEL_COLLAPSED_LOD_SETTINGS        = "default"
RDB_RIEGL_VOXEL_COLLAPSED_SCALE               = 1.0
#
RDB_RIEGL_VOXEL_COLLAPSED_FALSE = 0
RDB_RIEGL_VOXEL_COLLAPSED_TRUE = 1

# 1 if the mirror wheel rotates, 0 otherwise
RDB_RIEGL_LINE_SCAN_ACTIVE                     = "riegl.line_scan_active"
RDB_RIEGL_LINE_SCAN_ACTIVE_NAME                = "riegl.line_scan_active"
RDB_RIEGL_LINE_SCAN_ACTIVE_TITLE               = "Line Scan Active"
RDB_RIEGL_LINE_SCAN_ACTIVE_GROUP               = "Secondary Attributes"
RDB_RIEGL_LINE_SCAN_ACTIVE_TAGS                = ""
RDB_RIEGL_LINE_SCAN_ACTIVE_DESCRIPTION         = "1 if the mirror wheel rotates, 0 otherwise"
RDB_RIEGL_LINE_SCAN_ACTIVE_UNIT                = ""
RDB_RIEGL_LINE_SCAN_ACTIVE_LENGTH              = 1
RDB_RIEGL_LINE_SCAN_ACTIVE_RESOLUTION          = 1.0
RDB_RIEGL_LINE_SCAN_ACTIVE_MINIMUM             = -1.0
RDB_RIEGL_LINE_SCAN_ACTIVE_MAXIMUM             = 1.0
RDB_RIEGL_LINE_SCAN_ACTIVE_DEFAULT             = -1.0
RDB_RIEGL_LINE_SCAN_ACTIVE_INVALID             = -1.0
RDB_RIEGL_LINE_SCAN_ACTIVE_NAMED_VALUES        = ""
RDB_RIEGL_LINE_SCAN_ACTIVE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_LINE_SCAN_ACTIVE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_LINE_SCAN_ACTIVE_LOD_SETTINGS        = "default"
RDB_RIEGL_LINE_SCAN_ACTIVE_SCALE               = 1.0
#
RDB_RIEGL_LINE_SCAN_ACTIVE_FALSE = 0
RDB_RIEGL_LINE_SCAN_ACTIVE_TRUE = 1

# 1 if the scanner head rotates, 0 otherwise
RDB_RIEGL_FRAME_SCAN_ACTIVE                     = "riegl.frame_scan_active"
RDB_RIEGL_FRAME_SCAN_ACTIVE_NAME                = "riegl.frame_scan_active"
RDB_RIEGL_FRAME_SCAN_ACTIVE_TITLE               = "Frame Scan Active"
RDB_RIEGL_FRAME_SCAN_ACTIVE_GROUP               = "Secondary Attributes"
RDB_RIEGL_FRAME_SCAN_ACTIVE_TAGS                = ""
RDB_RIEGL_FRAME_SCAN_ACTIVE_DESCRIPTION         = "1 if the scanner head rotates, 0 otherwise"
RDB_RIEGL_FRAME_SCAN_ACTIVE_UNIT                = ""
RDB_RIEGL_FRAME_SCAN_ACTIVE_LENGTH              = 1
RDB_RIEGL_FRAME_SCAN_ACTIVE_RESOLUTION          = 1.0
RDB_RIEGL_FRAME_SCAN_ACTIVE_MINIMUM             = -1.0
RDB_RIEGL_FRAME_SCAN_ACTIVE_MAXIMUM             = 1.0
RDB_RIEGL_FRAME_SCAN_ACTIVE_DEFAULT             = -1.0
RDB_RIEGL_FRAME_SCAN_ACTIVE_INVALID             = -1.0
RDB_RIEGL_FRAME_SCAN_ACTIVE_NAMED_VALUES        = ""
RDB_RIEGL_FRAME_SCAN_ACTIVE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_FRAME_SCAN_ACTIVE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_FRAME_SCAN_ACTIVE_LOD_SETTINGS        = "default"
RDB_RIEGL_FRAME_SCAN_ACTIVE_SCALE               = 1.0
#
RDB_RIEGL_FRAME_SCAN_ACTIVE_FALSE = 0
RDB_RIEGL_FRAME_SCAN_ACTIVE_TRUE = 1

# 1 if the data acquisition is in progress, 0 otherwise
RDB_RIEGL_DATA_ACQUISITION_ACTIVE                     = "riegl.data_acquisition_active"
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_NAME                = "riegl.data_acquisition_active"
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_TITLE               = "Data Acquisition Active"
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_GROUP               = "Secondary Attributes"
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_TAGS                = ""
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_DESCRIPTION         = "1 if the data acquisition is in progress, 0 otherwise"
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_UNIT                = ""
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_LENGTH              = 1
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_RESOLUTION          = 1.0
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_MINIMUM             = -1.0
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_MAXIMUM             = 1.0
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_DEFAULT             = -1.0
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_INVALID             = -1.0
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_NAMED_VALUES        = ""
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_LOD_SETTINGS        = "default"
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_SCALE               = 1.0
#
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_FALSE = 0
RDB_RIEGL_DATA_ACQUISITION_ACTIVE_TRUE = 1

# IDs (riegl.id) of plane patches this observation refers to (0 = invalid)
RDB_RIEGL_PLANE_REFERENCES                     = "riegl.plane_references"
RDB_RIEGL_PLANE_REFERENCES_NAME                = "riegl.plane_references"
RDB_RIEGL_PLANE_REFERENCES_TITLE               = "Plane Patch References"
RDB_RIEGL_PLANE_REFERENCES_GROUP               = "Secondary Attributes"
RDB_RIEGL_PLANE_REFERENCES_TAGS                = ""
RDB_RIEGL_PLANE_REFERENCES_DESCRIPTION         = "IDs (riegl.id) of plane patches this observation refers to (0 = invalid)"
RDB_RIEGL_PLANE_REFERENCES_UNIT                = ""
RDB_RIEGL_PLANE_REFERENCES_LENGTH              = 2
RDB_RIEGL_PLANE_REFERENCES_RESOLUTION          = 1.0
RDB_RIEGL_PLANE_REFERENCES_MINIMUM             = 0.0
RDB_RIEGL_PLANE_REFERENCES_MAXIMUM             = 1.0e12
RDB_RIEGL_PLANE_REFERENCES_DEFAULT             = 0.0
RDB_RIEGL_PLANE_REFERENCES_INVALID             = 0.0
RDB_RIEGL_PLANE_REFERENCES_NAMED_VALUES        = ""
RDB_RIEGL_PLANE_REFERENCES_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PLANE_REFERENCES_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PLANE_REFERENCES_LOD_SETTINGS        = "default"
RDB_RIEGL_PLANE_REFERENCES_SCALE               = 1.0
#
RDB_RIEGL_PLANE_REFERENCES_INVALID = 0

# Cumulative distance travelled
RDB_RIEGL_POF_PATH_LENGTH                     = "riegl.pof_path_length"
RDB_RIEGL_POF_PATH_LENGTH_NAME                = "riegl.pof_path_length"
RDB_RIEGL_POF_PATH_LENGTH_TITLE               = "Path Length"
RDB_RIEGL_POF_PATH_LENGTH_GROUP               = "Secondary Attributes"
RDB_RIEGL_POF_PATH_LENGTH_TAGS                = ""
RDB_RIEGL_POF_PATH_LENGTH_DESCRIPTION         = "Cumulative distance travelled"
RDB_RIEGL_POF_PATH_LENGTH_UNIT                = "m"
RDB_RIEGL_POF_PATH_LENGTH_LENGTH              = 1
RDB_RIEGL_POF_PATH_LENGTH_RESOLUTION          = 1.0e-3
RDB_RIEGL_POF_PATH_LENGTH_MINIMUM             = 0.0
RDB_RIEGL_POF_PATH_LENGTH_MAXIMUM             = 4.0e6
RDB_RIEGL_POF_PATH_LENGTH_DEFAULT             = 0.0
RDB_RIEGL_POF_PATH_LENGTH_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_PATH_LENGTH_NAMED_VALUES        = ""
RDB_RIEGL_POF_PATH_LENGTH_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_PATH_LENGTH_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA_SHUFFLE
RDB_RIEGL_POF_PATH_LENGTH_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_PATH_LENGTH_SCALE               = 1.0

# Position (3D) dilution of precision
RDB_RIEGL_POF_PDOP                     = "riegl.pof_pdop"
RDB_RIEGL_POF_PDOP_NAME                = "riegl.pof_pdop"
RDB_RIEGL_POF_PDOP_TITLE               = "PDOP"
RDB_RIEGL_POF_PDOP_GROUP               = "Secondary Attributes"
RDB_RIEGL_POF_PDOP_TAGS                = ""
RDB_RIEGL_POF_PDOP_DESCRIPTION         = "Position (3D) dilution of precision"
RDB_RIEGL_POF_PDOP_UNIT                = ""
RDB_RIEGL_POF_PDOP_LENGTH              = 1
RDB_RIEGL_POF_PDOP_RESOLUTION          = 0.01
RDB_RIEGL_POF_PDOP_MINIMUM             = 0.0
RDB_RIEGL_POF_PDOP_MAXIMUM             = 100.0
RDB_RIEGL_POF_PDOP_DEFAULT             = 0.0
RDB_RIEGL_POF_PDOP_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_PDOP_NAMED_VALUES        = ""
RDB_RIEGL_POF_PDOP_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_PDOP_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_PDOP_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_PDOP_SCALE               = 1.0

# Horizontal dilution of precision
RDB_RIEGL_POF_HDOP                     = "riegl.pof_hdop"
RDB_RIEGL_POF_HDOP_NAME                = "riegl.pof_hdop"
RDB_RIEGL_POF_HDOP_TITLE               = "HDOP"
RDB_RIEGL_POF_HDOP_GROUP               = "Secondary Attributes"
RDB_RIEGL_POF_HDOP_TAGS                = ""
RDB_RIEGL_POF_HDOP_DESCRIPTION         = "Horizontal dilution of precision"
RDB_RIEGL_POF_HDOP_UNIT                = ""
RDB_RIEGL_POF_HDOP_LENGTH              = 1
RDB_RIEGL_POF_HDOP_RESOLUTION          = 0.01
RDB_RIEGL_POF_HDOP_MINIMUM             = 0.0
RDB_RIEGL_POF_HDOP_MAXIMUM             = 100.0
RDB_RIEGL_POF_HDOP_DEFAULT             = 0.0
RDB_RIEGL_POF_HDOP_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_HDOP_NAMED_VALUES        = ""
RDB_RIEGL_POF_HDOP_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_HDOP_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_HDOP_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_HDOP_SCALE               = 1.0

# Vertical dilution of precision
RDB_RIEGL_POF_VDOP                     = "riegl.pof_vdop"
RDB_RIEGL_POF_VDOP_NAME                = "riegl.pof_vdop"
RDB_RIEGL_POF_VDOP_TITLE               = "VDOP"
RDB_RIEGL_POF_VDOP_GROUP               = "Secondary Attributes"
RDB_RIEGL_POF_VDOP_TAGS                = ""
RDB_RIEGL_POF_VDOP_DESCRIPTION         = "Vertical dilution of precision"
RDB_RIEGL_POF_VDOP_UNIT                = ""
RDB_RIEGL_POF_VDOP_LENGTH              = 1
RDB_RIEGL_POF_VDOP_RESOLUTION          = 0.01
RDB_RIEGL_POF_VDOP_MINIMUM             = 0.0
RDB_RIEGL_POF_VDOP_MAXIMUM             = 100.0
RDB_RIEGL_POF_VDOP_DEFAULT             = 0.0
RDB_RIEGL_POF_VDOP_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_VDOP_NAMED_VALUES        = ""
RDB_RIEGL_POF_VDOP_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_VDOP_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_VDOP_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_VDOP_SCALE               = 1.0

# Age of GNSS RTK corrections (-1 = unknown)
RDB_RIEGL_POF_AGE_OF_CORRECTIONS                     = "riegl.pof_age_of_corrections"
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_NAME                = "riegl.pof_age_of_corrections"
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_TITLE               = "Age Of Corrections"
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_GROUP               = "Secondary Attributes"
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_TAGS                = ""
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_DESCRIPTION         = "Age of GNSS RTK corrections (-1 = unknown)"
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_UNIT                = "s"
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_LENGTH              = 1
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_RESOLUTION          = 0.1
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_MINIMUM             = -1.0
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_MAXIMUM             = 1000.0
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_DEFAULT             = -1.0
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_INVALID             = -1.0
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_NAMED_VALUES        = ""
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_AGE_OF_CORRECTIONS_SCALE               = 1.0

# Length of GNSS RTK baseline, i.e. the distance between the antennas of the base station and the rover
RDB_RIEGL_POF_BASELINE_LENGTH                     = "riegl.pof_baseline_length"
RDB_RIEGL_POF_BASELINE_LENGTH_NAME                = "riegl.pof_baseline_length"
RDB_RIEGL_POF_BASELINE_LENGTH_TITLE               = "Baseline Length"
RDB_RIEGL_POF_BASELINE_LENGTH_GROUP               = "Secondary Attributes"
RDB_RIEGL_POF_BASELINE_LENGTH_TAGS                = ""
RDB_RIEGL_POF_BASELINE_LENGTH_DESCRIPTION         = "Length of GNSS RTK baseline, i.e. the distance between the antennas of the base station and the rover"
RDB_RIEGL_POF_BASELINE_LENGTH_UNIT                = "m"
RDB_RIEGL_POF_BASELINE_LENGTH_LENGTH              = 1
RDB_RIEGL_POF_BASELINE_LENGTH_RESOLUTION          = 0.1
RDB_RIEGL_POF_BASELINE_LENGTH_MINIMUM             = 0.0
RDB_RIEGL_POF_BASELINE_LENGTH_MAXIMUM             = 1000000.0
RDB_RIEGL_POF_BASELINE_LENGTH_DEFAULT             = 0.0
RDB_RIEGL_POF_BASELINE_LENGTH_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_BASELINE_LENGTH_NAMED_VALUES        = ""
RDB_RIEGL_POF_BASELINE_LENGTH_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_BASELINE_LENGTH_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_POF_BASELINE_LENGTH_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_BASELINE_LENGTH_SCALE               = 1.0

# Solution type of GNSS
RDB_RIEGL_POF_SOLUTION_GNSS                     = "riegl.pof_solution_gnss"
RDB_RIEGL_POF_SOLUTION_GNSS_NAME                = "riegl.pof_solution_gnss"
RDB_RIEGL_POF_SOLUTION_GNSS_TITLE               = "GNSS Solution"
RDB_RIEGL_POF_SOLUTION_GNSS_GROUP               = "Secondary Attributes"
RDB_RIEGL_POF_SOLUTION_GNSS_TAGS                = "enumeration"
RDB_RIEGL_POF_SOLUTION_GNSS_DESCRIPTION         = "Solution type of GNSS"
RDB_RIEGL_POF_SOLUTION_GNSS_UNIT                = ""
RDB_RIEGL_POF_SOLUTION_GNSS_LENGTH              = 1
RDB_RIEGL_POF_SOLUTION_GNSS_RESOLUTION          = 1.0
RDB_RIEGL_POF_SOLUTION_GNSS_MINIMUM             = 0.0
RDB_RIEGL_POF_SOLUTION_GNSS_MAXIMUM             = 8.0
RDB_RIEGL_POF_SOLUTION_GNSS_DEFAULT             = 0.0
RDB_RIEGL_POF_SOLUTION_GNSS_INVALID             = 0.0
RDB_RIEGL_POF_SOLUTION_GNSS_NAMED_VALUES        = "0=GNSS fix invalid\n1=GNSS fix single\n2=GNSS fix DGPS\n3=GNSS fix time only\n4=GNSS fix RTK fixed\n5=GNSS fix RTK float\n6=GNSS fix estimated\n7=GNSS fix manual\n8=GNSS fix simulated\n"
RDB_RIEGL_POF_SOLUTION_GNSS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_SOLUTION_GNSS_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_POF_SOLUTION_GNSS_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_SOLUTION_GNSS_SCALE               = 1.0

# Total number of GNSS satellites that were used to calculate the position
RDB_RIEGL_POF_SATELLITES_GNSS                     = "riegl.pof_satellites_gnss"
RDB_RIEGL_POF_SATELLITES_GNSS_NAME                = "riegl.pof_satellites_gnss"
RDB_RIEGL_POF_SATELLITES_GNSS_TITLE               = "Number of GNSS Satellites"
RDB_RIEGL_POF_SATELLITES_GNSS_GROUP               = "Secondary Attributes"
RDB_RIEGL_POF_SATELLITES_GNSS_TAGS                = ""
RDB_RIEGL_POF_SATELLITES_GNSS_DESCRIPTION         = "Total number of GNSS satellites that were used to calculate the position"
RDB_RIEGL_POF_SATELLITES_GNSS_UNIT                = ""
RDB_RIEGL_POF_SATELLITES_GNSS_LENGTH              = 1
RDB_RIEGL_POF_SATELLITES_GNSS_RESOLUTION          = 1.0
RDB_RIEGL_POF_SATELLITES_GNSS_MINIMUM             = 0.0
RDB_RIEGL_POF_SATELLITES_GNSS_MAXIMUM             = 1000.0
RDB_RIEGL_POF_SATELLITES_GNSS_DEFAULT             = 0.0
RDB_RIEGL_POF_SATELLITES_GNSS_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_SATELLITES_GNSS_NAMED_VALUES        = ""
RDB_RIEGL_POF_SATELLITES_GNSS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_SATELLITES_GNSS_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_SATELLITES_GNSS_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_SATELLITES_GNSS_SCALE               = 1.0

# Number of GPS satellites that were used to calculate the position
RDB_RIEGL_POF_SATELLITES_GPS                     = "riegl.pof_satellites_gps"
RDB_RIEGL_POF_SATELLITES_GPS_NAME                = "riegl.pof_satellites_gps"
RDB_RIEGL_POF_SATELLITES_GPS_TITLE               = "Number of GPS Satellites"
RDB_RIEGL_POF_SATELLITES_GPS_GROUP               = "Secondary Attributes"
RDB_RIEGL_POF_SATELLITES_GPS_TAGS                = ""
RDB_RIEGL_POF_SATELLITES_GPS_DESCRIPTION         = "Number of GPS satellites that were used to calculate the position"
RDB_RIEGL_POF_SATELLITES_GPS_UNIT                = ""
RDB_RIEGL_POF_SATELLITES_GPS_LENGTH              = 1
RDB_RIEGL_POF_SATELLITES_GPS_RESOLUTION          = 1.0
RDB_RIEGL_POF_SATELLITES_GPS_MINIMUM             = 0.0
RDB_RIEGL_POF_SATELLITES_GPS_MAXIMUM             = 1000.0
RDB_RIEGL_POF_SATELLITES_GPS_DEFAULT             = 0.0
RDB_RIEGL_POF_SATELLITES_GPS_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_SATELLITES_GPS_NAMED_VALUES        = ""
RDB_RIEGL_POF_SATELLITES_GPS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_SATELLITES_GPS_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_SATELLITES_GPS_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_SATELLITES_GPS_SCALE               = 1.0

# Number of GLONASS satellites that were used to calculate the position
RDB_RIEGL_POF_SATELLITES_GLONASS                     = "riegl.pof_satellites_glonass"
RDB_RIEGL_POF_SATELLITES_GLONASS_NAME                = "riegl.pof_satellites_glonass"
RDB_RIEGL_POF_SATELLITES_GLONASS_TITLE               = "Number of GLONASS Satellites"
RDB_RIEGL_POF_SATELLITES_GLONASS_GROUP               = "Secondary Attributes"
RDB_RIEGL_POF_SATELLITES_GLONASS_TAGS                = ""
RDB_RIEGL_POF_SATELLITES_GLONASS_DESCRIPTION         = "Number of GLONASS satellites that were used to calculate the position"
RDB_RIEGL_POF_SATELLITES_GLONASS_UNIT                = ""
RDB_RIEGL_POF_SATELLITES_GLONASS_LENGTH              = 1
RDB_RIEGL_POF_SATELLITES_GLONASS_RESOLUTION          = 1.0
RDB_RIEGL_POF_SATELLITES_GLONASS_MINIMUM             = 0.0
RDB_RIEGL_POF_SATELLITES_GLONASS_MAXIMUM             = 1000.0
RDB_RIEGL_POF_SATELLITES_GLONASS_DEFAULT             = 0.0
RDB_RIEGL_POF_SATELLITES_GLONASS_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_SATELLITES_GLONASS_NAMED_VALUES        = ""
RDB_RIEGL_POF_SATELLITES_GLONASS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_SATELLITES_GLONASS_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_SATELLITES_GLONASS_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_SATELLITES_GLONASS_SCALE               = 1.0

# Number of Beidou satellites that were used to calculate the position
RDB_RIEGL_POF_SATELLITES_BEIDOU                     = "riegl.pof_satellites_beidou"
RDB_RIEGL_POF_SATELLITES_BEIDOU_NAME                = "riegl.pof_satellites_beidou"
RDB_RIEGL_POF_SATELLITES_BEIDOU_TITLE               = "Number of Beidou Satellites"
RDB_RIEGL_POF_SATELLITES_BEIDOU_GROUP               = "Secondary Attributes"
RDB_RIEGL_POF_SATELLITES_BEIDOU_TAGS                = ""
RDB_RIEGL_POF_SATELLITES_BEIDOU_DESCRIPTION         = "Number of Beidou satellites that were used to calculate the position"
RDB_RIEGL_POF_SATELLITES_BEIDOU_UNIT                = ""
RDB_RIEGL_POF_SATELLITES_BEIDOU_LENGTH              = 1
RDB_RIEGL_POF_SATELLITES_BEIDOU_RESOLUTION          = 1.0
RDB_RIEGL_POF_SATELLITES_BEIDOU_MINIMUM             = 0.0
RDB_RIEGL_POF_SATELLITES_BEIDOU_MAXIMUM             = 1000.0
RDB_RIEGL_POF_SATELLITES_BEIDOU_DEFAULT             = 0.0
RDB_RIEGL_POF_SATELLITES_BEIDOU_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_SATELLITES_BEIDOU_NAMED_VALUES        = ""
RDB_RIEGL_POF_SATELLITES_BEIDOU_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_SATELLITES_BEIDOU_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_SATELLITES_BEIDOU_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_SATELLITES_BEIDOU_SCALE               = 1.0

# Number of Galileo satellites that were used to calculate the position
RDB_RIEGL_POF_SATELLITES_GALILEO                     = "riegl.pof_satellites_galileo"
RDB_RIEGL_POF_SATELLITES_GALILEO_NAME                = "riegl.pof_satellites_galileo"
RDB_RIEGL_POF_SATELLITES_GALILEO_TITLE               = "Number of Galileo Satellites"
RDB_RIEGL_POF_SATELLITES_GALILEO_GROUP               = "Secondary Attributes"
RDB_RIEGL_POF_SATELLITES_GALILEO_TAGS                = ""
RDB_RIEGL_POF_SATELLITES_GALILEO_DESCRIPTION         = "Number of Galileo satellites that were used to calculate the position"
RDB_RIEGL_POF_SATELLITES_GALILEO_UNIT                = ""
RDB_RIEGL_POF_SATELLITES_GALILEO_LENGTH              = 1
RDB_RIEGL_POF_SATELLITES_GALILEO_RESOLUTION          = 1.0
RDB_RIEGL_POF_SATELLITES_GALILEO_MINIMUM             = 0.0
RDB_RIEGL_POF_SATELLITES_GALILEO_MAXIMUM             = 1000.0
RDB_RIEGL_POF_SATELLITES_GALILEO_DEFAULT             = 0.0
RDB_RIEGL_POF_SATELLITES_GALILEO_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_SATELLITES_GALILEO_NAMED_VALUES        = ""
RDB_RIEGL_POF_SATELLITES_GALILEO_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_SATELLITES_GALILEO_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_SATELLITES_GALILEO_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_SATELLITES_GALILEO_SCALE               = 1.0

# Number of Quasi-Zenith Satellite System (QZSS) satellites that were used to calculate the position
RDB_RIEGL_POF_SATELLITES_QZSS                     = "riegl.pof_satellites_qzss"
RDB_RIEGL_POF_SATELLITES_QZSS_NAME                = "riegl.pof_satellites_qzss"
RDB_RIEGL_POF_SATELLITES_QZSS_TITLE               = "Number of QZSS Satellites"
RDB_RIEGL_POF_SATELLITES_QZSS_GROUP               = "Secondary Attributes"
RDB_RIEGL_POF_SATELLITES_QZSS_TAGS                = ""
RDB_RIEGL_POF_SATELLITES_QZSS_DESCRIPTION         = "Number of Quasi-Zenith Satellite System (QZSS) satellites that were used to calculate the position"
RDB_RIEGL_POF_SATELLITES_QZSS_UNIT                = ""
RDB_RIEGL_POF_SATELLITES_QZSS_LENGTH              = 1
RDB_RIEGL_POF_SATELLITES_QZSS_RESOLUTION          = 1.0
RDB_RIEGL_POF_SATELLITES_QZSS_MINIMUM             = 0.0
RDB_RIEGL_POF_SATELLITES_QZSS_MAXIMUM             = 1000.0
RDB_RIEGL_POF_SATELLITES_QZSS_DEFAULT             = 0.0
RDB_RIEGL_POF_SATELLITES_QZSS_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_POF_SATELLITES_QZSS_NAMED_VALUES        = ""
RDB_RIEGL_POF_SATELLITES_QZSS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_POF_SATELLITES_QZSS_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_POF_SATELLITES_QZSS_LOD_SETTINGS        = "default"
RDB_RIEGL_POF_SATELLITES_QZSS_SCALE               = 1.0

# Sums of the linear point distances to the pixel corner (0: dx, 1: dy, 2: dz)
RDB_RIEGL_PIXEL_LINEAR_SUMS                     = "riegl.pixel_linear_sums"
RDB_RIEGL_PIXEL_LINEAR_SUMS_NAME                = "riegl.pixel_linear_sums"
RDB_RIEGL_PIXEL_LINEAR_SUMS_TITLE               = "Linear Sums"
RDB_RIEGL_PIXEL_LINEAR_SUMS_GROUP               = "Secondary Attributes"
RDB_RIEGL_PIXEL_LINEAR_SUMS_TAGS                = ""
RDB_RIEGL_PIXEL_LINEAR_SUMS_DESCRIPTION         = "Sums of the linear point distances to the pixel corner (0: dx, 1: dy, 2: dz)"
RDB_RIEGL_PIXEL_LINEAR_SUMS_UNIT                = "m"
RDB_RIEGL_PIXEL_LINEAR_SUMS_LENGTH              = 3
RDB_RIEGL_PIXEL_LINEAR_SUMS_RESOLUTION          = 1e-3
RDB_RIEGL_PIXEL_LINEAR_SUMS_MINIMUM             = 0.0
RDB_RIEGL_PIXEL_LINEAR_SUMS_MAXIMUM             = 64000000.0
RDB_RIEGL_PIXEL_LINEAR_SUMS_DEFAULT             = 0.0
RDB_RIEGL_PIXEL_LINEAR_SUMS_INVALID             = 0.0
RDB_RIEGL_PIXEL_LINEAR_SUMS_NAMED_VALUES        = ""
RDB_RIEGL_PIXEL_LINEAR_SUMS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PIXEL_LINEAR_SUMS_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PIXEL_LINEAR_SUMS_LOD_SETTINGS        = "default"
RDB_RIEGL_PIXEL_LINEAR_SUMS_SCALE               = 1.0
#
RDB_RIEGL_PIXEL_LINEAR_SUMS_DX = 0
RDB_RIEGL_PIXEL_LINEAR_SUMS_DY = 1
RDB_RIEGL_PIXEL_LINEAR_SUMS_DZ = 2

# Sums of the square point distances to the pixel corner (0: dx*dx, 1: dy*dy, 2: dz*dz, 3: dx*dy, 4: dy*dz, 5: dx*dz)
RDB_RIEGL_PIXEL_SQUARE_SUMS                     = "riegl.pixel_square_sums"
RDB_RIEGL_PIXEL_SQUARE_SUMS_NAME                = "riegl.pixel_square_sums"
RDB_RIEGL_PIXEL_SQUARE_SUMS_TITLE               = "Square Sums"
RDB_RIEGL_PIXEL_SQUARE_SUMS_GROUP               = "Secondary Attributes"
RDB_RIEGL_PIXEL_SQUARE_SUMS_TAGS                = ""
RDB_RIEGL_PIXEL_SQUARE_SUMS_DESCRIPTION         = "Sums of the square point distances to the pixel corner (0: dx*dx, 1: dy*dy, 2: dz*dz, 3: dx*dy, 4: dy*dz, 5: dx*dz)"
RDB_RIEGL_PIXEL_SQUARE_SUMS_UNIT                = "m²"
RDB_RIEGL_PIXEL_SQUARE_SUMS_LENGTH              = 6
RDB_RIEGL_PIXEL_SQUARE_SUMS_RESOLUTION          = 1e-6
RDB_RIEGL_PIXEL_SQUARE_SUMS_MINIMUM             = 0.0
RDB_RIEGL_PIXEL_SQUARE_SUMS_MAXIMUM             = 5120000000.0
RDB_RIEGL_PIXEL_SQUARE_SUMS_DEFAULT             = 0.0
RDB_RIEGL_PIXEL_SQUARE_SUMS_INVALID             = 0.0
RDB_RIEGL_PIXEL_SQUARE_SUMS_NAMED_VALUES        = ""
RDB_RIEGL_PIXEL_SQUARE_SUMS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PIXEL_SQUARE_SUMS_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_PIXEL_SQUARE_SUMS_LOD_SETTINGS        = "default"
RDB_RIEGL_PIXEL_SQUARE_SUMS_SCALE               = 1.0
#
RDB_RIEGL_PIXEL_SQUARE_SUMS_DX_DX = 0
RDB_RIEGL_PIXEL_SQUARE_SUMS_DY_DY = 1
RDB_RIEGL_PIXEL_SQUARE_SUMS_DZ_DZ = 2
RDB_RIEGL_PIXEL_SQUARE_SUMS_DX_DY = 3
RDB_RIEGL_PIXEL_SQUARE_SUMS_DY_DZ = 4
RDB_RIEGL_PIXEL_SQUARE_SUMS_DX_DZ = 5

# Estimated shape of point cloud (0 = undefined, 1 = plane, 2 = line, 3 = volume)
RDB_RIEGL_SHAPE_ID                     = "riegl.shape_id"
RDB_RIEGL_SHAPE_ID_NAME                = "riegl.shape_id"
RDB_RIEGL_SHAPE_ID_TITLE               = "Point Cloud Shape"
RDB_RIEGL_SHAPE_ID_GROUP               = "Secondary Attributes"
RDB_RIEGL_SHAPE_ID_TAGS                = "enumeration"
RDB_RIEGL_SHAPE_ID_DESCRIPTION         = "Estimated shape of point cloud (0 = undefined, 1 = plane, 2 = line, 3 = volume)"
RDB_RIEGL_SHAPE_ID_UNIT                = ""
RDB_RIEGL_SHAPE_ID_LENGTH              = 1
RDB_RIEGL_SHAPE_ID_RESOLUTION          = 1.0
RDB_RIEGL_SHAPE_ID_MINIMUM             = 0.0
RDB_RIEGL_SHAPE_ID_MAXIMUM             = 3.0
RDB_RIEGL_SHAPE_ID_DEFAULT             = 0.0
RDB_RIEGL_SHAPE_ID_INVALID             = 0.0
RDB_RIEGL_SHAPE_ID_NAMED_VALUES        = "0=Undefined\n1=Plane\n2=Line\n3=Volume\n"
RDB_RIEGL_SHAPE_ID_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SHAPE_ID_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_SHAPE_ID_LOD_SETTINGS        = "default"
RDB_RIEGL_SHAPE_ID_SCALE               = 1.0
#
RDB_RIEGL_SHAPE_ID_UNDEFINED = 0
RDB_RIEGL_SHAPE_ID_PLANE = 1
RDB_RIEGL_SHAPE_ID_LINE = 2
RDB_RIEGL_SHAPE_ID_VOLUME = 3

# The plane cluster ID this point belongs to (0 = no cluster)
RDB_RIEGL_PLANE_CLUSTER_ID                     = "riegl.plane_cluster_id"
RDB_RIEGL_PLANE_CLUSTER_ID_NAME                = "riegl.plane_cluster_id"
RDB_RIEGL_PLANE_CLUSTER_ID_TITLE               = "Plane Cluster ID"
RDB_RIEGL_PLANE_CLUSTER_ID_GROUP               = "Secondary Attributes"
RDB_RIEGL_PLANE_CLUSTER_ID_TAGS                = ""
RDB_RIEGL_PLANE_CLUSTER_ID_DESCRIPTION         = "The plane cluster ID this point belongs to (0 = no cluster)"
RDB_RIEGL_PLANE_CLUSTER_ID_UNIT                = ""
RDB_RIEGL_PLANE_CLUSTER_ID_LENGTH              = 1
RDB_RIEGL_PLANE_CLUSTER_ID_RESOLUTION          = 1.0
RDB_RIEGL_PLANE_CLUSTER_ID_MINIMUM             = 0.0
RDB_RIEGL_PLANE_CLUSTER_ID_MAXIMUM             = 4000000000.0
RDB_RIEGL_PLANE_CLUSTER_ID_DEFAULT             = 0.0
RDB_RIEGL_PLANE_CLUSTER_ID_INVALID             = 0.0
RDB_RIEGL_PLANE_CLUSTER_ID_NAMED_VALUES        = ""
RDB_RIEGL_PLANE_CLUSTER_ID_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_PLANE_CLUSTER_ID_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_PLANE_CLUSTER_ID_LOD_SETTINGS        = "default"
RDB_RIEGL_PLANE_CLUSTER_ID_SCALE               = 1.0

# The segment ID this point belongs to (0 = no segment)
RDB_RIEGL_SEGMENT_ID                     = "riegl.segment_id"
RDB_RIEGL_SEGMENT_ID_NAME                = "riegl.segment_id"
RDB_RIEGL_SEGMENT_ID_TITLE               = "Segment ID"
RDB_RIEGL_SEGMENT_ID_GROUP               = "Secondary Attributes"
RDB_RIEGL_SEGMENT_ID_TAGS                = ""
RDB_RIEGL_SEGMENT_ID_DESCRIPTION         = "The segment ID this point belongs to (0 = no segment)"
RDB_RIEGL_SEGMENT_ID_UNIT                = ""
RDB_RIEGL_SEGMENT_ID_LENGTH              = 1
RDB_RIEGL_SEGMENT_ID_RESOLUTION          = 1.0
RDB_RIEGL_SEGMENT_ID_MINIMUM             = 0.0
RDB_RIEGL_SEGMENT_ID_MAXIMUM             = 4000000000.0
RDB_RIEGL_SEGMENT_ID_DEFAULT             = 0.0
RDB_RIEGL_SEGMENT_ID_INVALID             = 0.0
RDB_RIEGL_SEGMENT_ID_NAMED_VALUES        = ""
RDB_RIEGL_SEGMENT_ID_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SEGMENT_ID_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_SEGMENT_ID_LOD_SETTINGS        = "default"
RDB_RIEGL_SEGMENT_ID_SCALE               = 1.0

# Sums of the linear point distances to the voxel corner (0: dx, 1: dy, 2: dz)
RDB_RIEGL_VOXEL_LINEAR_SUMS                     = "riegl.voxel_linear_sums"
RDB_RIEGL_VOXEL_LINEAR_SUMS_NAME                = "riegl.voxel_linear_sums"
RDB_RIEGL_VOXEL_LINEAR_SUMS_TITLE               = "Linear Sums"
RDB_RIEGL_VOXEL_LINEAR_SUMS_GROUP               = "Secondary Attributes"
RDB_RIEGL_VOXEL_LINEAR_SUMS_TAGS                = ""
RDB_RIEGL_VOXEL_LINEAR_SUMS_DESCRIPTION         = "Sums of the linear point distances to the voxel corner (0: dx, 1: dy, 2: dz)"
RDB_RIEGL_VOXEL_LINEAR_SUMS_UNIT                = "m"
RDB_RIEGL_VOXEL_LINEAR_SUMS_LENGTH              = 3
RDB_RIEGL_VOXEL_LINEAR_SUMS_RESOLUTION          = 2.5e-4
RDB_RIEGL_VOXEL_LINEAR_SUMS_MINIMUM             = 0.0
RDB_RIEGL_VOXEL_LINEAR_SUMS_MAXIMUM             = 16000000.0
RDB_RIEGL_VOXEL_LINEAR_SUMS_DEFAULT             = 0.0
RDB_RIEGL_VOXEL_LINEAR_SUMS_INVALID             = 0.0
RDB_RIEGL_VOXEL_LINEAR_SUMS_NAMED_VALUES        = ""
RDB_RIEGL_VOXEL_LINEAR_SUMS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_VOXEL_LINEAR_SUMS_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_VOXEL_LINEAR_SUMS_LOD_SETTINGS        = "default"
RDB_RIEGL_VOXEL_LINEAR_SUMS_SCALE               = 1.0
#
RDB_RIEGL_VOXEL_LINEAR_SUMS_DX = 0
RDB_RIEGL_VOXEL_LINEAR_SUMS_DY = 1
RDB_RIEGL_VOXEL_LINEAR_SUMS_DZ = 2

# Sums of the square point distances to the voxel corner (0: dx*dx, 1: dy*dy, 2: dz*dz, 3: dx*dy, 4: dy*dz, 5: dx*dz)
RDB_RIEGL_VOXEL_SQUARE_SUMS                     = "riegl.voxel_square_sums"
RDB_RIEGL_VOXEL_SQUARE_SUMS_NAME                = "riegl.voxel_square_sums"
RDB_RIEGL_VOXEL_SQUARE_SUMS_TITLE               = "Square Sums"
RDB_RIEGL_VOXEL_SQUARE_SUMS_GROUP               = "Secondary Attributes"
RDB_RIEGL_VOXEL_SQUARE_SUMS_TAGS                = ""
RDB_RIEGL_VOXEL_SQUARE_SUMS_DESCRIPTION         = "Sums of the square point distances to the voxel corner (0: dx*dx, 1: dy*dy, 2: dz*dz, 3: dx*dy, 4: dy*dz, 5: dx*dz)"
RDB_RIEGL_VOXEL_SQUARE_SUMS_UNIT                = "m²"
RDB_RIEGL_VOXEL_SQUARE_SUMS_LENGTH              = 6
RDB_RIEGL_VOXEL_SQUARE_SUMS_RESOLUTION          = 6.25e-8
RDB_RIEGL_VOXEL_SQUARE_SUMS_MINIMUM             = 0.0
RDB_RIEGL_VOXEL_SQUARE_SUMS_MAXIMUM             = 320000000.0
RDB_RIEGL_VOXEL_SQUARE_SUMS_DEFAULT             = 0.0
RDB_RIEGL_VOXEL_SQUARE_SUMS_INVALID             = 0.0
RDB_RIEGL_VOXEL_SQUARE_SUMS_NAMED_VALUES        = ""
RDB_RIEGL_VOXEL_SQUARE_SUMS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_VOXEL_SQUARE_SUMS_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_VOXEL_SQUARE_SUMS_LOD_SETTINGS        = "default"
RDB_RIEGL_VOXEL_SQUARE_SUMS_SCALE               = 1.0
#
RDB_RIEGL_VOXEL_SQUARE_SUMS_DX_DX = 0
RDB_RIEGL_VOXEL_SQUARE_SUMS_DY_DY = 1
RDB_RIEGL_VOXEL_SQUARE_SUMS_DZ_DZ = 2
RDB_RIEGL_VOXEL_SQUARE_SUMS_DX_DY = 3
RDB_RIEGL_VOXEL_SQUARE_SUMS_DY_DZ = 4
RDB_RIEGL_VOXEL_SQUARE_SUMS_DX_DZ = 5

# Integer coordinates of voxel corner
RDB_RIEGL_VOXEL_INDEX                     = "riegl.voxel_index"
RDB_RIEGL_VOXEL_INDEX_NAME                = "riegl.voxel_index"
RDB_RIEGL_VOXEL_INDEX_TITLE               = "Voxel Index"
RDB_RIEGL_VOXEL_INDEX_GROUP               = "Secondary Attributes"
RDB_RIEGL_VOXEL_INDEX_TAGS                = ""
RDB_RIEGL_VOXEL_INDEX_DESCRIPTION         = "Integer coordinates of voxel corner"
RDB_RIEGL_VOXEL_INDEX_UNIT                = ""
RDB_RIEGL_VOXEL_INDEX_LENGTH              = 3
RDB_RIEGL_VOXEL_INDEX_RESOLUTION          = 1.0
RDB_RIEGL_VOXEL_INDEX_MINIMUM             = 0.0
RDB_RIEGL_VOXEL_INDEX_MAXIMUM             = 4294967295.0
RDB_RIEGL_VOXEL_INDEX_DEFAULT             = 0.0
RDB_RIEGL_VOXEL_INDEX_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_VOXEL_INDEX_NAMED_VALUES        = ""
RDB_RIEGL_VOXEL_INDEX_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_VOXEL_INDEX_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_VOXEL_INDEX_LOD_SETTINGS        = "default"
RDB_RIEGL_VOXEL_INDEX_SCALE               = 1.0

# Elements 00, 11, 22, 10, 21 and 20 (in that order) of point cloud covariance matrix
RDB_RIEGL_COVARIANCES                     = "riegl.covariances"
RDB_RIEGL_COVARIANCES_NAME                = "riegl.covariances"
RDB_RIEGL_COVARIANCES_TITLE               = "Point Cloud Covariances"
RDB_RIEGL_COVARIANCES_GROUP               = "Secondary Attributes"
RDB_RIEGL_COVARIANCES_TAGS                = ""
RDB_RIEGL_COVARIANCES_DESCRIPTION         = "Elements 00, 11, 22, 10, 21 and 20 (in that order) of point cloud covariance matrix"
RDB_RIEGL_COVARIANCES_UNIT                = ""
RDB_RIEGL_COVARIANCES_LENGTH              = 6
RDB_RIEGL_COVARIANCES_RESOLUTION          = 1.0e-6
RDB_RIEGL_COVARIANCES_MINIMUM             = -4.5e9
RDB_RIEGL_COVARIANCES_MAXIMUM             = 4.5e9
RDB_RIEGL_COVARIANCES_DEFAULT             = 0.0
RDB_RIEGL_COVARIANCES_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_COVARIANCES_NAMED_VALUES        = ""
RDB_RIEGL_COVARIANCES_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_COVARIANCES_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_COVARIANCES_LOD_SETTINGS        = "default"
RDB_RIEGL_COVARIANCES_SCALE               = 1.0

# Number of voxels this point represents (e.g. voxels combined to pixels, 0 = unknown)
RDB_RIEGL_VOXEL_COUNT                     = "riegl.voxel_count"
RDB_RIEGL_VOXEL_COUNT_NAME                = "riegl.voxel_count"
RDB_RIEGL_VOXEL_COUNT_TITLE               = "Voxel Count"
RDB_RIEGL_VOXEL_COUNT_GROUP               = "Secondary Attributes"
RDB_RIEGL_VOXEL_COUNT_TAGS                = ""
RDB_RIEGL_VOXEL_COUNT_DESCRIPTION         = "Number of voxels this point represents (e.g. voxels combined to pixels, 0 = unknown)"
RDB_RIEGL_VOXEL_COUNT_UNIT                = ""
RDB_RIEGL_VOXEL_COUNT_LENGTH              = 1
RDB_RIEGL_VOXEL_COUNT_RESOLUTION          = 1.0
RDB_RIEGL_VOXEL_COUNT_MINIMUM             = 0.0
RDB_RIEGL_VOXEL_COUNT_MAXIMUM             = 4294967295.0
RDB_RIEGL_VOXEL_COUNT_DEFAULT             = 0.0
RDB_RIEGL_VOXEL_COUNT_INVALID             = 0.0
RDB_RIEGL_VOXEL_COUNT_NAMED_VALUES        = ""
RDB_RIEGL_VOXEL_COUNT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_VOXEL_COUNT_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_VOXEL_COUNT_LOD_SETTINGS        = "default"
RDB_RIEGL_VOXEL_COUNT_SCALE               = 1.0
#
RDB_RIEGL_VOXEL_COUNT_UNKNOWN = 0

# Point identifier, unique within database (0 = invalid)
RDB_RIEGL_ID                     = "riegl.id"
RDB_RIEGL_ID_NAME                = "riegl.id"
RDB_RIEGL_ID_TITLE               = "PID"
RDB_RIEGL_ID_GROUP               = "Secondary Attributes"
RDB_RIEGL_ID_TAGS                = ""
RDB_RIEGL_ID_DESCRIPTION         = "Point identifier, unique within database (0 = invalid)"
RDB_RIEGL_ID_UNIT                = ""
RDB_RIEGL_ID_LENGTH              = 1
RDB_RIEGL_ID_RESOLUTION          = 1.0
RDB_RIEGL_ID_MINIMUM             = 0.0
RDB_RIEGL_ID_MAXIMUM             = 1.0e12
RDB_RIEGL_ID_DEFAULT             = 0.0
RDB_RIEGL_ID_INVALID             = 0.0
RDB_RIEGL_ID_NAMED_VALUES        = ""
RDB_RIEGL_ID_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_ID_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_ID_LOD_SETTINGS        = "default"
RDB_RIEGL_ID_SCALE               = 1.0
#
RDB_RIEGL_ID_INVALID = 0

# Identifier of first vertex that belongs to a geometry object (e.g. polyline) (0 = invalid)
RDB_RIEGL_VERTEX_FIRST                     = "riegl.vertex_first"
RDB_RIEGL_VERTEX_FIRST_NAME                = "riegl.vertex_first"
RDB_RIEGL_VERTEX_FIRST_TITLE               = "Vertex First"
RDB_RIEGL_VERTEX_FIRST_GROUP               = "Secondary Attributes"
RDB_RIEGL_VERTEX_FIRST_TAGS                = ""
RDB_RIEGL_VERTEX_FIRST_DESCRIPTION         = "Identifier of first vertex that belongs to a geometry object (e.g. polyline) (0 = invalid)"
RDB_RIEGL_VERTEX_FIRST_UNIT                = ""
RDB_RIEGL_VERTEX_FIRST_LENGTH              = 1
RDB_RIEGL_VERTEX_FIRST_RESOLUTION          = 1.0
RDB_RIEGL_VERTEX_FIRST_MINIMUM             = 0.0
RDB_RIEGL_VERTEX_FIRST_MAXIMUM             = 4294967295.0
RDB_RIEGL_VERTEX_FIRST_DEFAULT             = 0.0
RDB_RIEGL_VERTEX_FIRST_INVALID             = 0.0
RDB_RIEGL_VERTEX_FIRST_NAMED_VALUES        = ""
RDB_RIEGL_VERTEX_FIRST_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_VERTEX_FIRST_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_VERTEX_FIRST_LOD_SETTINGS        = "default"
RDB_RIEGL_VERTEX_FIRST_SCALE               = 1.0

# Number of vertices that belong to a geometry object (e.g. polyline)
RDB_RIEGL_VERTEX_COUNT                     = "riegl.vertex_count"
RDB_RIEGL_VERTEX_COUNT_NAME                = "riegl.vertex_count"
RDB_RIEGL_VERTEX_COUNT_TITLE               = "Vertex Count"
RDB_RIEGL_VERTEX_COUNT_GROUP               = "Secondary Attributes"
RDB_RIEGL_VERTEX_COUNT_TAGS                = ""
RDB_RIEGL_VERTEX_COUNT_DESCRIPTION         = "Number of vertices that belong to a geometry object (e.g. polyline)"
RDB_RIEGL_VERTEX_COUNT_UNIT                = ""
RDB_RIEGL_VERTEX_COUNT_LENGTH              = 1
RDB_RIEGL_VERTEX_COUNT_RESOLUTION          = 1.0
RDB_RIEGL_VERTEX_COUNT_MINIMUM             = 0.0
RDB_RIEGL_VERTEX_COUNT_MAXIMUM             = 65535.0
RDB_RIEGL_VERTEX_COUNT_DEFAULT             = 0.0
RDB_RIEGL_VERTEX_COUNT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_VERTEX_COUNT_NAMED_VALUES        = ""
RDB_RIEGL_VERTEX_COUNT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_VERTEX_COUNT_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_VERTEX_COUNT_LOD_SETTINGS        = "default"
RDB_RIEGL_VERTEX_COUNT_SCALE               = 1.0

# Search radius for finding the control point in the scan data. This value (if valid) shall be preferred over that of the common settings when finding observation points for the respective control point.
RDB_RIEGL_CP_SEARCH_RADIUS                     = "riegl.cp_search_radius"
RDB_RIEGL_CP_SEARCH_RADIUS_NAME                = "riegl.cp_search_radius"
RDB_RIEGL_CP_SEARCH_RADIUS_TITLE               = "Search Radius"
RDB_RIEGL_CP_SEARCH_RADIUS_GROUP               = "Secondary Attributes"
RDB_RIEGL_CP_SEARCH_RADIUS_TAGS                = ""
RDB_RIEGL_CP_SEARCH_RADIUS_DESCRIPTION         = "Search radius for finding the control point in the scan data. This value (if valid) shall be preferred over that of the common settings when finding observation points for the respective control point."
RDB_RIEGL_CP_SEARCH_RADIUS_UNIT                = "m"
RDB_RIEGL_CP_SEARCH_RADIUS_LENGTH              = 1
RDB_RIEGL_CP_SEARCH_RADIUS_RESOLUTION          = 0.01
RDB_RIEGL_CP_SEARCH_RADIUS_MINIMUM             = 0.0
RDB_RIEGL_CP_SEARCH_RADIUS_MAXIMUM             = 655.35
RDB_RIEGL_CP_SEARCH_RADIUS_DEFAULT             = 0.0
RDB_RIEGL_CP_SEARCH_RADIUS_INVALID             = 0.0
RDB_RIEGL_CP_SEARCH_RADIUS_NAMED_VALUES        = ""
RDB_RIEGL_CP_SEARCH_RADIUS_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_CP_SEARCH_RADIUS_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_CP_SEARCH_RADIUS_LOD_SETTINGS        = "default"
RDB_RIEGL_CP_SEARCH_RADIUS_SCALE               = 1.0
#
RDB_RIEGL_CP_SEARCH_RADIUS_INVALID = 0.0

# Maximum accepted distance of an observed control point from SOCS center. This value (if valid) shall be preferred over that of the common settings when finding observation points for the respective control point.
RDB_RIEGL_CP_MAXIMUM_DISTANCE                     = "riegl.cp_maximum_distance"
RDB_RIEGL_CP_MAXIMUM_DISTANCE_NAME                = "riegl.cp_maximum_distance"
RDB_RIEGL_CP_MAXIMUM_DISTANCE_TITLE               = "Maximum distance"
RDB_RIEGL_CP_MAXIMUM_DISTANCE_GROUP               = "Secondary Attributes"
RDB_RIEGL_CP_MAXIMUM_DISTANCE_TAGS                = ""
RDB_RIEGL_CP_MAXIMUM_DISTANCE_DESCRIPTION         = "Maximum accepted distance of an observed control point from SOCS center. This value (if valid) shall be preferred over that of the common settings when finding observation points for the respective control point."
RDB_RIEGL_CP_MAXIMUM_DISTANCE_UNIT                = "m"
RDB_RIEGL_CP_MAXIMUM_DISTANCE_LENGTH              = 1
RDB_RIEGL_CP_MAXIMUM_DISTANCE_RESOLUTION          = 0.1
RDB_RIEGL_CP_MAXIMUM_DISTANCE_MINIMUM             = 0.0
RDB_RIEGL_CP_MAXIMUM_DISTANCE_MAXIMUM             = 50000.0
RDB_RIEGL_CP_MAXIMUM_DISTANCE_DEFAULT             = 0.0
RDB_RIEGL_CP_MAXIMUM_DISTANCE_INVALID             = 0.0
RDB_RIEGL_CP_MAXIMUM_DISTANCE_NAMED_VALUES        = ""
RDB_RIEGL_CP_MAXIMUM_DISTANCE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_CP_MAXIMUM_DISTANCE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_CP_MAXIMUM_DISTANCE_LOD_SETTINGS        = "default"
RDB_RIEGL_CP_MAXIMUM_DISTANCE_SCALE               = 1.0
#
RDB_RIEGL_CP_MAXIMUM_DISTANCE_INVALID = 0.0

# ______________________________________________________________________________
#
# POINT ATTRIBUTE GROUP "Other Attributes"
# ______________________________________________________________________________
#

# Point selected by user (0 = not selected, 1 = selected)
RDB_RIEGL_SELECTED                     = "riegl.selected"
RDB_RIEGL_SELECTED_NAME                = "riegl.selected"
RDB_RIEGL_SELECTED_TITLE               = "Selected"
RDB_RIEGL_SELECTED_GROUP               = "Other Attributes"
RDB_RIEGL_SELECTED_TAGS                = "boolean"
RDB_RIEGL_SELECTED_DESCRIPTION         = "Point selected by user (0 = not selected, 1 = selected)"
RDB_RIEGL_SELECTED_UNIT                = ""
RDB_RIEGL_SELECTED_LENGTH              = 1
RDB_RIEGL_SELECTED_RESOLUTION          = 1.0
RDB_RIEGL_SELECTED_MINIMUM             = 0.0
RDB_RIEGL_SELECTED_MAXIMUM             = 1.0
RDB_RIEGL_SELECTED_DEFAULT             = 0.0
RDB_RIEGL_SELECTED_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SELECTED_NAMED_VALUES        = ""
RDB_RIEGL_SELECTED_STORAGE_CLASS       = RDB_STORAGE_DYNAMIC
RDB_RIEGL_SELECTED_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_SELECTED_LOD_SETTINGS        = "default"
RDB_RIEGL_SELECTED_SCALE               = 1.0
#
RDB_RIEGL_SELECTED_FALSE = 0
RDB_RIEGL_SELECTED_TRUE = 1

# Point visible (i.e. not hidden) in view (0 = hidden, 1 = visible)
RDB_RIEGL_VISIBLE                     = "riegl.visible"
RDB_RIEGL_VISIBLE_NAME                = "riegl.visible"
RDB_RIEGL_VISIBLE_TITLE               = "Visible"
RDB_RIEGL_VISIBLE_GROUP               = "Other Attributes"
RDB_RIEGL_VISIBLE_TAGS                = "boolean"
RDB_RIEGL_VISIBLE_DESCRIPTION         = "Point visible (i.e. not hidden) in view (0 = hidden, 1 = visible)"
RDB_RIEGL_VISIBLE_UNIT                = ""
RDB_RIEGL_VISIBLE_LENGTH              = 1
RDB_RIEGL_VISIBLE_RESOLUTION          = 1.0
RDB_RIEGL_VISIBLE_MINIMUM             = 0.0
RDB_RIEGL_VISIBLE_MAXIMUM             = 1.0
RDB_RIEGL_VISIBLE_DEFAULT             = 1.0
RDB_RIEGL_VISIBLE_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_VISIBLE_NAMED_VALUES        = ""
RDB_RIEGL_VISIBLE_STORAGE_CLASS       = RDB_STORAGE_DYNAMIC
RDB_RIEGL_VISIBLE_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_VISIBLE_LOD_SETTINGS        = "default"
RDB_RIEGL_VISIBLE_SCALE               = 1.0
#
RDB_RIEGL_VISIBLE_FALSE = 0
RDB_RIEGL_VISIBLE_TRUE = 1

# ID of original point cloud (0 = unknown)
RDB_RIEGL_SOURCE_CLOUD_ID                     = "riegl.source_cloud_id"
RDB_RIEGL_SOURCE_CLOUD_ID_NAME                = "riegl.source_cloud_id"
RDB_RIEGL_SOURCE_CLOUD_ID_TITLE               = "Point Cloud ID"
RDB_RIEGL_SOURCE_CLOUD_ID_GROUP               = "Other Attributes"
RDB_RIEGL_SOURCE_CLOUD_ID_TAGS                = ""
RDB_RIEGL_SOURCE_CLOUD_ID_DESCRIPTION         = "ID of original point cloud (0 = unknown)"
RDB_RIEGL_SOURCE_CLOUD_ID_UNIT                = ""
RDB_RIEGL_SOURCE_CLOUD_ID_LENGTH              = 1
RDB_RIEGL_SOURCE_CLOUD_ID_RESOLUTION          = 1.0
RDB_RIEGL_SOURCE_CLOUD_ID_MINIMUM             = 0.0
RDB_RIEGL_SOURCE_CLOUD_ID_MAXIMUM             = 10000.0
RDB_RIEGL_SOURCE_CLOUD_ID_DEFAULT             = 0.0
RDB_RIEGL_SOURCE_CLOUD_ID_INVALID             = 0.0
RDB_RIEGL_SOURCE_CLOUD_ID_NAMED_VALUES        = ""
RDB_RIEGL_SOURCE_CLOUD_ID_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_SOURCE_CLOUD_ID_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_SOURCE_CLOUD_ID_LOD_SETTINGS        = "default"
RDB_RIEGL_SOURCE_CLOUD_ID_SCALE               = 1.0
#
RDB_RIEGL_SOURCE_CLOUD_ID_UNKNOWN = 0

# For points merged from multiple source files, the number of source files contributing to the point (0 = unknown)
RDB_RIEGL_SOURCE_CLOUD_COUNT                     = "riegl.source_cloud_count"
RDB_RIEGL_SOURCE_CLOUD_COUNT_NAME                = "riegl.source_cloud_count"
RDB_RIEGL_SOURCE_CLOUD_COUNT_TITLE               = "Point Cloud Count"
RDB_RIEGL_SOURCE_CLOUD_COUNT_GROUP               = "Other Attributes"
RDB_RIEGL_SOURCE_CLOUD_COUNT_TAGS                = ""
RDB_RIEGL_SOURCE_CLOUD_COUNT_DESCRIPTION         = "For points merged from multiple source files, the number of source files contributing to the point (0 = unknown)"
RDB_RIEGL_SOURCE_CLOUD_COUNT_UNIT                = ""
RDB_RIEGL_SOURCE_CLOUD_COUNT_LENGTH              = 1
RDB_RIEGL_SOURCE_CLOUD_COUNT_RESOLUTION          = 1.0
RDB_RIEGL_SOURCE_CLOUD_COUNT_MINIMUM             = 0.0
RDB_RIEGL_SOURCE_CLOUD_COUNT_MAXIMUM             = 65535.0
RDB_RIEGL_SOURCE_CLOUD_COUNT_DEFAULT             = 0.0
RDB_RIEGL_SOURCE_CLOUD_COUNT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SOURCE_CLOUD_COUNT_NAMED_VALUES        = ""
RDB_RIEGL_SOURCE_CLOUD_COUNT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SOURCE_CLOUD_COUNT_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_SOURCE_CLOUD_COUNT_LOD_SETTINGS        = "default"
RDB_RIEGL_SOURCE_CLOUD_COUNT_SCALE               = 1.0
#
RDB_RIEGL_SOURCE_CLOUD_COUNT_UNKNOWN = 0

# Index of point in original point cloud (0 = unknown)
RDB_RIEGL_SOURCE_INDEX                     = "riegl.source_index"
RDB_RIEGL_SOURCE_INDEX_NAME                = "riegl.source_index"
RDB_RIEGL_SOURCE_INDEX_TITLE               = "Point Index"
RDB_RIEGL_SOURCE_INDEX_GROUP               = "Other Attributes"
RDB_RIEGL_SOURCE_INDEX_TAGS                = ""
RDB_RIEGL_SOURCE_INDEX_DESCRIPTION         = "Index of point in original point cloud (0 = unknown)"
RDB_RIEGL_SOURCE_INDEX_UNIT                = ""
RDB_RIEGL_SOURCE_INDEX_LENGTH              = 1
RDB_RIEGL_SOURCE_INDEX_RESOLUTION          = 1.0
RDB_RIEGL_SOURCE_INDEX_MINIMUM             = 0.0
RDB_RIEGL_SOURCE_INDEX_MAXIMUM             = 1.0e12
RDB_RIEGL_SOURCE_INDEX_DEFAULT             = 0.0
RDB_RIEGL_SOURCE_INDEX_INVALID             = 0.0
RDB_RIEGL_SOURCE_INDEX_NAMED_VALUES        = ""
RDB_RIEGL_SOURCE_INDEX_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_SOURCE_INDEX_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_SOURCE_INDEX_LOD_SETTINGS        = "default"
RDB_RIEGL_SOURCE_INDEX_SCALE               = 1.0
#
RDB_RIEGL_SOURCE_INDEX_UNKNOWN = 0

# 0 for all points derived by standard waveform processing, 1 for additional points derived from interpolation, other enum values to be defined separately
RDB_RIEGL_SOURCE_INDICATOR                     = "riegl.source_indicator"
RDB_RIEGL_SOURCE_INDICATOR_NAME                = "riegl.source_indicator"
RDB_RIEGL_SOURCE_INDICATOR_TITLE               = "Source Indicator"
RDB_RIEGL_SOURCE_INDICATOR_GROUP               = "Other Attributes"
RDB_RIEGL_SOURCE_INDICATOR_TAGS                = "enumeration"
RDB_RIEGL_SOURCE_INDICATOR_DESCRIPTION         = "0 for all points derived by standard waveform processing, 1 for additional points derived from interpolation, other enum values to be defined separately"
RDB_RIEGL_SOURCE_INDICATOR_UNIT                = ""
RDB_RIEGL_SOURCE_INDICATOR_LENGTH              = 1
RDB_RIEGL_SOURCE_INDICATOR_RESOLUTION          = 1.0
RDB_RIEGL_SOURCE_INDICATOR_MINIMUM             = 0.0
RDB_RIEGL_SOURCE_INDICATOR_MAXIMUM             = 255.0
RDB_RIEGL_SOURCE_INDICATOR_DEFAULT             = 0.0
RDB_RIEGL_SOURCE_INDICATOR_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SOURCE_INDICATOR_NAMED_VALUES        = "0=Standard processing\n1=Target interpolation\n"
RDB_RIEGL_SOURCE_INDICATOR_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SOURCE_INDICATOR_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_SOURCE_INDICATOR_LOD_SETTINGS        = "default"
RDB_RIEGL_SOURCE_INDICATOR_SCALE               = 1.0
#
RDB_RIEGL_SOURCE_INDICATOR_STANDARD_PROCESSING = 0
RDB_RIEGL_SOURCE_INDICATOR_TARGET_INTERPOLATION = 1

# Marks points that belong to dynamic objects (0 = no dynamic object, 1 = dynamic object)
RDB_RIEGL_DYNAMIC_OBJECT_POINT                     = "riegl.dynamic_object_point"
RDB_RIEGL_DYNAMIC_OBJECT_POINT_NAME                = "riegl.dynamic_object_point"
RDB_RIEGL_DYNAMIC_OBJECT_POINT_TITLE               = "Dynamic Object Point"
RDB_RIEGL_DYNAMIC_OBJECT_POINT_GROUP               = "Other Attributes"
RDB_RIEGL_DYNAMIC_OBJECT_POINT_TAGS                = "boolean"
RDB_RIEGL_DYNAMIC_OBJECT_POINT_DESCRIPTION         = "Marks points that belong to dynamic objects (0 = no dynamic object, 1 = dynamic object)"
RDB_RIEGL_DYNAMIC_OBJECT_POINT_UNIT                = ""
RDB_RIEGL_DYNAMIC_OBJECT_POINT_LENGTH              = 1
RDB_RIEGL_DYNAMIC_OBJECT_POINT_RESOLUTION          = 1.0
RDB_RIEGL_DYNAMIC_OBJECT_POINT_MINIMUM             = 0.0
RDB_RIEGL_DYNAMIC_OBJECT_POINT_MAXIMUM             = 1.0
RDB_RIEGL_DYNAMIC_OBJECT_POINT_DEFAULT             = 0.0
RDB_RIEGL_DYNAMIC_OBJECT_POINT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_DYNAMIC_OBJECT_POINT_NAMED_VALUES        = ""
RDB_RIEGL_DYNAMIC_OBJECT_POINT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_DYNAMIC_OBJECT_POINT_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_DYNAMIC_OBJECT_POINT_LOD_SETTINGS        = "default"
RDB_RIEGL_DYNAMIC_OBJECT_POINT_SCALE               = 1.0

# Marks points that originate from one source file (0 = multiple source files, 1 = single source file)
RDB_RIEGL_SINGLE_SOURCE_POINT                     = "riegl.single_source_point"
RDB_RIEGL_SINGLE_SOURCE_POINT_NAME                = "riegl.single_source_point"
RDB_RIEGL_SINGLE_SOURCE_POINT_TITLE               = "Single Source Point"
RDB_RIEGL_SINGLE_SOURCE_POINT_GROUP               = "Other Attributes"
RDB_RIEGL_SINGLE_SOURCE_POINT_TAGS                = "boolean"
RDB_RIEGL_SINGLE_SOURCE_POINT_DESCRIPTION         = "Marks points that originate from one source file (0 = multiple source files, 1 = single source file)"
RDB_RIEGL_SINGLE_SOURCE_POINT_UNIT                = ""
RDB_RIEGL_SINGLE_SOURCE_POINT_LENGTH              = 1
RDB_RIEGL_SINGLE_SOURCE_POINT_RESOLUTION          = 1.0
RDB_RIEGL_SINGLE_SOURCE_POINT_MINIMUM             = 0.0
RDB_RIEGL_SINGLE_SOURCE_POINT_MAXIMUM             = 1.0
RDB_RIEGL_SINGLE_SOURCE_POINT_DEFAULT             = 1.0
RDB_RIEGL_SINGLE_SOURCE_POINT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_SINGLE_SOURCE_POINT_NAMED_VALUES        = ""
RDB_RIEGL_SINGLE_SOURCE_POINT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_SINGLE_SOURCE_POINT_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_SINGLE_SOURCE_POINT_LOD_SETTINGS        = "default"
RDB_RIEGL_SINGLE_SOURCE_POINT_SCALE               = 1.0

# Marks points that belong to mirror objects (0 = no mirror object, 1 = mirror object)
RDB_RIEGL_MIRROR_OBJECT_POINT                     = "riegl.mirror_object_point"
RDB_RIEGL_MIRROR_OBJECT_POINT_NAME                = "riegl.mirror_object_point"
RDB_RIEGL_MIRROR_OBJECT_POINT_TITLE               = "Mirror Object Point"
RDB_RIEGL_MIRROR_OBJECT_POINT_GROUP               = "Other Attributes"
RDB_RIEGL_MIRROR_OBJECT_POINT_TAGS                = "boolean"
RDB_RIEGL_MIRROR_OBJECT_POINT_DESCRIPTION         = "Marks points that belong to mirror objects (0 = no mirror object, 1 = mirror object)"
RDB_RIEGL_MIRROR_OBJECT_POINT_UNIT                = ""
RDB_RIEGL_MIRROR_OBJECT_POINT_LENGTH              = 1
RDB_RIEGL_MIRROR_OBJECT_POINT_RESOLUTION          = 1.0
RDB_RIEGL_MIRROR_OBJECT_POINT_MINIMUM             = 0.0
RDB_RIEGL_MIRROR_OBJECT_POINT_MAXIMUM             = 1.0
RDB_RIEGL_MIRROR_OBJECT_POINT_DEFAULT             = 0.0
RDB_RIEGL_MIRROR_OBJECT_POINT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_MIRROR_OBJECT_POINT_NAMED_VALUES        = ""
RDB_RIEGL_MIRROR_OBJECT_POINT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_MIRROR_OBJECT_POINT_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_MIRROR_OBJECT_POINT_LOD_SETTINGS        = "default"
RDB_RIEGL_MIRROR_OBJECT_POINT_SCALE               = 1.0

# 1 for all points in temporal vicinity of echoes from the exit aperture and corrected for the impact of the exit pane on amplitude and range, 0 otherwise
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED                     = "riegl.window_echo_impact_corrected"
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_NAME                = "riegl.window_echo_impact_corrected"
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_TITLE               = "Window Echo Impact Corrected"
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_GROUP               = "Other Attributes"
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_TAGS                = "boolean"
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_DESCRIPTION         = "1 for all points in temporal vicinity of echoes from the exit aperture and corrected for the impact of the exit pane on amplitude and range, 0 otherwise"
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_UNIT                = ""
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_LENGTH              = 1
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_RESOLUTION          = 1.0
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_MINIMUM             = 0.0
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_MAXIMUM             = 1.0
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_DEFAULT             = 0.0
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_NAMED_VALUES        = "0=Not impacted by exit aperture\n1=Impacted by exit aperture\n"
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_LOD_SETTINGS        = "default"
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_SCALE               = 1.0
#
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_FALSE = 0
RDB_RIEGL_WINDOW_ECHO_IMPACT_CORRECTED_TRUE = 1

# 1 for all points with an echo signal amplitude below the dynamic trigger level, 0 otherwise
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT                     = "riegl.dyntrig_uncertain_point"
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_NAME                = "riegl.dyntrig_uncertain_point"
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_TITLE               = "Dyntrig Uncertain Point"
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_GROUP               = "Other Attributes"
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_TAGS                = "boolean"
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_DESCRIPTION         = "1 for all points with an echo signal amplitude below the dynamic trigger level, 0 otherwise"
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_UNIT                = ""
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_LENGTH              = 1
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_RESOLUTION          = 1.0
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_MINIMUM             = 0.0
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_MAXIMUM             = 1.0
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_DEFAULT             = 0.0
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_NAMED_VALUES        = ""
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_COMPRESSION_OPTIONS = RDB_COMPRESSION_DEFAULT
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_LOD_SETTINGS        = "default"
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_SCALE               = 1.0
#
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_FALSE = 0
RDB_RIEGL_DYNTRIG_UNCERTAIN_POINT_TRUE = 1

# Altitude determined based on the atmospheric pressure according to the standard atmosphere laws
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL                     = "riegl.barometric_height_amsl"
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_NAME                = "riegl.barometric_height_amsl"
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_TITLE               = "Barometric Altitude"
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_GROUP               = "Other Attributes"
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_TAGS                = ""
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_DESCRIPTION         = "Altitude determined based on the atmospheric pressure according to the standard atmosphere laws"
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_UNIT                = "m"
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_LENGTH              = 1
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_RESOLUTION          = 0.01
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_MINIMUM             = -100.0
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_MAXIMUM             = 10000.0
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_DEFAULT             = 0.0
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_INVALID             = RDB_NO_INVALID_VALUE
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_NAMED_VALUES        = ""
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_LOD_SETTINGS        = "default"
RDB_RIEGL_BAROMETRIC_HEIGHT_AMSL_SCALE               = 1.0

# Distance between point and a reference surface (values less than -2000.0 mean no distance available)
RDB_RIEGL_DISTANCE_TO_SURFACE                     = "riegl.distance_to_surface"
RDB_RIEGL_DISTANCE_TO_SURFACE_NAME                = "riegl.distance_to_surface"
RDB_RIEGL_DISTANCE_TO_SURFACE_TITLE               = "Distance to Surface"
RDB_RIEGL_DISTANCE_TO_SURFACE_GROUP               = "Other Attributes"
RDB_RIEGL_DISTANCE_TO_SURFACE_TAGS                = ""
RDB_RIEGL_DISTANCE_TO_SURFACE_DESCRIPTION         = "Distance between point and a reference surface (values less than -2000.0 mean no distance available)"
RDB_RIEGL_DISTANCE_TO_SURFACE_UNIT                = "m"
RDB_RIEGL_DISTANCE_TO_SURFACE_LENGTH              = 1
RDB_RIEGL_DISTANCE_TO_SURFACE_RESOLUTION          = 0.00025
RDB_RIEGL_DISTANCE_TO_SURFACE_MINIMUM             = -2100.0
RDB_RIEGL_DISTANCE_TO_SURFACE_MAXIMUM             = 2000.0
RDB_RIEGL_DISTANCE_TO_SURFACE_DEFAULT             = -2100.0
RDB_RIEGL_DISTANCE_TO_SURFACE_INVALID             = -2100.0
RDB_RIEGL_DISTANCE_TO_SURFACE_NAMED_VALUES        = ""
RDB_RIEGL_DISTANCE_TO_SURFACE_STORAGE_CLASS       = RDB_STORAGE_VARIABLE
RDB_RIEGL_DISTANCE_TO_SURFACE_COMPRESSION_OPTIONS = RDB_COMPRESSION_SHUFFLE
RDB_RIEGL_DISTANCE_TO_SURFACE_LOD_SETTINGS        = "default"
RDB_RIEGL_DISTANCE_TO_SURFACE_SCALE               = 1.0
#
RDB_RIEGL_DISTANCE_TO_SURFACE_LOWEST = -2000.0

# Identifier of laser shot (0 = invalid). This is not an array index but the value of riegl.id of the laser shot.
RDB_RIEGL_SHOT_ID                     = "riegl.shot_id"
RDB_RIEGL_SHOT_ID_NAME                = "riegl.shot_id"
RDB_RIEGL_SHOT_ID_TITLE               = "Shot ID"
RDB_RIEGL_SHOT_ID_GROUP               = "Other Attributes"
RDB_RIEGL_SHOT_ID_TAGS                = ""
RDB_RIEGL_SHOT_ID_DESCRIPTION         = "Identifier of laser shot (0 = invalid). This is not an array index but the value of riegl.id of the laser shot."
RDB_RIEGL_SHOT_ID_UNIT                = ""
RDB_RIEGL_SHOT_ID_LENGTH              = 1
RDB_RIEGL_SHOT_ID_RESOLUTION          = 1.0
RDB_RIEGL_SHOT_ID_MINIMUM             = 0.0
RDB_RIEGL_SHOT_ID_MAXIMUM             = 1.0e12
RDB_RIEGL_SHOT_ID_DEFAULT             = 0.0
RDB_RIEGL_SHOT_ID_INVALID             = 0.0
RDB_RIEGL_SHOT_ID_NAMED_VALUES        = ""
RDB_RIEGL_SHOT_ID_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_SHOT_ID_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_SHOT_ID_LOD_SETTINGS        = "default"
RDB_RIEGL_SHOT_ID_SCALE               = 1.0
#
RDB_RIEGL_SHOT_ID_INVALID = 0

# Identifier of waveform sample block (0 = invalid). This is not an array index but the value of riegl.id of the block.
RDB_RIEGL_WFM_SBL_ID                     = "riegl.wfm_sbl_id"
RDB_RIEGL_WFM_SBL_ID_NAME                = "riegl.wfm_sbl_id"
RDB_RIEGL_WFM_SBL_ID_TITLE               = "Waveform Sample Block ID"
RDB_RIEGL_WFM_SBL_ID_GROUP               = "Other Attributes"
RDB_RIEGL_WFM_SBL_ID_TAGS                = ""
RDB_RIEGL_WFM_SBL_ID_DESCRIPTION         = "Identifier of waveform sample block (0 = invalid). This is not an array index but the value of riegl.id of the block."
RDB_RIEGL_WFM_SBL_ID_UNIT                = ""
RDB_RIEGL_WFM_SBL_ID_LENGTH              = 1
RDB_RIEGL_WFM_SBL_ID_RESOLUTION          = 1.0
RDB_RIEGL_WFM_SBL_ID_MINIMUM             = 0.0
RDB_RIEGL_WFM_SBL_ID_MAXIMUM             = 1.0e12
RDB_RIEGL_WFM_SBL_ID_DEFAULT             = 0.0
RDB_RIEGL_WFM_SBL_ID_INVALID             = 0.0
RDB_RIEGL_WFM_SBL_ID_NAMED_VALUES        = ""
RDB_RIEGL_WFM_SBL_ID_STORAGE_CLASS       = RDB_STORAGE_CONSTANT
RDB_RIEGL_WFM_SBL_ID_COMPRESSION_OPTIONS = RDB_COMPRESSION_DELTA
RDB_RIEGL_WFM_SBL_ID_LOD_SETTINGS        = "default"
RDB_RIEGL_WFM_SBL_ID_SCALE               = 1.0
#
RDB_RIEGL_WFM_SBL_ID_INVALID = 0
