# -*- coding: utf-8 -*-
#
#*******************************************************************************
#
#  Copyright 2022 RIEGL Laser Measurement Systems
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#
#  SPDX-License-Identifier: Apache-2.0
#
#*******************************************************************************
#
"""
Basic RDB data types
"""

import enum


class DataType(enum.IntEnum):
    NONE = 0  # undefined data type
    UINT8 = 1  # 8 bit unsigned integer
    INT8 = 2  # 8 bit signed integer
    UINT16 = 3  # 16 bit unsigned integer
    INT16 = 4  # 16 bit signed integer
    UINT32 = 5  # 32 bit unsigned integer
    INT32 = 6  # 32 bit signed integer
    UINT64 = 7  # 64 bit unsigned integer
    INT64 = 8  # 64 bit signed integer
    SINGLE = 9  # 32 bit single precision floating point value
    DOUBLE = 10  # bit double precision floating point value


def is_signed_integer(value):
    """
    Returns True if the given data type is a signed integer
    """
    if value == DataType.INT8:  return True
    if value == DataType.INT16: return True
    if value == DataType.INT32: return True
    if value == DataType.INT64: return True
    return False


def is_unsigned_integer(value):
    """
    Returns True if the given data type is an unsigned integer
    """
    if value == DataType.UINT8:  return True
    if value == DataType.UINT16: return True
    if value == DataType.UINT32: return True
    if value == DataType.UINT64: return True
    return False


def is_real_value(value):
    """
    Returns True if the given data type is a real (floating point) value
    """
    if value == DataType.SINGLE: return True
    if value == DataType.DOUBLE: return True
    return False
