# -*- coding: utf-8 -*-
#
#*******************************************************************************
#
#  Copyright 2022 RIEGL Laser Measurement Systems
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#
#  SPDX-License-Identifier: Apache-2.0
#
#*******************************************************************************
#
"""
Python interface to RDB library
"""

from riegl.rdb.version import *
from riegl.rdb.attributebuffer import AttributeBuffer
from riegl.rdb.context import Context
from riegl.rdb.createsettings import CreateSettings
from riegl.rdb.error import Error
from riegl.rdb.metadata import MetaData
from riegl.rdb.opensettings import OpenSettings
from riegl.rdb.pointattribute import PointAttribute
from riegl.rdb.pointattributes import PointAttributes
from riegl.rdb.pointbuffer import PointBuffer
from riegl.rdb.pointcloud import Pointcloud, rdb_open, rdb_create
from riegl.rdb.queryfill import QueryFill
from riegl.rdb.queryinsert import QueryInsert
from riegl.rdb.queryinvert import QueryInvert
from riegl.rdb.queryremove import QueryRemove
from riegl.rdb.queryselect import QuerySelect
from riegl.rdb.querystat import QueryStat
from riegl.rdb.queryupdate import QueryUpdate
from riegl.rdb.transactions import Transaction
from riegl.rdb.changelog import Changelog
from . import datatypes
from . import library

from riegl.rdb.defaultattributes import *
from riegl.rdb.defaultmetadata import *
from riegl.rdb.defaultschema import *

library.load()
