import json
from multiprocessing.spawn import old_main_modules
import sys
from types import NoneType
import riegl.rdb
import riegl.riegl_system_description as risd

def ReadRisd(risdpathlist):
    risdpath = risdpathlist[-1]
    with open(risdpath, 'r') as file:
        jrisd = json.load(file)
        strRisd = json.dumps(jrisd)
    document = risd.document_parse_json(strRisd)

    #Risd systems description
    versionrisd = document.version
    foa = document.system.field_of_application
    outputsys = "{0};{1}".format(versionrisd, foa)

   # print(outputsys)

    # Navigation device
    navdevcomponents = risd.search(document.system, risd.by_class(risd.NavigationDevice))
    for navdev in navdevcomponents:
        ndname = navdev.name

    ndcomponent = risd.find(document.system, risd.by_name(ndname) + risd.by_class(risd.NavigationDevice))
    nddevicetype = ndcomponent.device.device_type
    outputnd = "{0};{1}".format(ndname, nddevicetype)
 #   print(outputnd)

    # Lidar device
    ldcomponents = risd.search(document.system, risd.by_class(risd.LidarDevice))
    for comp in ldcomponents:
        name = comp.name
        deviceGeom = comp.device_geometry
        for lg in deviceGeom:
            wavelength = lg.laser_wavelength
        component = risd.find(document.system, risd.by_name(name) + risd.by_class(risd.LidarDevice))
        devicetype = component.device.device_type
        channels = component.device.channel_number
        serialnum = component.device.serial_number

    if type(channels) == NoneType:
        channels = -1
        
    outputld = "{0};{1};{2};{3};{4}".format(name, devicetype, channels, serialnum, wavelength)
    #print(outputld)

    # Camera device
    camcomponents = risd.search(document.system, risd.by_class(risd.CameraDevice))
    for c in camcomponents:
        namecam = c.name
    #    print(namecam)
    
    output = "{0};{1};{2}".format(outputsys, outputnd, outputld)
    
    sys.stdout.write(output)


if __name__ == "__main__":
    ReadRisd(sys.argv)

